/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.assignment;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import prefuse.action.assignment.ColorAction;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ColorLib;
import prefuse.util.ColorMap;
import prefuse.util.DataLib;
import prefuse.util.MathLib;
import prefuse.visual.VisualItem;

public class DataColorAction
extends ColorAction {
    private String m_dataField;
    private int m_type;
    private int m_scale = 0;
    private int m_tempScale;
    private double[] m_dist;
    private int m_bins = -1;
    private Map m_omap;
    private Object[] m_olist;
    private ColorMap m_cmap = new ColorMap(null, 0.0, 1.0);
    private int[] m_palette;

    public DataColorAction(String string, String string2, int n, String string3) {
        super(string, string3);
        this.setDataType(n);
        this.setDataField(string2);
    }

    public DataColorAction(String string, String string2, int n, String string3, int[] nArray) {
        super(string, string3);
        this.setDataType(n);
        this.setDataField(string2);
        this.m_palette = nArray;
    }

    public String getDataField() {
        return this.m_dataField;
    }

    public void setDataField(String string) {
        this.m_dataField = string;
    }

    public int getDataType() {
        return this.m_type;
    }

    public void setDataType(int n) {
        if (n < 0 || n >= 3) {
            throw new IllegalArgumentException("Unrecognized data type: " + n);
        }
        this.m_type = n;
    }

    public int getScale() {
        return this.m_scale;
    }

    public void setScale(int n) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("Unrecognized scale value: " + n);
        }
        this.m_scale = n;
    }

    public int getBinCount() {
        return this.m_bins;
    }

    public void setBinCount(int n) {
        if (this.m_scale == 3 && n <= 0) {
            throw new IllegalArgumentException("The quantile scale can not be used without binning. Use a bin value greater than zero.");
        }
        this.m_bins = n;
    }

    public void setDefaultColor(int n) {
        throw new UnsupportedOperationException();
    }

    public void setOrdinalMap(Object[] objectArray) {
        this.m_olist = objectArray;
        this.m_omap = new HashMap();
        for (int i = 0; i < objectArray.length; ++i) {
            this.m_omap.put(objectArray[i], new Integer(i));
        }
    }

    protected void setup() {
        int n = 64;
        int[] nArray = this.m_palette;
        this.m_tempScale = this.m_scale;
        if (this.m_scale == 3 && this.m_bins <= 0) {
            Logger.getLogger(this.getClass().getName()).warning("Can't use quantile scale with no binning. Defaulting to linear scale. Set the bin value greater than zero to use a quantile scale.");
            this.m_scale = 0;
        }
        switch (this.m_type) {
            case 0: 
            case 1: {
                this.m_dist = this.getDistribution();
                n = this.m_omap.size();
                nArray = this.m_palette != null ? this.m_palette : this.createPalette(n);
                this.m_cmap.setColorPalette(nArray);
                this.m_cmap.setMinValue(this.m_dist[0]);
                this.m_cmap.setMaxValue(this.m_dist[1]);
                return;
            }
            case 2: {
                this.m_dist = this.getDistribution();
                n = this.m_bins > 0 ? this.m_bins : n;
                nArray = this.m_palette != null ? this.m_palette : this.createPalette(n);
                this.m_cmap.setColorPalette(nArray);
                this.m_cmap.setMinValue(0.0);
                this.m_cmap.setMaxValue(1.0);
                return;
            }
        }
    }

    protected void finish() {
        this.m_scale = this.m_tempScale;
    }

    protected double[] getDistribution() {
        TupleSet tupleSet = this.m_vis.getGroup(this.m_group);
        if (this.m_type == 2) {
            this.m_omap = null;
            if (this.m_scale == 3 && this.m_bins > 0) {
                double[] dArray = DataLib.toDoubleArray(tupleSet.tuples(), this.m_dataField);
                return MathLib.quantiles(this.m_bins, dArray);
            }
            double[] dArray = new double[]{DataLib.min(tupleSet, this.m_dataField).getDouble(this.m_dataField), DataLib.max(tupleSet, this.m_dataField).getDouble(this.m_dataField)};
            return dArray;
        }
        if (this.m_olist == null) {
            this.m_omap = DataLib.ordinalMap(tupleSet, this.m_dataField);
        }
        return new double[]{0.0, this.m_omap.size() - 1};
    }

    protected int[] createPalette(int n) {
        switch (this.m_type) {
            case 0: {
                return ColorLib.getCategoryPalette(n);
            }
        }
        return ColorLib.getGrayscalePalette(n);
    }

    public int getColor(VisualItem visualItem) {
        Object object = this.lookup(visualItem);
        if (object != null) {
            if (object instanceof ColorAction) {
                return ((ColorAction)object).getColor(visualItem);
            }
            if (object instanceof Integer) {
                return (Integer)object;
            }
            Logger.getLogger(this.getClass().getName()).warning("Unrecognized Object from predicate chain.");
        }
        switch (this.m_type) {
            case 2: {
                double d = visualItem.getDouble(this.m_dataField);
                double d2 = MathLib.interp(this.m_scale, d, this.m_dist);
                return this.m_cmap.getColor(d2);
            }
        }
        Integer n = (Integer)this.m_omap.get(visualItem.get(this.m_dataField));
        return this.m_cmap.getColor(n.doubleValue());
    }
}

