/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyTuple;

class PyStringMapIter
extends PyIterator {
    String[] keyTable;
    PyObject[] valTable;
    private int idx;
    private int type;
    public static final int KEYS = 0;
    public static final int VALUES = 1;
    public static final int ITEMS = 2;

    public PyStringMapIter(String[] stringArray, PyObject[] pyObjectArray) {
        this(stringArray, pyObjectArray, 0);
    }

    public PyStringMapIter(String[] stringArray, PyObject[] pyObjectArray, int n) {
        this.keyTable = stringArray;
        this.valTable = pyObjectArray;
        this.idx = 0;
        this.type = n;
    }

    public PyObject __iternext__() {
        int n = this.keyTable.length;
        while (this.idx < n) {
            String string = this.keyTable[this.idx];
            PyObject pyObject = this.valTable[this.idx];
            if (string != null && string != "<deleted key>" && pyObject != null) {
                ++this.idx;
                switch (this.type) {
                    case 1: {
                        return pyObject;
                    }
                    case 2: {
                        return new PyTuple(new PyObject[]{Py.newString(string), pyObject});
                    }
                }
                return Py.newString(string);
            }
            ++this.idx;
        }
        return null;
    }
}

