/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import prefuse.util.force.AbstractForce;
import prefuse.util.force.ForceItem;

public class DragForce
extends AbstractForce {
    private static String[] pnames = new String[]{"DragCoefficient"};
    public static final float DEFAULT_DRAG_COEFF = 0.01f;
    public static final float DEFAULT_MIN_DRAG_COEFF = 0.0f;
    public static final float DEFAULT_MAX_DRAG_COEFF = 0.1f;
    public static final int DRAG_COEFF = 0;

    public DragForce(float f) {
        this.params = new float[]{f};
        this.minValues = new float[]{0.0f};
        this.maxValues = new float[]{0.1f};
    }

    public DragForce() {
        this(0.01f);
    }

    public boolean isItemForce() {
        return true;
    }

    protected String[] getParameterNames() {
        return pnames;
    }

    public void getForce(ForceItem forceItem) {
        forceItem.force[0] = forceItem.force[0] - this.params[0] * forceItem.velocity[0];
        forceItem.force[1] = forceItem.force[1] - this.params[0] * forceItem.velocity[1];
    }
}

