#ifndef __vtkModelMirrorGUI_h
#define __vtkModelMirrorGUI_h

#include "vtkModelMirrorWin32Header.h"
#include "vtkSlicerModuleGUI.h"

#include "vtkMRMLScene.h"
#include "vtkModelMirrorLogic.h"
#include "vtkModelMirrorIcons.h"

class vtkKWFrame;
class vtkSlicerNodeSelectorWidget;
class vtkSlicerModuleCollapsibleFrame;
class vtkKWPushButton;
class vtkKWEntry;

class vtkIntArray;

class VTK_MODELMIRROR_EXPORT vtkModelMirrorGUI : public vtkSlicerModuleGUI
{
  public:
  static vtkModelMirrorGUI *New();
  vtkTypeMacro(vtkModelMirrorGUI,vtkSlicerModuleGUI);
  void PrintSelf(ostream& os, vtkIndent indent);

  // Description:
  // Set the logic pointer from parent class pointer.
  // Overloads implementation in vtkSlicerModulesGUI
  // to allow loadable modules.
  virtual void SetModuleLogic ( vtkSlicerLogic *logic )
  {
  this->SetLogic(reinterpret_cast<vtkModelMirrorLogic*> (logic)); 
  }

   // Description: Get/Set MRML node
  vtkGetObjectMacro (Logic, vtkModelMirrorLogic);
  vtkSetObjectMacro (Logic, vtkModelMirrorLogic);

  vtkGetObjectMacro ( SpecificationFrame, vtkSlicerModuleCollapsibleFrame );
  vtkSetObjectMacro ( SpecificationFrame, vtkSlicerModuleCollapsibleFrame );

  vtkGetObjectMacro ( ModelSelector, vtkSlicerNodeSelectorWidget );
  vtkGetObjectMacro ( ModelNameEntry, vtkKWEntry );
  vtkGetObjectMacro ( AxialMirrorButton, vtkKWPushButton );
  vtkGetObjectMacro ( SaggitalMirrorButton, vtkKWPushButton );
  vtkGetObjectMacro ( CoronalMirrorButton, vtkKWPushButton );
  vtkGetObjectMacro ( GoButton, vtkKWPushButton );
  vtkGetObjectMacro ( ModelMirrorIcons, vtkModelMirrorIcons );

  
  virtual void BuildGUI ( );
  virtual void TearDownGUI ( );

  vtkIntArray *NewObservableEvents();

  // Description:
  // Add obsereves to GUI widgets
  virtual void AddGUIObservers ( );

  // Description:
  // Remove obsereves to GUI widgets
  virtual void RemoveGUIObservers ( );
  virtual void RemoveMRMLNodeObservers ( );
  virtual void RemoveLogicObservers ( );
  
  // Description:
  // Pprocess events generated by Logic
  virtual void ProcessLogicEvents ( vtkObject *caller, unsigned long event,
                                  void *callData ){};

  // Description:
  // Pprocess events generated by GUI widgets
  virtual void ProcessGUIEvents ( vtkObject *caller, unsigned long event,
                                  void *callData );

  // Description:
  // Pprocess events generated by MRML
  virtual void ProcessMRMLEvents ( vtkObject *caller, unsigned long event, 
                                  void *callData);
  // Description:
  // Describe behavior at module startup and exit.
  virtual void Enter ( );
  virtual void Exit ( );
  virtual void Init ( );

  // Description:
  // Get the categorization of the module.  The category is used for
  // grouping modules together into menus.
  const char *GetCategory() const {return "Registration";}

  void SetMirrorPlaneToAxial();
  void SetMirrorPlaneToSaggital();
  void SetMirrorPlaneToCoronal();


protected:
  vtkModelMirrorGUI();
  ~vtkModelMirrorGUI();
  vtkModelMirrorGUI(const vtkModelMirrorGUI&);
  void operator=(const vtkModelMirrorGUI&);

  // Description:
  // Updates GUI widgets based on parameters values in MRML node
  void UpdateGUI();

  // Description:
  // updates status text in the slicer window.
  void SetSlicerText( const char *txt);

  vtkModelMirrorLogic *Logic;
  vtkSlicerModuleCollapsibleFrame *SpecificationFrame;
  vtkSlicerNodeSelectorWidget *ModelSelector;
  vtkKWEntry *ModelNameEntry;
  
  vtkKWPushButton *AxialMirrorButton;
  vtkKWPushButton *CoronalMirrorButton;
  vtkKWPushButton *SaggitalMirrorButton;

  vtkKWPushButton *GoButton;
  
  vtkModelMirrorIcons *ModelMirrorIcons;
  
  int UpdatingGUI;
  int UpdatingMRML;

 
  // Description:
  // This flag gets set when the module is entered,
  // and unset when the module is exited. It is used
  // to put observers on and off the MRML Scene.
  bool Raised;

};

#endif

