/*=auto=======================================================================

  Portions (c) Copyright 2005 Brigham and Women's Hospital (BWH) All Rights
  Reserved.

  See Doc/copyright/copyright.txt
  or http://www.slicer.org/copyright/copyright.txt for details.

  Program:   3D Slicer
  Module:    $RCSfile: vtkAtlasCreatorGUI.h,v $
  Date:      $Date: 2006/03/19 17:12:29 $
  Version:   $Revision: 1.3 $
  Author:    $Sylvain Jaume (MIT)$

=======================================================================auto=*/

#ifndef __vtkAtlasCreatorGUI_h
#define __vtkAtlasCreatorGUI_h

#include "vtkSlicerBaseGUIWin32Header.h"
#include "vtkSlicerModuleGUI.h"

#include "vtkMRMLScene.h"
#include "vtkAtlasCreatorLogic.h"

class vtkSlicerSliceWidget;
class vtkKWFrame;
class vtkKWScaleWithEntry;
class vtkKWPushButton;
class vtkKWFrameWithLabel;
class vtkKWSpinBoxWithLabel;
class vtkKWRenderWidget;
class vtkImageViewer2;
class vtkImageResample;
class vtkImageThreshold;
class vtkImageSeedConnectivity;
class vtkSlicerNodeSelectorWidget;
class vtkSlicerApplicationLogic;

class VTK_AtlasCreator_EXPORT vtkAtlasCreatorGUI :
  public vtkSlicerModuleGUI
{
  public:
  static vtkAtlasCreatorGUI *New();
  vtkTypeMacro(vtkAtlasCreatorGUI,vtkSlicerModuleGUI);
  void PrintSelf(ostream& os, vtkIndent indent);

  // Description: Get/Set MRML node
  vtkGetObjectMacro(Logic, vtkAtlasCreatorLogic);
  vtkSetObjectMacro(Logic, vtkAtlasCreatorLogic);

  // Description:
  // Set the logic pointer from parent class pointer.
  // Overloads implementation in vtkSlicerModulesGUI
  // to allow loadable modules.
  virtual void SetModuleLogic( vtkSlicerLogic *logic )
    {
    this->SetLogic(reinterpret_cast<vtkAtlasCreatorLogic*>(logic));
    }

  // Description: Get/Set MRML node
  vtkGetObjectMacro(AtlasCreatorNode,
      vtkMRMLAtlasCreatorNode);

  // Description:
  // Create widgets
  virtual void BuildGUI();

  // Description:
  // Add observers to GUI widgets
  virtual void AddGUIObservers();

  // Description:
  // Remove observers to GUI widgets
  virtual void RemoveGUIObservers();

  // Description:
  // Process events generated by Logic
  virtual void ProcessLogicEvents( vtkObject *caller, unsigned long
      event, void *callData) {};

  // Description:
  // Pprocess events generated by GUI widgets
  virtual void ProcessGUIEvents( vtkObject *caller, unsigned long event,
    void *callData);

  // Description:
  // Process events generated by MRML
  virtual void ProcessMRMLEvents( vtkObject *caller, unsigned long event,
    void *callData);

  // Description:
  // Describe behavior at module startup and exit.
  virtual void Enter() {};
  virtual void Exit()  {};

  // Description:
  // Get the categorization of the module.  The category is used for
  // grouping modules together into menus.
  const char *GetCategory() const {return "Segmentation";}

protected:
  vtkAtlasCreatorGUI();
  virtual ~vtkAtlasCreatorGUI();
  vtkAtlasCreatorGUI(const vtkAtlasCreatorGUI&);
  void operator=(const vtkAtlasCreatorGUI&);

  // Description:
  // Updates GUI widgets based on parameters values in MRML node
  void UpdateGUI();

  // Description:
  // Updates parameters values in MRML node based on GUI widgets
  void UpdateMRML();

  vtkKWScaleWithEntry               *SliceScale;
  vtkKWScaleWithEntry               *SecondLabelMapThresholdScale;
  vtkKWScaleWithEntry               *OutputSizeScale;

  vtkSlicerNodeSelectorWidget       *VolumeSelector;
  vtkSlicerNodeSelectorWidget       *OutVolumeSelector;
  vtkSlicerNodeSelectorWidget       *NodeSelector;
  vtkSlicerNodeSelectorWidget       *ThirdLabelMapVolumeSelector;
  vtkSlicerNodeSelectorWidget       *SecondLabelMapVolumeSelector;

  vtkKWPushButton                   *ApplyButton;

  vtkAtlasCreatorLogic              *Logic;
  vtkMRMLAtlasCreatorNode           *AtlasCreatorNode;

  vtkKWFrameWithLabel               *VolumeSelectionFrame;
  vtkKWFrameWithLabel               *ParametersFrame;
  vtkKWFrameWithLabel               *AdvancedParametersFrame;

  vtkImageResample                  *ImageResample;
  vtkImageThreshold                 *ImageThreshold;
  vtkImageSeedConnectivity          *ImageSeedConnectivity;
  vtkImageViewer2                   *ImageViewer2;
  vtkKWRenderWidget                 *RenderWidget;
};

#endif

