/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.awt.BasicStroke;
import prefuse.util.collections.IntObjectHashMap;

public class StrokeLib {
    private static final IntObjectHashMap strokeMap = new IntObjectHashMap();
    private static int misses = 0;
    private static int lookups = 0;
    public static final float[] DOTS = new float[]{1.0f, 2.0f};
    public static final float[] DASHES = new float[]{5.0f, 5.0f};
    public static final float[] LONG_DASHES = new float[]{10.0f, 10.0f};

    public static BasicStroke getStroke(float f) {
        return StrokeLib.getStroke(f, 2, 0);
    }

    public static BasicStroke getStroke(float f, float[] fArray) {
        return StrokeLib.getStroke(f, 2, 0, 10.0f, fArray, 0.0f);
    }

    public static BasicStroke getStroke(float f, int n, int n2) {
        return StrokeLib.getStroke(f, n, n2, 10.0f, null, 0.0f);
    }

    public static BasicStroke getStroke(float f, int n, int n2, float f2, float[] fArray, float f3) {
        int n3 = StrokeLib.getStrokeKey(f, n, n2, f2, fArray, f3);
        BasicStroke basicStroke = null;
        basicStroke = (BasicStroke)strokeMap.get(n3);
        if (basicStroke == null) {
            basicStroke = new BasicStroke(f, n, n2, f2, fArray, f3);
            strokeMap.put(n3, basicStroke);
            ++misses;
        }
        ++lookups;
        return basicStroke;
    }

    protected static int getStrokeKey(float f, int n, int n2, float f2, float[] fArray, float f3) {
        int n3 = Float.floatToIntBits(f);
        n3 = n3 * 31 + n2;
        n3 = n3 * 31 + n;
        n3 = n3 * 31 + Float.floatToIntBits(f2);
        if (fArray != null) {
            n3 = n3 * 31 + Float.floatToIntBits(f3);
            for (int i = 0; i < fArray.length; ++i) {
                n3 = n3 * 31 + Float.floatToIntBits(fArray[i]);
            }
        }
        return n3;
    }

    public static BasicStroke getDerivedStroke(BasicStroke basicStroke, float f) {
        if (basicStroke.getLineWidth() == f) {
            return basicStroke;
        }
        return StrokeLib.getStroke(f * basicStroke.getLineWidth(), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase());
    }

    public static int getCacheMissCount() {
        return misses;
    }

    public static int getCacheLookupCount() {
        return lookups;
    }

    public static void clearCache() {
        strokeMap.clear();
    }
}

