//=============================================================================
//
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//
//=============================================================================
#include "smtk/task/Registrar.h"

#include "smtk/task/Adaptor.h"
#include "smtk/task/FillOutAttributes.h"
#include "smtk/task/GatherResources.h"
#include "smtk/task/Group.h"
#include "smtk/task/SubmitOperation.h"
#include "smtk/task/Task.h"
#include "smtk/task/adaptor/ConfigureOperation.h"
#include "smtk/task/adaptor/ResourceAndRole.h"
#include "smtk/task/json/Configurator.h"
#include "smtk/task/json/Configurator.txx"
#include "smtk/task/json/jsonAdaptor.h"
#include "smtk/task/json/jsonConfigureOperation.h"
#include "smtk/task/json/jsonFillOutAttributes.h"
#include "smtk/task/json/jsonGatherResources.h"
#include "smtk/task/json/jsonGroup.h"
#include "smtk/task/json/jsonResourceAndRole.h"
#include "smtk/task/json/jsonSubmitOperation.h"
#include "smtk/task/json/jsonTask.h"

#include "smtk/task/operators/AddDependency.h"
#include "smtk/task/operators/EmplaceWorklet.h"
#include "smtk/task/operators/RemoveDependency.h"
#include "smtk/task/operators/RenameTask.h"

#include "smtk/operation/groups/ArcCreator.h"

#include "smtk/plugin/Manager.h"

#include <tuple>

namespace smtk
{
namespace task
{

using TaskList = std::tuple<Task, FillOutAttributes, GatherResources, Group, SubmitOperation>;
using TaskJSON = std::tuple<
  json::jsonTask,
  json::jsonFillOutAttributes,
  json::jsonGatherResources,
  json::jsonGroup,
  json::jsonSubmitOperation>;
using AdaptorList = std::tuple<adaptor::ConfigureOperation, adaptor::ResourceAndRole>;
using AdaptorJSON = std::tuple<json::jsonConfigureOperation, json::jsonResourceAndRole>;

using OperationList = std::tuple<AddDependency, EmplaceWorklet, RemoveDependency, RenameTask>;

void Registrar::registerTo(const smtk::task::Manager::Ptr& taskManager)
{
  auto& taskInstances = taskManager->taskInstances();
  taskInstances.registerTypes<TaskList>();
  json::Configurator<Task>::registerTypes<TaskList, TaskJSON>();

  auto& adaptorInstances = taskManager->adaptorInstances();
  adaptorInstances.registerTypes<AdaptorList>();
  json::Configurator<Adaptor>::registerTypes<AdaptorList, AdaptorJSON>();
}

void Registrar::unregisterFrom(const smtk::task::Manager::Ptr& taskManager)
{
  auto& taskInstances = taskManager->taskInstances();
  taskInstances.unregisterTypes<TaskList>();
  json::Configurator<Task>::unregisterTypes<TaskList>();

  auto& adaptorInstances = taskManager->adaptorInstances();
  adaptorInstances.unregisterTypes<AdaptorList>();
  json::Configurator<Adaptor>::unregisterTypes<AdaptorList>();
}

void Registrar::registerTo(const smtk::operation::Manager::Ptr& operationManager)
{
  operationManager->registerOperations<OperationList>();

  smtk::operation::ArcCreator arcCreator(operationManager);
  arcCreator.registerOperation<smtk::task::AddDependency>({ "task dependency" });
}

void Registrar::unregisterFrom(const smtk::operation::Manager::Ptr& operationManager)
{
  operationManager->unregisterOperations<OperationList>();

  smtk::operation::ArcCreator arcCreator(operationManager);
  arcCreator.unregisterOperation<smtk::task::AddDependency>();
}

} // namespace task
} // namespace smtk
