/*=========================================================================

Program:   ParaView
Module:    TestSMThreadedClient.cxx

Copyright (c) Kitware, Inc.
All rights reserved.
See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

This software is distributed WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "vtkInitializationHelper.h"
#include "vtkPVOptions.h"
#include "vtkProcessModule.h"
#include "vtkSMSession.h"
#include "vtkSMSessionProxyManager.h"
#include "vtkSMSourceProxy.h"
#include "vtkPVDataInformation.h"
#include "vtkSMPropertyHelper.h"
#include "vtkNew.h"
#include "vtkSMParaViewPipelineControllerWithRendering.h"
#include "vtkSMRenderViewProxy.h"
#include "vtkRenderWindowInteractor.h"

int TestSMThreadedClient(int argc, char *argv[])
{
  vtkPVOptions* options = vtkPVOptions::New();
  vtkInitializationHelper::Initialize(argc, argv,
                                      vtkProcessModule::PROCESS_CLIENT,
                                      options);

  vtkIdType cid = vtkSMSession::ConnectToThreadedClientServer();
  vtkSMSession* session = vtkSMSession::SafeDownCast(
    vtkProcessModule::GetProcessModule()->GetSession(cid));
  cout << "Client ready" << endl;
  vtkSMSessionProxyManager* pxm = session->GetSessionProxyManager();
  vtkSMSourceProxy* sphere = vtkSMSourceProxy::SafeDownCast(pxm->NewProxy("sources", "SphereSource"));
  sphere->UpdateVTKObjects();
  sphere->UpdatePipeline();
  cout << "=================================================" << endl;
  sphere->GetDataInformation(0)->Print(cout);


  vtkSMSourceProxy* shrink = vtkSMSourceProxy::SafeDownCast(pxm->NewProxy("filters", "ShrinkFilter"));
  vtkSMPropertyHelper(shrink, "Input").Set(sphere);
  shrink->UpdateVTKObjects();
  shrink->UpdatePipeline();
  cout << "=================================================" << endl;
  shrink->GetDataInformation(0)->Print(cout);

  vtkSMRenderViewProxy* view = vtkSMRenderViewProxy::SafeDownCast(pxm->NewProxy("views", "RenderView"));
  view->UpdateVTKObjects();
  view->MakeRenderWindowInteractor();
  view->StillRender();

  vtkNew<vtkSMParaViewPipelineControllerWithRendering> controller;
  controller->Show(shrink, 0, view);
  view->StillRender();
  view->GetInteractor()->Start();

  view->Delete();
  shrink->Delete();
  sphere->Delete();

  vtkSMSession::Disconnect(cid);
  vtkInitializationHelper::Finalize();
  options->Delete();
  return 0;
}
