/*=========================================================================

  Program:   ParaView
  Module:    vtkSMThreadedSession.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkSMThreadedSession
// .SECTION Description
//

#ifndef __vtkSMThreadedSession_h
#define __vtkSMThreadedSession_h

#include "vtkPVServerManagerCoreModule.h" //needed for exports
#include "vtkSMSessionClient.h"

class VTKPVSERVERMANAGERCORE_EXPORT vtkSMThreadedSession : public vtkSMSessionClient
{
public:
  static vtkSMThreadedSession* New();
  vtkTypeMacro(vtkSMThreadedSession, vtkSMSessionClient);
  void PrintSelf(ostream& os, vtkIndent indent);

  virtual bool Connect(const char* url);

#if 0
  // Description:
  // This process will report the role of CLIENT and RENDER_SERVER.
  // I wonder is this process should only report itself as client, however.
  // Since CLIENT does exactly what this process supports anyways.
  virtual ServerFlags GetProcessRoles()
    { return CLIENT | RENDER_SERVER; }

//BTX
  // Description:
  // Push the state message. Overridden to ensure that the information in the
  // undo-redo state manager is updated.
  virtual void PushState(vtkSMMessage* msg);

  // Description:
  // Sends the message to all clients.
  virtual void NotifyAllClients(const vtkSMMessage* msg)
    { this->ProcessNotification(msg); }

  // Description:
  // Sends the message to all but the active client-session.
  virtual void NotifyOtherClients(const vtkSMMessage*)
    { /* nothing to do. */ }
//ETX

  // Description:
  // Gather information about an object referred by the \c globalid.
  // \c location identifies the processes to gather the information from.
  virtual bool GatherInformation(vtkTypeUInt32 location,
    vtkPVInformation* information, vtkTypeUInt32 globalid);
#endif
//BTX
protected:
  vtkSMThreadedSession();
  ~vtkSMThreadedSession();

private:
  vtkSMThreadedSession(const vtkSMThreadedSession&); // Not implemented
  void operator=(const vtkSMThreadedSession&); // Not implemented

  class vtkInternals;
  vtkInternals* Internals;
//ETX
};

#endif
