/*=========================================================================

  Program:   ParaView
  Module:    vtkZeroMQController.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkZeroMQController
// .SECTION Description
//

#ifndef __vtkZeroMQController_h
#define __vtkZeroMQController_h

#include "vtkPVServerImplementationCoreModule.h" //needed for exports
#include "vtkMultiProcessController.h"

class VTKPVSERVERIMPLEMENTATIONCORE_EXPORT vtkZeroMQController : public vtkMultiProcessController
{
public:
  static vtkZeroMQController* New();
  vtkTypeMacro(vtkZeroMQController, vtkMultiProcessController);
  void PrintSelf(ostream& os, vtkIndent indent);

  // Description:
  // This method is for initialiazing sockets.
  // One of these is REQUIRED for Windows.
  virtual void Initialize(int* argc, char*** argv, int)
    { this->Initialize(argc,argv); }
  virtual void Initialize(int* argc, char*** argv);
  virtual void Initialize()
    { this->Initialize(0,0); }

  // Description:
  // Does not apply to sockets. Does nothing.
  void Finalize() {}
  void Finalize(int) {}

  // Description:
  //  Does not apply to sockets. Does nothing.
  void SingleMethodExecute() {}

  // Description:
  //  Does not apply to sockets.  Does nothing.
  void MultipleMethodExecute() {}

  // Description:
  //  Does not apply to sockets. Does nothing.
  void CreateOutputWindow() {}

  bool Connect(const char* url);
  bool Bind(const char* url);

//BTX
protected:
  vtkZeroMQController();
  ~vtkZeroMQController();

  // Initialize only once, finialize on destruction.
  static int Initialized;

private:
  vtkZeroMQController(const vtkZeroMQController&); // Not implemented
  void operator=(const vtkZeroMQController&); // Not implemented
//ETX
};

#endif
