/*=========================================================================

  Program:   ParaView
  Module:    vtkZeroMQCommunicator.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkZeroMQCommunicator
// .SECTION Description
//

#ifndef __vtkZeroMQCommunicator_h
#define __vtkZeroMQCommunicator_h

#include "vtkCommunicator.h"
#include "vtkPVServerImplementationCoreModule.h" //needed for exports

namespace zmq
{
  class context_t;
  class socket_t;
}

class vtkSimpleMutexLock;

class VTKPVSERVERIMPLEMENTATIONCORE_EXPORT vtkZeroMQCommunicator : public vtkCommunicator
{
public:
  static vtkZeroMQCommunicator* New();
  vtkTypeMacro(vtkZeroMQCommunicator, vtkCommunicator);
  void PrintSelf(ostream& os, vtkIndent indent);

  void SetContext(zmq::context_t* context);
  bool Connect(const char* url);
  bool Bind(const char* url);


  virtual int SendVoidArray(
    const void *data, vtkIdType length, int type, int remoteHandle, int tag);
  virtual int ReceiveVoidArray(
    void *data, vtkIdType maxlength, int type, int remoteHandle, int tag);
//BTX
protected:
  vtkZeroMQCommunicator();
  ~vtkZeroMQCommunicator();

  zmq::context_t* Context;
  zmq::socket_t* SocketSend;
  zmq::socket_t* SocketReceive;

  vtkSimpleMutexLock* Lock;

private:
  vtkZeroMQCommunicator(const vtkZeroMQCommunicator&); // Not implemented
  void operator=(const vtkZeroMQCommunicator&); // Not implemented
//ETX
};

#endif
