/*=========================================================================

  Program:   ParaView
  Module:    vtkPVThreadedSessionServer.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkPVThreadedSessionServer
// .SECTION Description
//

#ifndef __vtkPVThreadedSessionServer_h
#define __vtkPVThreadedSessionServer_h

#include "vtkPVServerImplementationCoreModule.h" //needed for exports
#include "vtkPVSessionServer.h"

class VTKPVSERVERIMPLEMENTATIONCORE_EXPORT vtkPVThreadedSessionServer : public vtkPVSessionServer
{
public:
  static vtkPVThreadedSessionServer* New();
  vtkTypeMacro(vtkPVThreadedSessionServer, vtkPVSessionServer);
  void PrintSelf(ostream& os, vtkIndent indent);

  virtual bool Connect(const char* url);

  void ProcessEvents();

  // Description:
  // Returns a ServerFlags indicate the nature of the current processes. e.g. if
  // the current processes acts as a data-server and a render-server, it returns
  // DATA_SERVER | RENDER_SERVER. The implementation provided is suitable for
  // server processes such as pvserver, pvdataserver (both root and satellites).
  virtual ServerFlags GetProcessRoles() { return vtkPVSession::SERVERS;}

  virtual void NotifyAllClients(const vtkSMMessage*){}
  virtual void NotifyOtherClients(const vtkSMMessage*){}
  virtual bool GetIsAlive() { return true; }

//BTX
protected:
  vtkPVThreadedSessionServer();
  ~vtkPVThreadedSessionServer();

  vtkMultiProcessController* ZeroMQController;

private:
  vtkPVThreadedSessionServer(const vtkPVThreadedSessionServer&); // Not implemented
  void operator=(const vtkPVThreadedSessionServer&); // Not implemented
//ETX
};

#endif
