/*=========================================================================

  Program:   ParaView
  Module:    vtkPVThreadedSessionServer.cxx

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkPVThreadedSessionServer.h"

#include "vtkObjectFactory.h"
#include "vtkNew.h"
#include "vtkZeroMQController.h"

vtkStandardNewMacro(vtkPVThreadedSessionServer);
//----------------------------------------------------------------------------
vtkPVThreadedSessionServer::vtkPVThreadedSessionServer()
{
  this->ZeroMQController = NULL;
}

//----------------------------------------------------------------------------
vtkPVThreadedSessionServer::~vtkPVThreadedSessionServer()
{
  this->ZeroMQController = NULL;
}

//----------------------------------------------------------------------------
bool vtkPVThreadedSessionServer::Connect(const char* url)
{
  vtkNew<vtkZeroMQController> controller;
  controller->Connect(url);
  controller->SetNumberOfProcesses(2);
  this->RegisterController(controller.GetPointer());
  this->ZeroMQController = controller.GetPointer();
}

//----------------------------------------------------------------------------
void vtkPVThreadedSessionServer::ProcessEvents()
{
  this->ZeroMQController->ProcessRMIs(/*report errors*/1);
}

//----------------------------------------------------------------------------
void vtkPVThreadedSessionServer::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}
