# this file determines binary dependencies for ParaView and install thems.

# dependencies_root == directory where dependecies are installed.
# target_root == root directory where files are to be installed.

include(GetPrerequisites)

get_filename_component(exepath "${executable}" PATH)
get_filename_component(exename "${executable}" NAME)

message("Determining dependencies for '${exename}'")
get_prerequisites(
  ${executable}
  prerequisites
  1
  1
  ${exepath}
  ${dependencies_root}/lib
  )

message("Installing dependencies for '${exename}'")

get_filename_component(resolved_deproot "${dependencies_root}" REALPATH)

# resolve symlinks.
set (resolved_prerequisites)
foreach(link ${prerequisites})
  if (NOT link MATCHES ".*fontconfig.*")
    get_filename_component(resolved_link "${link}" REALPATH)
    if(NOT resolved_link MATCHES "^${resolved_deproot}/")
      continue()
    endif()
    if (IS_SYMLINK ${link})
      # now link may not directly point to resolved_link.
      # so we install the resolved link as the link.
      get_filename_component(resolved_name "${link}" NAME)
      file(INSTALL
        DESTINATION "${target_root}"
        TYPE PROGRAM
        RENAME "${resolved_name}"
        FILES "${resolved_link}")
    else ()
      list(APPEND resolved_prerequisites ${resolved_link})
    endif()
  endif()
endforeach()

file(INSTALL ${resolved_prerequisites}
     DESTINATION ${target_root}
     USE_SOURCE_PERMISSIONS)
