/*=========================================================================

  Program:   Visualization Toolkit
  Module:    TestAnariVolumeWavelet.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

  This software is distributed WITHOUT ANY WARRANTY; without even
  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

// Description
// This is a basic test that creates and volume renders the wavelet dataset.

#include "vtkCamera.h"
#include "vtkColorTransferFunction.h"
#include "vtkGPUVolumeRayCastMapper.h"
#include "vtkImageData.h"
#include "vtkInteractorEventRecorder.h"
#include "vtkInteractorStyleTrackballCamera.h"
#include "vtkLogger.h"
#include "vtkNew.h"
#include "vtkPiecewiseFunction.h"
#include "vtkRTAnalyticSource.h"
#include "vtkRegressionTestImage.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkRenderer.h"
#include "vtkTestErrorObserver.h"
#include "vtkTesting.h"
#include "vtkTimerLog.h"
#include "vtkVolume.h"
#include "vtkVolumeProperty.h"

#include "vtkAnariPass.h"
#include "vtkAnariRendererNode.h"

static const char* TestAnariVolumeWaveletLog = "# StreamVersion 1\n"
                                               "EnterEvent 299 0 0 0 0 0 0\n"
                                               "MouseMoveEvent 218 272 0 0 0 0 0\n"
                                               "LeftButtonPressEvent 218 272 0 0 0 0 0\n"
                                               "StartInteractionEvent 218 272 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 273 0 0 0 0 0\n"
                                               "RenderEvent 219 273 0 0 0 0 0\n"
                                               "InteractionEvent 219 273 0 0 0 0 0\n"
                                               "MouseMoveEvent 220 272 0 0 0 0 0\n"
                                               "RenderEvent 220 272 0 0 0 0 0\n"
                                               "InteractionEvent 220 272 0 0 0 0 0\n"
                                               "MouseMoveEvent 220 271 0 0 0 0 0\n"
                                               "RenderEvent 220 271 0 0 0 0 0\n"
                                               "InteractionEvent 220 271 0 0 0 0 0\n"
                                               "MouseMoveEvent 221 270 0 0 0 0 0\n"
                                               "RenderEvent 221 270 0 0 0 0 0\n"
                                               "InteractionEvent 221 270 0 0 0 0 0\n"
                                               "MouseMoveEvent 221 269 0 0 0 0 0\n"
                                               "RenderEvent 221 269 0 0 0 0 0\n"
                                               "InteractionEvent 221 269 0 0 0 0 0\n"
                                               "MouseMoveEvent 221 268 0 0 0 0 0\n"
                                               "RenderEvent 221 268 0 0 0 0 0\n"
                                               "InteractionEvent 221 268 0 0 0 0 0\n"
                                               "MouseMoveEvent 221 266 0 0 0 0 0\n"
                                               "RenderEvent 221 266 0 0 0 0 0\n"
                                               "InteractionEvent 221 266 0 0 0 0 0\n"
                                               "MouseMoveEvent 221 265 0 0 0 0 0\n"
                                               "RenderEvent 221 265 0 0 0 0 0\n"
                                               "InteractionEvent 221 265 0 0 0 0 0\n"
                                               "MouseMoveEvent 222 263 0 0 0 0 0\n"
                                               "RenderEvent 222 263 0 0 0 0 0\n"
                                               "InteractionEvent 222 263 0 0 0 0 0\n"
                                               "MouseMoveEvent 222 262 0 0 0 0 0\n"
                                               "RenderEvent 222 262 0 0 0 0 0\n"
                                               "InteractionEvent 222 262 0 0 0 0 0\n"
                                               "MouseMoveEvent 222 258 0 0 0 0 0\n"
                                               "RenderEvent 222 258 0 0 0 0 0\n"
                                               "InteractionEvent 222 258 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 255 0 0 0 0 0\n"
                                               "RenderEvent 223 255 0 0 0 0 0\n"
                                               "InteractionEvent 223 255 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 253 0 0 0 0 0\n"
                                               "RenderEvent 223 253 0 0 0 0 0\n"
                                               "InteractionEvent 223 253 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 250 0 0 0 0 0\n"
                                               "RenderEvent 223 250 0 0 0 0 0\n"
                                               "InteractionEvent 223 250 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 248 0 0 0 0 0\n"
                                               "RenderEvent 223 248 0 0 0 0 0\n"
                                               "InteractionEvent 223 248 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 247 0 0 0 0 0\n"
                                               "RenderEvent 223 247 0 0 0 0 0\n"
                                               "InteractionEvent 223 247 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 246 0 0 0 0 0\n"
                                               "RenderEvent 223 246 0 0 0 0 0\n"
                                               "InteractionEvent 223 246 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 245 0 0 0 0 0\n"
                                               "RenderEvent 223 245 0 0 0 0 0\n"
                                               "InteractionEvent 223 245 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 244 0 0 0 0 0\n"
                                               "RenderEvent 223 244 0 0 0 0 0\n"
                                               "InteractionEvent 223 244 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 242 0 0 0 0 0\n"
                                               "RenderEvent 223 242 0 0 0 0 0\n"
                                               "InteractionEvent 223 242 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 241 0 0 0 0 0\n"
                                               "RenderEvent 223 241 0 0 0 0 0\n"
                                               "InteractionEvent 223 241 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 240 0 0 0 0 0\n"
                                               "RenderEvent 223 240 0 0 0 0 0\n"
                                               "InteractionEvent 223 240 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 238 0 0 0 0 0\n"
                                               "RenderEvent 223 238 0 0 0 0 0\n"
                                               "InteractionEvent 223 238 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 237 0 0 0 0 0\n"
                                               "RenderEvent 223 237 0 0 0 0 0\n"
                                               "InteractionEvent 223 237 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 235 0 0 0 0 0\n"
                                               "RenderEvent 223 235 0 0 0 0 0\n"
                                               "InteractionEvent 223 235 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 233 0 0 0 0 0\n"
                                               "RenderEvent 223 233 0 0 0 0 0\n"
                                               "InteractionEvent 223 233 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 232 0 0 0 0 0\n"
                                               "RenderEvent 223 232 0 0 0 0 0\n"
                                               "InteractionEvent 223 232 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 230 0 0 0 0 0\n"
                                               "RenderEvent 223 230 0 0 0 0 0\n"
                                               "InteractionEvent 223 230 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 228 0 0 0 0 0\n"
                                               "RenderEvent 223 228 0 0 0 0 0\n"
                                               "InteractionEvent 223 228 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 226 0 0 0 0 0\n"
                                               "RenderEvent 223 226 0 0 0 0 0\n"
                                               "InteractionEvent 223 226 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 223 0 0 0 0 0\n"
                                               "RenderEvent 223 223 0 0 0 0 0\n"
                                               "InteractionEvent 223 223 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 221 0 0 0 0 0\n"
                                               "RenderEvent 223 221 0 0 0 0 0\n"
                                               "InteractionEvent 223 221 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 220 0 0 0 0 0\n"
                                               "RenderEvent 223 220 0 0 0 0 0\n"
                                               "InteractionEvent 223 220 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 219 0 0 0 0 0\n"
                                               "RenderEvent 223 219 0 0 0 0 0\n"
                                               "InteractionEvent 223 219 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 217 0 0 0 0 0\n"
                                               "RenderEvent 223 217 0 0 0 0 0\n"
                                               "InteractionEvent 223 217 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 215 0 0 0 0 0\n"
                                               "RenderEvent 223 215 0 0 0 0 0\n"
                                               "InteractionEvent 223 215 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 214 0 0 0 0 0\n"
                                               "RenderEvent 223 214 0 0 0 0 0\n"
                                               "InteractionEvent 223 214 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 213 0 0 0 0 0\n"
                                               "RenderEvent 223 213 0 0 0 0 0\n"
                                               "InteractionEvent 223 213 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 212 0 0 0 0 0\n"
                                               "RenderEvent 223 212 0 0 0 0 0\n"
                                               "InteractionEvent 223 212 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 210 0 0 0 0 0\n"
                                               "RenderEvent 223 210 0 0 0 0 0\n"
                                               "InteractionEvent 223 210 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 209 0 0 0 0 0\n"
                                               "RenderEvent 223 209 0 0 0 0 0\n"
                                               "InteractionEvent 223 209 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 208 0 0 0 0 0\n"
                                               "RenderEvent 223 208 0 0 0 0 0\n"
                                               "InteractionEvent 223 208 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 206 0 0 0 0 0\n"
                                               "RenderEvent 223 206 0 0 0 0 0\n"
                                               "InteractionEvent 223 206 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 205 0 0 0 0 0\n"
                                               "RenderEvent 223 205 0 0 0 0 0\n"
                                               "InteractionEvent 223 205 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 204 0 0 0 0 0\n"
                                               "RenderEvent 223 204 0 0 0 0 0\n"
                                               "InteractionEvent 223 204 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 203 0 0 0 0 0\n"
                                               "RenderEvent 223 203 0 0 0 0 0\n"
                                               "InteractionEvent 223 203 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 202 0 0 0 0 0\n"
                                               "RenderEvent 223 202 0 0 0 0 0\n"
                                               "InteractionEvent 223 202 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 201 0 0 0 0 0\n"
                                               "RenderEvent 223 201 0 0 0 0 0\n"
                                               "InteractionEvent 223 201 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 200 0 0 0 0 0\n"
                                               "RenderEvent 223 200 0 0 0 0 0\n"
                                               "InteractionEvent 223 200 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 199 0 0 0 0 0\n"
                                               "RenderEvent 223 199 0 0 0 0 0\n"
                                               "InteractionEvent 223 199 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 198 0 0 0 0 0\n"
                                               "RenderEvent 223 198 0 0 0 0 0\n"
                                               "InteractionEvent 223 198 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 197 0 0 0 0 0\n"
                                               "RenderEvent 223 197 0 0 0 0 0\n"
                                               "InteractionEvent 223 197 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 196 0 0 0 0 0\n"
                                               "RenderEvent 223 196 0 0 0 0 0\n"
                                               "InteractionEvent 223 196 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 195 0 0 0 0 0\n"
                                               "RenderEvent 223 195 0 0 0 0 0\n"
                                               "InteractionEvent 223 195 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 194 0 0 0 0 0\n"
                                               "RenderEvent 223 194 0 0 0 0 0\n"
                                               "InteractionEvent 223 194 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 192 0 0 0 0 0\n"
                                               "RenderEvent 223 192 0 0 0 0 0\n"
                                               "InteractionEvent 223 192 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 191 0 0 0 0 0\n"
                                               "RenderEvent 223 191 0 0 0 0 0\n"
                                               "InteractionEvent 223 191 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 190 0 0 0 0 0\n"
                                               "RenderEvent 223 190 0 0 0 0 0\n"
                                               "InteractionEvent 223 190 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 189 0 0 0 0 0\n"
                                               "RenderEvent 223 189 0 0 0 0 0\n"
                                               "InteractionEvent 223 189 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 188 0 0 0 0 0\n"
                                               "RenderEvent 223 188 0 0 0 0 0\n"
                                               "InteractionEvent 223 188 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 187 0 0 0 0 0\n"
                                               "RenderEvent 223 187 0 0 0 0 0\n"
                                               "InteractionEvent 223 187 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 185 0 0 0 0 0\n"
                                               "RenderEvent 223 185 0 0 0 0 0\n"
                                               "InteractionEvent 223 185 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 183 0 0 0 0 0\n"
                                               "RenderEvent 223 183 0 0 0 0 0\n"
                                               "InteractionEvent 223 183 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 182 0 0 0 0 0\n"
                                               "RenderEvent 223 182 0 0 0 0 0\n"
                                               "InteractionEvent 223 182 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 181 0 0 0 0 0\n"
                                               "RenderEvent 223 181 0 0 0 0 0\n"
                                               "InteractionEvent 223 181 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 180 0 0 0 0 0\n"
                                               "RenderEvent 223 180 0 0 0 0 0\n"
                                               "InteractionEvent 223 180 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 178 0 0 0 0 0\n"
                                               "RenderEvent 223 178 0 0 0 0 0\n"
                                               "InteractionEvent 223 178 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 176 0 0 0 0 0\n"
                                               "RenderEvent 223 176 0 0 0 0 0\n"
                                               "InteractionEvent 223 176 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 175 0 0 0 0 0\n"
                                               "RenderEvent 223 175 0 0 0 0 0\n"
                                               "InteractionEvent 223 175 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 173 0 0 0 0 0\n"
                                               "RenderEvent 223 173 0 0 0 0 0\n"
                                               "InteractionEvent 223 173 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 172 0 0 0 0 0\n"
                                               "RenderEvent 223 172 0 0 0 0 0\n"
                                               "InteractionEvent 223 172 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 170 0 0 0 0 0\n"
                                               "RenderEvent 223 170 0 0 0 0 0\n"
                                               "InteractionEvent 223 170 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 169 0 0 0 0 0\n"
                                               "RenderEvent 223 169 0 0 0 0 0\n"
                                               "InteractionEvent 223 169 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 166 0 0 0 0 0\n"
                                               "RenderEvent 223 166 0 0 0 0 0\n"
                                               "InteractionEvent 223 166 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 165 0 0 0 0 0\n"
                                               "RenderEvent 223 165 0 0 0 0 0\n"
                                               "InteractionEvent 223 165 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 164 0 0 0 0 0\n"
                                               "RenderEvent 223 164 0 0 0 0 0\n"
                                               "InteractionEvent 223 164 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 162 0 0 0 0 0\n"
                                               "RenderEvent 223 162 0 0 0 0 0\n"
                                               "InteractionEvent 223 162 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 160 0 0 0 0 0\n"
                                               "RenderEvent 223 160 0 0 0 0 0\n"
                                               "InteractionEvent 223 160 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 158 0 0 0 0 0\n"
                                               "RenderEvent 223 158 0 0 0 0 0\n"
                                               "InteractionEvent 223 158 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 157 0 0 0 0 0\n"
                                               "RenderEvent 223 157 0 0 0 0 0\n"
                                               "InteractionEvent 223 157 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 156 0 0 0 0 0\n"
                                               "RenderEvent 223 156 0 0 0 0 0\n"
                                               "InteractionEvent 223 156 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 155 0 0 0 0 0\n"
                                               "RenderEvent 223 155 0 0 0 0 0\n"
                                               "InteractionEvent 223 155 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 154 0 0 0 0 0\n"
                                               "RenderEvent 223 154 0 0 0 0 0\n"
                                               "InteractionEvent 223 154 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 153 0 0 0 0 0\n"
                                               "RenderEvent 223 153 0 0 0 0 0\n"
                                               "InteractionEvent 223 153 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 152 0 0 0 0 0\n"
                                               "RenderEvent 223 152 0 0 0 0 0\n"
                                               "InteractionEvent 223 152 0 0 0 0 0\n"
                                               "LeftButtonReleaseEvent 223 152 0 0 0 0 0\n"
                                               "EndInteractionEvent 223 152 0 0 0 0 0\n"
                                               "RenderEvent 223 152 0 0 0 0 0\n"
                                               "MouseMoveEvent 216 200 0 0 0 0 0\n"
                                               "RightButtonPressEvent 216 200 0 0 0 0 0\n"
                                               "StartInteractionEvent 216 200 0 0 0 0 0\n"
                                               "MouseMoveEvent 216 203 0 0 0 0 0\n"
                                               "RenderEvent 216 203 0 0 0 0 0\n"
                                               "InteractionEvent 216 203 0 0 0 0 0\n"
                                               "MouseMoveEvent 216 205 0 0 0 0 0\n"
                                               "RenderEvent 216 205 0 0 0 0 0\n"
                                               "InteractionEvent 216 205 0 0 0 0 0\n"
                                               "MouseMoveEvent 216 208 0 0 0 0 0\n"
                                               "RenderEvent 216 208 0 0 0 0 0\n"
                                               "InteractionEvent 216 208 0 0 0 0 0\n"
                                               "MouseMoveEvent 216 213 0 0 0 0 0\n"
                                               "RenderEvent 216 213 0 0 0 0 0\n"
                                               "InteractionEvent 216 213 0 0 0 0 0\n"
                                               "MouseMoveEvent 216 220 0 0 0 0 0\n"
                                               "RenderEvent 216 220 0 0 0 0 0\n"
                                               "InteractionEvent 216 220 0 0 0 0 0\n"
                                               "MouseMoveEvent 216 226 0 0 0 0 0\n"
                                               "RenderEvent 216 226 0 0 0 0 0\n"
                                               "InteractionEvent 216 226 0 0 0 0 0\n"
                                               "MouseMoveEvent 216 229 0 0 0 0 0\n"
                                               "RenderEvent 216 229 0 0 0 0 0\n"
                                               "InteractionEvent 216 229 0 0 0 0 0\n"
                                               "MouseMoveEvent 217 232 0 0 0 0 0\n"
                                               "RenderEvent 217 232 0 0 0 0 0\n"
                                               "InteractionEvent 217 232 0 0 0 0 0\n"
                                               "MouseMoveEvent 218 234 0 0 0 0 0\n"
                                               "RenderEvent 218 234 0 0 0 0 0\n"
                                               "InteractionEvent 218 234 0 0 0 0 0\n"
                                               "MouseMoveEvent 218 236 0 0 0 0 0\n"
                                               "RenderEvent 218 236 0 0 0 0 0\n"
                                               "InteractionEvent 218 236 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 239 0 0 0 0 0\n"
                                               "RenderEvent 219 239 0 0 0 0 0\n"
                                               "InteractionEvent 219 239 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 242 0 0 0 0 0\n"
                                               "RenderEvent 219 242 0 0 0 0 0\n"
                                               "InteractionEvent 219 242 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 245 0 0 0 0 0\n"
                                               "RenderEvent 219 245 0 0 0 0 0\n"
                                               "InteractionEvent 219 245 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 247 0 0 0 0 0\n"
                                               "RenderEvent 219 247 0 0 0 0 0\n"
                                               "InteractionEvent 219 247 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 250 0 0 0 0 0\n"
                                               "RenderEvent 219 250 0 0 0 0 0\n"
                                               "InteractionEvent 219 250 0 0 0 0 0\n"
                                               "MouseMoveEvent 220 254 0 0 0 0 0\n"
                                               "RenderEvent 220 254 0 0 0 0 0\n"
                                               "InteractionEvent 220 254 0 0 0 0 0\n"
                                               "MouseMoveEvent 220 257 0 0 0 0 0\n"
                                               "RenderEvent 220 257 0 0 0 0 0\n"
                                               "InteractionEvent 220 257 0 0 0 0 0\n"
                                               "MouseMoveEvent 221 260 0 0 0 0 0\n"
                                               "RenderEvent 221 260 0 0 0 0 0\n"
                                               "InteractionEvent 221 260 0 0 0 0 0\n"
                                               "MouseMoveEvent 221 264 0 0 0 0 0\n"
                                               "RenderEvent 221 264 0 0 0 0 0\n"
                                               "InteractionEvent 221 264 0 0 0 0 0\n"
                                               "MouseMoveEvent 222 266 0 0 0 0 0\n"
                                               "RenderEvent 222 266 0 0 0 0 0\n"
                                               "InteractionEvent 222 266 0 0 0 0 0\n"
                                               "MouseMoveEvent 222 270 0 0 0 0 0\n"
                                               "RenderEvent 222 270 0 0 0 0 0\n"
                                               "InteractionEvent 222 270 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 273 0 0 0 0 0\n"
                                               "RenderEvent 223 273 0 0 0 0 0\n"
                                               "InteractionEvent 223 273 0 0 0 0 0\n"
                                               "MouseMoveEvent 225 279 0 0 0 0 0\n"
                                               "RenderEvent 225 279 0 0 0 0 0\n"
                                               "InteractionEvent 225 279 0 0 0 0 0\n"
                                               "MouseMoveEvent 225 282 0 0 0 0 0\n"
                                               "RenderEvent 225 282 0 0 0 0 0\n"
                                               "InteractionEvent 225 282 0 0 0 0 0\n"
                                               "MouseMoveEvent 225 285 0 0 0 0 0\n"
                                               "RenderEvent 225 285 0 0 0 0 0\n"
                                               "InteractionEvent 225 285 0 0 0 0 0\n"
                                               "MouseMoveEvent 226 287 0 0 0 0 0\n"
                                               "RenderEvent 226 287 0 0 0 0 0\n"
                                               "InteractionEvent 226 287 0 0 0 0 0\n"
                                               "MouseMoveEvent 226 291 0 0 0 0 0\n"
                                               "RenderEvent 226 291 0 0 0 0 0\n"
                                               "InteractionEvent 226 291 0 0 0 0 0\n"
                                               "MouseMoveEvent 227 295 0 0 0 0 0\n"
                                               "RenderEvent 227 295 0 0 0 0 0\n"
                                               "InteractionEvent 227 295 0 0 0 0 0\n"
                                               "MouseMoveEvent 227 298 0 0 0 0 0\n"
                                               "RenderEvent 227 298 0 0 0 0 0\n"
                                               "InteractionEvent 227 298 0 0 0 0 0\n"
                                               "MouseMoveEvent 228 300 0 0 0 0 0\n"
                                               "RenderEvent 228 300 0 0 0 0 0\n"
                                               "InteractionEvent 228 300 0 0 0 0 0\n"
                                               "MouseMoveEvent 228 302 0 0 0 0 0\n"
                                               "RenderEvent 228 302 0 0 0 0 0\n"
                                               "InteractionEvent 228 302 0 0 0 0 0\n"
                                               "MouseMoveEvent 228 304 0 0 0 0 0\n"
                                               "RenderEvent 228 304 0 0 0 0 0\n"
                                               "InteractionEvent 228 304 0 0 0 0 0\n"
                                               "MouseMoveEvent 228 305 0 0 0 0 0\n"
                                               "RenderEvent 228 305 0 0 0 0 0\n"
                                               "InteractionEvent 228 305 0 0 0 0 0\n"
                                               "MouseMoveEvent 229 307 0 0 0 0 0\n"
                                               "RenderEvent 229 307 0 0 0 0 0\n"
                                               "InteractionEvent 229 307 0 0 0 0 0\n"
                                               "MouseMoveEvent 229 308 0 0 0 0 0\n"
                                               "RenderEvent 229 308 0 0 0 0 0\n"
                                               "InteractionEvent 229 308 0 0 0 0 0\n"
                                               "MouseMoveEvent 229 309 0 0 0 0 0\n"
                                               "RenderEvent 229 309 0 0 0 0 0\n"
                                               "InteractionEvent 229 309 0 0 0 0 0\n"
                                               "MouseMoveEvent 229 310 0 0 0 0 0\n"
                                               "RenderEvent 229 310 0 0 0 0 0\n"
                                               "InteractionEvent 229 310 0 0 0 0 0\n"
                                               "MouseMoveEvent 230 312 0 0 0 0 0\n"
                                               "RenderEvent 230 312 0 0 0 0 0\n"
                                               "InteractionEvent 230 312 0 0 0 0 0\n"
                                               "MouseMoveEvent 231 315 0 0 0 0 0\n"
                                               "RenderEvent 231 315 0 0 0 0 0\n"
                                               "InteractionEvent 231 315 0 0 0 0 0\n"
                                               "MouseMoveEvent 232 318 0 0 0 0 0\n"
                                               "RenderEvent 232 318 0 0 0 0 0\n"
                                               "InteractionEvent 232 318 0 0 0 0 0\n"
                                               "MouseMoveEvent 233 321 0 0 0 0 0\n"
                                               "RenderEvent 233 321 0 0 0 0 0\n"
                                               "InteractionEvent 233 321 0 0 0 0 0\n"
                                               "MouseMoveEvent 234 323 0 0 0 0 0\n"
                                               "RenderEvent 234 323 0 0 0 0 0\n"
                                               "InteractionEvent 234 323 0 0 0 0 0\n"
                                               "MouseMoveEvent 234 324 0 0 0 0 0\n"
                                               "RenderEvent 234 324 0 0 0 0 0\n"
                                               "InteractionEvent 234 324 0 0 0 0 0\n"
                                               "MouseMoveEvent 234 325 0 0 0 0 0\n"
                                               "RenderEvent 234 325 0 0 0 0 0\n"
                                               "InteractionEvent 234 325 0 0 0 0 0\n"
                                               "MouseMoveEvent 234 327 0 0 0 0 0\n"
                                               "RenderEvent 234 327 0 0 0 0 0\n"
                                               "InteractionEvent 234 327 0 0 0 0 0\n"
                                               "MouseMoveEvent 235 329 0 0 0 0 0\n"
                                               "RenderEvent 235 329 0 0 0 0 0\n"
                                               "InteractionEvent 235 329 0 0 0 0 0\n"
                                               "MouseMoveEvent 235 330 0 0 0 0 0\n"
                                               "RenderEvent 235 330 0 0 0 0 0\n"
                                               "InteractionEvent 235 330 0 0 0 0 0\n"
                                               "MouseMoveEvent 235 332 0 0 0 0 0\n"
                                               "RenderEvent 235 332 0 0 0 0 0\n"
                                               "InteractionEvent 235 332 0 0 0 0 0\n"
                                               "MouseMoveEvent 235 334 0 0 0 0 0\n"
                                               "RenderEvent 235 334 0 0 0 0 0\n"
                                               "InteractionEvent 235 334 0 0 0 0 0\n"
                                               "MouseMoveEvent 235 335 0 0 0 0 0\n"
                                               "RenderEvent 235 335 0 0 0 0 0\n"
                                               "InteractionEvent 235 335 0 0 0 0 0\n"
                                               "MouseMoveEvent 235 336 0 0 0 0 0\n"
                                               "RenderEvent 235 336 0 0 0 0 0\n"
                                               "InteractionEvent 235 336 0 0 0 0 0\n"
                                               "MouseMoveEvent 235 338 0 0 0 0 0\n"
                                               "RenderEvent 235 338 0 0 0 0 0\n"
                                               "InteractionEvent 235 338 0 0 0 0 0\n"
                                               "MouseMoveEvent 235 339 0 0 0 0 0\n"
                                               "RenderEvent 235 339 0 0 0 0 0\n"
                                               "InteractionEvent 235 339 0 0 0 0 0\n"
                                               "MouseMoveEvent 235 341 0 0 0 0 0\n"
                                               "RenderEvent 235 341 0 0 0 0 0\n"
                                               "InteractionEvent 235 341 0 0 0 0 0\n"
                                               "MouseMoveEvent 235 342 0 0 0 0 0\n"
                                               "RenderEvent 235 342 0 0 0 0 0\n"
                                               "InteractionEvent 235 342 0 0 0 0 0\n"
                                               "MouseMoveEvent 235 343 0 0 0 0 0\n"
                                               "RenderEvent 235 343 0 0 0 0 0\n"
                                               "InteractionEvent 235 343 0 0 0 0 0\n"
                                               "MouseMoveEvent 235 344 0 0 0 0 0\n"
                                               "RenderEvent 235 344 0 0 0 0 0\n"
                                               "InteractionEvent 235 344 0 0 0 0 0\n"
                                               "MouseMoveEvent 235 346 0 0 0 0 0\n"
                                               "RenderEvent 235 346 0 0 0 0 0\n"
                                               "InteractionEvent 235 346 0 0 0 0 0\n"
                                               "MouseMoveEvent 235 347 0 0 0 0 0\n"
                                               "RenderEvent 235 347 0 0 0 0 0\n"
                                               "InteractionEvent 235 347 0 0 0 0 0\n"
                                               "MouseMoveEvent 234 349 0 0 0 0 0\n"
                                               "RenderEvent 234 349 0 0 0 0 0\n"
                                               "InteractionEvent 234 349 0 0 0 0 0\n"
                                               "MouseMoveEvent 234 350 0 0 0 0 0\n"
                                               "RenderEvent 234 350 0 0 0 0 0\n"
                                               "InteractionEvent 234 350 0 0 0 0 0\n"
                                               "MouseMoveEvent 234 351 0 0 0 0 0\n"
                                               "RenderEvent 234 351 0 0 0 0 0\n"
                                               "InteractionEvent 234 351 0 0 0 0 0\n"
                                               "MouseMoveEvent 233 352 0 0 0 0 0\n"
                                               "RenderEvent 233 352 0 0 0 0 0\n"
                                               "InteractionEvent 233 352 0 0 0 0 0\n"
                                               "RightButtonReleaseEvent 233 352 0 0 0 0 0\n"
                                               "EndInteractionEvent 233 352 0 0 0 0 0\n"
                                               "RenderEvent 233 352 0 0 0 0 0\n"
                                               "MouseMoveEvent 232 353 0 0 0 0 0\n"
                                               "MiddleButtonPressEvent 232 353 0 0 0 0 0\n"
                                               "StartInteractionEvent 232 353 0 0 0 0 0\n"
                                               "MouseMoveEvent 232 352 0 0 0 0 0\n"
                                               "RenderEvent 232 352 0 0 0 0 0\n"
                                               "InteractionEvent 232 352 0 0 0 0 0\n"
                                               "MouseMoveEvent 232 351 0 0 0 0 0\n"
                                               "RenderEvent 232 351 0 0 0 0 0\n"
                                               "InteractionEvent 232 351 0 0 0 0 0\n"
                                               "MouseMoveEvent 232 350 0 0 0 0 0\n"
                                               "RenderEvent 232 350 0 0 0 0 0\n"
                                               "InteractionEvent 232 350 0 0 0 0 0\n"
                                               "MouseMoveEvent 232 348 0 0 0 0 0\n"
                                               "RenderEvent 232 348 0 0 0 0 0\n"
                                               "InteractionEvent 232 348 0 0 0 0 0\n"
                                               "MouseMoveEvent 232 344 0 0 0 0 0\n"
                                               "RenderEvent 232 344 0 0 0 0 0\n"
                                               "InteractionEvent 232 344 0 0 0 0 0\n"
                                               "MouseMoveEvent 232 340 0 0 0 0 0\n"
                                               "RenderEvent 232 340 0 0 0 0 0\n"
                                               "InteractionEvent 232 340 0 0 0 0 0\n"
                                               "MouseMoveEvent 232 333 0 0 0 0 0\n"
                                               "RenderEvent 232 333 0 0 0 0 0\n"
                                               "InteractionEvent 232 333 0 0 0 0 0\n"
                                               "MouseMoveEvent 231 329 0 0 0 0 0\n"
                                               "RenderEvent 231 329 0 0 0 0 0\n"
                                               "InteractionEvent 231 329 0 0 0 0 0\n"
                                               "MouseMoveEvent 230 326 0 0 0 0 0\n"
                                               "RenderEvent 230 326 0 0 0 0 0\n"
                                               "InteractionEvent 230 326 0 0 0 0 0\n"
                                               "MouseMoveEvent 230 324 0 0 0 0 0\n"
                                               "RenderEvent 230 324 0 0 0 0 0\n"
                                               "InteractionEvent 230 324 0 0 0 0 0\n"
                                               "MouseMoveEvent 230 321 0 0 0 0 0\n"
                                               "RenderEvent 230 321 0 0 0 0 0\n"
                                               "InteractionEvent 230 321 0 0 0 0 0\n"
                                               "MouseMoveEvent 229 318 0 0 0 0 0\n"
                                               "RenderEvent 229 318 0 0 0 0 0\n"
                                               "InteractionEvent 229 318 0 0 0 0 0\n"
                                               "MouseMoveEvent 228 314 0 0 0 0 0\n"
                                               "RenderEvent 228 314 0 0 0 0 0\n"
                                               "InteractionEvent 228 314 0 0 0 0 0\n"
                                               "MouseMoveEvent 227 311 0 0 0 0 0\n"
                                               "RenderEvent 227 311 0 0 0 0 0\n"
                                               "InteractionEvent 227 311 0 0 0 0 0\n"
                                               "MouseMoveEvent 226 309 0 0 0 0 0\n"
                                               "RenderEvent 226 309 0 0 0 0 0\n"
                                               "InteractionEvent 226 309 0 0 0 0 0\n"
                                               "MouseMoveEvent 225 306 0 0 0 0 0\n"
                                               "RenderEvent 225 306 0 0 0 0 0\n"
                                               "InteractionEvent 225 306 0 0 0 0 0\n"
                                               "MouseMoveEvent 224 302 0 0 0 0 0\n"
                                               "RenderEvent 224 302 0 0 0 0 0\n"
                                               "InteractionEvent 224 302 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 299 0 0 0 0 0\n"
                                               "RenderEvent 223 299 0 0 0 0 0\n"
                                               "InteractionEvent 223 299 0 0 0 0 0\n"
                                               "MouseMoveEvent 222 295 0 0 0 0 0\n"
                                               "RenderEvent 222 295 0 0 0 0 0\n"
                                               "InteractionEvent 222 295 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 289 0 0 0 0 0\n"
                                               "RenderEvent 219 289 0 0 0 0 0\n"
                                               "InteractionEvent 219 289 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 285 0 0 0 0 0\n"
                                               "RenderEvent 219 285 0 0 0 0 0\n"
                                               "InteractionEvent 219 285 0 0 0 0 0\n"
                                               "MouseMoveEvent 218 281 0 0 0 0 0\n"
                                               "RenderEvent 218 281 0 0 0 0 0\n"
                                               "InteractionEvent 218 281 0 0 0 0 0\n"
                                               "MouseMoveEvent 217 278 0 0 0 0 0\n"
                                               "RenderEvent 217 278 0 0 0 0 0\n"
                                               "InteractionEvent 217 278 0 0 0 0 0\n"
                                               "MouseMoveEvent 217 274 0 0 0 0 0\n"
                                               "RenderEvent 217 274 0 0 0 0 0\n"
                                               "InteractionEvent 217 274 0 0 0 0 0\n"
                                               "MouseMoveEvent 217 270 0 0 0 0 0\n"
                                               "RenderEvent 217 270 0 0 0 0 0\n"
                                               "InteractionEvent 217 270 0 0 0 0 0\n"
                                               "MouseMoveEvent 216 267 0 0 0 0 0\n"
                                               "RenderEvent 216 267 0 0 0 0 0\n"
                                               "InteractionEvent 216 267 0 0 0 0 0\n"
                                               "MouseMoveEvent 216 263 0 0 0 0 0\n"
                                               "RenderEvent 216 263 0 0 0 0 0\n"
                                               "InteractionEvent 216 263 0 0 0 0 0\n"
                                               "MouseMoveEvent 216 259 0 0 0 0 0\n"
                                               "RenderEvent 216 259 0 0 0 0 0\n"
                                               "InteractionEvent 216 259 0 0 0 0 0\n"
                                               "MouseMoveEvent 216 254 0 0 0 0 0\n"
                                               "RenderEvent 216 254 0 0 0 0 0\n"
                                               "InteractionEvent 216 254 0 0 0 0 0\n"
                                               "MouseMoveEvent 216 249 0 0 0 0 0\n"
                                               "RenderEvent 216 249 0 0 0 0 0\n"
                                               "InteractionEvent 216 249 0 0 0 0 0\n"
                                               "MouseMoveEvent 217 244 0 0 0 0 0\n"
                                               "RenderEvent 217 244 0 0 0 0 0\n"
                                               "InteractionEvent 217 244 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 237 0 0 0 0 0\n"
                                               "RenderEvent 219 237 0 0 0 0 0\n"
                                               "InteractionEvent 219 237 0 0 0 0 0\n"
                                               "MouseMoveEvent 220 232 0 0 0 0 0\n"
                                               "RenderEvent 220 232 0 0 0 0 0\n"
                                               "InteractionEvent 220 232 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 227 0 0 0 0 0\n"
                                               "RenderEvent 223 227 0 0 0 0 0\n"
                                               "InteractionEvent 223 227 0 0 0 0 0\n"
                                               "MouseMoveEvent 224 224 0 0 0 0 0\n"
                                               "RenderEvent 224 224 0 0 0 0 0\n"
                                               "InteractionEvent 224 224 0 0 0 0 0\n"
                                               "MouseMoveEvent 227 219 0 0 0 0 0\n"
                                               "RenderEvent 227 219 0 0 0 0 0\n"
                                               "InteractionEvent 227 219 0 0 0 0 0\n"
                                               "MouseMoveEvent 229 213 0 0 0 0 0\n"
                                               "RenderEvent 229 213 0 0 0 0 0\n"
                                               "InteractionEvent 229 213 0 0 0 0 0\n"
                                               "MouseMoveEvent 231 208 0 0 0 0 0\n"
                                               "RenderEvent 231 208 0 0 0 0 0\n"
                                               "InteractionEvent 231 208 0 0 0 0 0\n"
                                               "MouseMoveEvent 232 203 0 0 0 0 0\n"
                                               "RenderEvent 232 203 0 0 0 0 0\n"
                                               "InteractionEvent 232 203 0 0 0 0 0\n"
                                               "MouseMoveEvent 233 201 0 0 0 0 0\n"
                                               "RenderEvent 233 201 0 0 0 0 0\n"
                                               "InteractionEvent 233 201 0 0 0 0 0\n"
                                               "MouseMoveEvent 234 197 0 0 0 0 0\n"
                                               "RenderEvent 234 197 0 0 0 0 0\n"
                                               "InteractionEvent 234 197 0 0 0 0 0\n"
                                               "MouseMoveEvent 234 196 0 0 0 0 0\n"
                                               "RenderEvent 234 196 0 0 0 0 0\n"
                                               "InteractionEvent 234 196 0 0 0 0 0\n"
                                               "MouseMoveEvent 235 194 0 0 0 0 0\n"
                                               "RenderEvent 235 194 0 0 0 0 0\n"
                                               "InteractionEvent 235 194 0 0 0 0 0\n"
                                               "MouseMoveEvent 236 191 0 0 0 0 0\n"
                                               "RenderEvent 236 191 0 0 0 0 0\n"
                                               "InteractionEvent 236 191 0 0 0 0 0\n"
                                               "MouseMoveEvent 237 189 0 0 0 0 0\n"
                                               "RenderEvent 237 189 0 0 0 0 0\n"
                                               "InteractionEvent 237 189 0 0 0 0 0\n"
                                               "MouseMoveEvent 238 187 0 0 0 0 0\n"
                                               "RenderEvent 238 187 0 0 0 0 0\n"
                                               "InteractionEvent 238 187 0 0 0 0 0\n"
                                               "MouseMoveEvent 240 184 0 0 0 0 0\n"
                                               "RenderEvent 240 184 0 0 0 0 0\n"
                                               "InteractionEvent 240 184 0 0 0 0 0\n"
                                               "MouseMoveEvent 241 181 0 0 0 0 0\n"
                                               "RenderEvent 241 181 0 0 0 0 0\n"
                                               "InteractionEvent 241 181 0 0 0 0 0\n"
                                               "MouseMoveEvent 243 177 0 0 0 0 0\n"
                                               "RenderEvent 243 177 0 0 0 0 0\n"
                                               "InteractionEvent 243 177 0 0 0 0 0\n"
                                               "MouseMoveEvent 243 176 0 0 0 0 0\n"
                                               "RenderEvent 243 176 0 0 0 0 0\n"
                                               "InteractionEvent 243 176 0 0 0 0 0\n"
                                               "MouseMoveEvent 244 173 0 0 0 0 0\n"
                                               "RenderEvent 244 173 0 0 0 0 0\n"
                                               "InteractionEvent 244 173 0 0 0 0 0\n"
                                               "MouseMoveEvent 245 169 0 0 0 0 0\n"
                                               "RenderEvent 245 169 0 0 0 0 0\n"
                                               "InteractionEvent 245 169 0 0 0 0 0\n"
                                               "MouseMoveEvent 246 165 0 0 0 0 0\n"
                                               "RenderEvent 246 165 0 0 0 0 0\n"
                                               "InteractionEvent 246 165 0 0 0 0 0\n"
                                               "MouseMoveEvent 247 161 0 0 0 0 0\n"
                                               "RenderEvent 247 161 0 0 0 0 0\n"
                                               "InteractionEvent 247 161 0 0 0 0 0\n"
                                               "MouseMoveEvent 249 157 0 0 0 0 0\n"
                                               "RenderEvent 249 157 0 0 0 0 0\n"
                                               "InteractionEvent 249 157 0 0 0 0 0\n"
                                               "MouseMoveEvent 251 152 0 0 0 0 0\n"
                                               "RenderEvent 251 152 0 0 0 0 0\n"
                                               "InteractionEvent 251 152 0 0 0 0 0\n"
                                               "MouseMoveEvent 252 147 0 0 0 0 0\n"
                                               "RenderEvent 252 147 0 0 0 0 0\n"
                                               "InteractionEvent 252 147 0 0 0 0 0\n"
                                               "MouseMoveEvent 253 142 0 0 0 0 0\n"
                                               "RenderEvent 253 142 0 0 0 0 0\n"
                                               "InteractionEvent 253 142 0 0 0 0 0\n"
                                               "MouseMoveEvent 254 138 0 0 0 0 0\n"
                                               "RenderEvent 254 138 0 0 0 0 0\n"
                                               "InteractionEvent 254 138 0 0 0 0 0\n"
                                               "MouseMoveEvent 255 133 0 0 0 0 0\n"
                                               "RenderEvent 255 133 0 0 0 0 0\n"
                                               "InteractionEvent 255 133 0 0 0 0 0\n"
                                               "MouseMoveEvent 257 129 0 0 0 0 0\n"
                                               "RenderEvent 257 129 0 0 0 0 0\n"
                                               "InteractionEvent 257 129 0 0 0 0 0\n"
                                               "MouseMoveEvent 259 125 0 0 0 0 0\n"
                                               "RenderEvent 259 125 0 0 0 0 0\n"
                                               "InteractionEvent 259 125 0 0 0 0 0\n"
                                               "MiddleButtonReleaseEvent 259 125 0 0 0 0 0\n"
                                               "EndInteractionEvent 259 125 0 0 0 0 0\n"
                                               "RenderEvent 259 125 0 0 0 0 0\n"
                                               "MouseMoveEvent 220 80 0 0 0 0 0\n"
                                               "RightButtonPressEvent 220 80 0 0 0 0 0\n"
                                               "StartInteractionEvent 220 80 0 0 0 0 0\n"
                                               "MouseMoveEvent 220 82 0 0 0 0 0\n"
                                               "RenderEvent 220 82 0 0 0 0 0\n"
                                               "InteractionEvent 220 82 0 0 0 0 0\n"
                                               "MouseMoveEvent 220 85 0 0 0 0 0\n"
                                               "RenderEvent 220 85 0 0 0 0 0\n"
                                               "InteractionEvent 220 85 0 0 0 0 0\n"
                                               "MouseMoveEvent 220 87 0 0 0 0 0\n"
                                               "RenderEvent 220 87 0 0 0 0 0\n"
                                               "InteractionEvent 220 87 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 93 0 0 0 0 0\n"
                                               "RenderEvent 219 93 0 0 0 0 0\n"
                                               "InteractionEvent 219 93 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 99 0 0 0 0 0\n"
                                               "RenderEvent 219 99 0 0 0 0 0\n"
                                               "InteractionEvent 219 99 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 105 0 0 0 0 0\n"
                                               "RenderEvent 219 105 0 0 0 0 0\n"
                                               "InteractionEvent 219 105 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 111 0 0 0 0 0\n"
                                               "RenderEvent 219 111 0 0 0 0 0\n"
                                               "InteractionEvent 219 111 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 116 0 0 0 0 0\n"
                                               "RenderEvent 219 116 0 0 0 0 0\n"
                                               "InteractionEvent 219 116 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 120 0 0 0 0 0\n"
                                               "RenderEvent 219 120 0 0 0 0 0\n"
                                               "InteractionEvent 219 120 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 124 0 0 0 0 0\n"
                                               "RenderEvent 219 124 0 0 0 0 0\n"
                                               "InteractionEvent 219 124 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 128 0 0 0 0 0\n"
                                               "RenderEvent 219 128 0 0 0 0 0\n"
                                               "InteractionEvent 219 128 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 132 0 0 0 0 0\n"
                                               "RenderEvent 219 132 0 0 0 0 0\n"
                                               "InteractionEvent 219 132 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 136 0 0 0 0 0\n"
                                               "RenderEvent 219 136 0 0 0 0 0\n"
                                               "InteractionEvent 219 136 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 139 0 0 0 0 0\n"
                                               "RenderEvent 219 139 0 0 0 0 0\n"
                                               "InteractionEvent 219 139 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 143 0 0 0 0 0\n"
                                               "RenderEvent 219 143 0 0 0 0 0\n"
                                               "InteractionEvent 219 143 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 147 0 0 0 0 0\n"
                                               "RenderEvent 219 147 0 0 0 0 0\n"
                                               "InteractionEvent 219 147 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 152 0 0 0 0 0\n"
                                               "RenderEvent 219 152 0 0 0 0 0\n"
                                               "InteractionEvent 219 152 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 156 0 0 0 0 0\n"
                                               "RenderEvent 219 156 0 0 0 0 0\n"
                                               "InteractionEvent 219 156 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 159 0 0 0 0 0\n"
                                               "RenderEvent 219 159 0 0 0 0 0\n"
                                               "InteractionEvent 219 159 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 162 0 0 0 0 0\n"
                                               "RenderEvent 219 162 0 0 0 0 0\n"
                                               "InteractionEvent 219 162 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 165 0 0 0 0 0\n"
                                               "RenderEvent 219 165 0 0 0 0 0\n"
                                               "InteractionEvent 219 165 0 0 0 0 0\n"
                                               "MouseMoveEvent 219 169 0 0 0 0 0\n"
                                               "RenderEvent 219 169 0 0 0 0 0\n"
                                               "InteractionEvent 219 169 0 0 0 0 0\n"
                                               "MouseMoveEvent 220 173 0 0 0 0 0\n"
                                               "RenderEvent 220 173 0 0 0 0 0\n"
                                               "InteractionEvent 220 173 0 0 0 0 0\n"
                                               "MouseMoveEvent 220 176 0 0 0 0 0\n"
                                               "RenderEvent 220 176 0 0 0 0 0\n"
                                               "InteractionEvent 220 176 0 0 0 0 0\n"
                                               "MouseMoveEvent 221 180 0 0 0 0 0\n"
                                               "RenderEvent 221 180 0 0 0 0 0\n"
                                               "InteractionEvent 221 180 0 0 0 0 0\n"
                                               "MouseMoveEvent 221 184 0 0 0 0 0\n"
                                               "RenderEvent 221 184 0 0 0 0 0\n"
                                               "InteractionEvent 221 184 0 0 0 0 0\n"
                                               "MouseMoveEvent 222 187 0 0 0 0 0\n"
                                               "RenderEvent 222 187 0 0 0 0 0\n"
                                               "InteractionEvent 222 187 0 0 0 0 0\n"
                                               "MouseMoveEvent 222 189 0 0 0 0 0\n"
                                               "RenderEvent 222 189 0 0 0 0 0\n"
                                               "InteractionEvent 222 189 0 0 0 0 0\n"
                                               "MouseMoveEvent 222 193 0 0 0 0 0\n"
                                               "RenderEvent 222 193 0 0 0 0 0\n"
                                               "InteractionEvent 222 193 0 0 0 0 0\n"
                                               "MouseMoveEvent 222 195 0 0 0 0 0\n"
                                               "RenderEvent 222 195 0 0 0 0 0\n"
                                               "InteractionEvent 222 195 0 0 0 0 0\n"
                                               "MouseMoveEvent 222 197 0 0 0 0 0\n"
                                               "RenderEvent 222 197 0 0 0 0 0\n"
                                               "InteractionEvent 222 197 0 0 0 0 0\n"
                                               "MouseMoveEvent 222 198 0 0 0 0 0\n"
                                               "RenderEvent 222 198 0 0 0 0 0\n"
                                               "InteractionEvent 222 198 0 0 0 0 0\n"
                                               "MouseMoveEvent 222 199 0 0 0 0 0\n"
                                               "RenderEvent 222 199 0 0 0 0 0\n"
                                               "InteractionEvent 222 199 0 0 0 0 0\n"
                                               "MouseMoveEvent 222 201 0 0 0 0 0\n"
                                               "RenderEvent 222 201 0 0 0 0 0\n"
                                               "InteractionEvent 222 201 0 0 0 0 0\n"
                                               "MouseMoveEvent 222 202 0 0 0 0 0\n"
                                               "RenderEvent 222 202 0 0 0 0 0\n"
                                               "InteractionEvent 222 202 0 0 0 0 0\n"
                                               "MouseMoveEvent 222 203 0 0 0 0 0\n"
                                               "RenderEvent 222 203 0 0 0 0 0\n"
                                               "InteractionEvent 222 203 0 0 0 0 0\n"
                                               "MouseMoveEvent 222 204 0 0 0 0 0\n"
                                               "RenderEvent 222 204 0 0 0 0 0\n"
                                               "InteractionEvent 222 204 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 205 0 0 0 0 0\n"
                                               "RenderEvent 223 205 0 0 0 0 0\n"
                                               "InteractionEvent 223 205 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 206 0 0 0 0 0\n"
                                               "RenderEvent 223 206 0 0 0 0 0\n"
                                               "InteractionEvent 223 206 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 207 0 0 0 0 0\n"
                                               "RenderEvent 223 207 0 0 0 0 0\n"
                                               "InteractionEvent 223 207 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 208 0 0 0 0 0\n"
                                               "RenderEvent 223 208 0 0 0 0 0\n"
                                               "InteractionEvent 223 208 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 209 0 0 0 0 0\n"
                                               "RenderEvent 223 209 0 0 0 0 0\n"
                                               "InteractionEvent 223 209 0 0 0 0 0\n"
                                               "MouseMoveEvent 223 210 0 0 0 0 0\n"
                                               "RenderEvent 223 210 0 0 0 0 0\n"
                                               "InteractionEvent 223 210 0 0 0 0 0\n"
                                               "MouseMoveEvent 224 211 0 0 0 0 0\n"
                                               "RenderEvent 224 211 0 0 0 0 0\n"
                                               "InteractionEvent 224 211 0 0 0 0 0\n"
                                               "MouseMoveEvent 224 212 0 0 0 0 0\n"
                                               "RenderEvent 224 212 0 0 0 0 0\n"
                                               "InteractionEvent 224 212 0 0 0 0 0\n"
                                               "MouseMoveEvent 224 215 0 0 0 0 0\n"
                                               "RenderEvent 224 215 0 0 0 0 0\n"
                                               "InteractionEvent 224 215 0 0 0 0 0\n"
                                               "MouseMoveEvent 224 218 0 0 0 0 0\n"
                                               "RenderEvent 224 218 0 0 0 0 0\n"
                                               "InteractionEvent 224 218 0 0 0 0 0\n"
                                               "MouseMoveEvent 225 221 0 0 0 0 0\n"
                                               "RenderEvent 225 221 0 0 0 0 0\n"
                                               "InteractionEvent 225 221 0 0 0 0 0\n"
                                               "MouseMoveEvent 225 222 0 0 0 0 0\n"
                                               "RenderEvent 225 222 0 0 0 0 0\n"
                                               "InteractionEvent 225 222 0 0 0 0 0\n"
                                               "MouseMoveEvent 225 223 0 0 0 0 0\n"
                                               "RenderEvent 225 223 0 0 0 0 0\n"
                                               "InteractionEvent 225 223 0 0 0 0 0\n"
                                               "MouseMoveEvent 225 224 0 0 0 0 0\n"
                                               "RenderEvent 225 224 0 0 0 0 0\n"
                                               "InteractionEvent 225 224 0 0 0 0 0\n"
                                               "MouseMoveEvent 225 226 0 0 0 0 0\n"
                                               "RenderEvent 225 226 0 0 0 0 0\n"
                                               "InteractionEvent 225 226 0 0 0 0 0\n"
                                               "MouseMoveEvent 225 227 0 0 0 0 0\n"
                                               "RenderEvent 225 227 0 0 0 0 0\n"
                                               "InteractionEvent 225 227 0 0 0 0 0\n"
                                               "MouseMoveEvent 225 229 0 0 0 0 0\n"
                                               "RenderEvent 225 229 0 0 0 0 0\n"
                                               "InteractionEvent 225 229 0 0 0 0 0\n"
                                               "MouseMoveEvent 225 231 0 0 0 0 0\n"
                                               "RenderEvent 225 231 0 0 0 0 0\n"
                                               "InteractionEvent 225 231 0 0 0 0 0\n"
                                               "MouseMoveEvent 225 232 0 0 0 0 0\n"
                                               "RenderEvent 225 232 0 0 0 0 0\n"
                                               "InteractionEvent 225 232 0 0 0 0 0\n"
                                               "MouseMoveEvent 225 233 0 0 0 0 0\n"
                                               "RenderEvent 225 233 0 0 0 0 0\n"
                                               "InteractionEvent 225 233 0 0 0 0 0\n"
                                               "RightButtonReleaseEvent 225 233 0 0 0 0 0\n"
                                               "EndInteractionEvent 225 233 0 0 0 0 0\n"
                                               "RenderEvent 225 233 0 0 0 0 0\n"
                                               "MouseMoveEvent 247 258 0 0 0 0 0\n"
                                               "MiddleButtonPressEvent 247 258 0 0 0 0 0\n"
                                               "StartInteractionEvent 247 258 0 0 0 0 0\n"
                                               "MouseMoveEvent 247 256 0 0 0 0 0\n"
                                               "RenderEvent 247 256 0 0 0 0 0\n"
                                               "InteractionEvent 247 256 0 0 0 0 0\n"
                                               "MouseMoveEvent 247 254 0 0 0 0 0\n"
                                               "RenderEvent 247 254 0 0 0 0 0\n"
                                               "InteractionEvent 247 254 0 0 0 0 0\n"
                                               "MouseMoveEvent 247 252 0 0 0 0 0\n"
                                               "RenderEvent 247 252 0 0 0 0 0\n"
                                               "InteractionEvent 247 252 0 0 0 0 0\n"
                                               "MouseMoveEvent 247 248 0 0 0 0 0\n"
                                               "RenderEvent 247 248 0 0 0 0 0\n"
                                               "InteractionEvent 247 248 0 0 0 0 0\n"
                                               "MouseMoveEvent 247 243 0 0 0 0 0\n"
                                               "RenderEvent 247 243 0 0 0 0 0\n"
                                               "InteractionEvent 247 243 0 0 0 0 0\n"
                                               "MouseMoveEvent 247 239 0 0 0 0 0\n"
                                               "RenderEvent 247 239 0 0 0 0 0\n"
                                               "InteractionEvent 247 239 0 0 0 0 0\n"
                                               "MouseMoveEvent 247 235 0 0 0 0 0\n"
                                               "RenderEvent 247 235 0 0 0 0 0\n"
                                               "InteractionEvent 247 235 0 0 0 0 0\n"
                                               "MouseMoveEvent 247 231 0 0 0 0 0\n"
                                               "RenderEvent 247 231 0 0 0 0 0\n"
                                               "InteractionEvent 247 231 0 0 0 0 0\n"
                                               "MouseMoveEvent 247 226 0 0 0 0 0\n"
                                               "RenderEvent 247 226 0 0 0 0 0\n"
                                               "InteractionEvent 247 226 0 0 0 0 0\n"
                                               "MouseMoveEvent 247 221 0 0 0 0 0\n"
                                               "RenderEvent 247 221 0 0 0 0 0\n"
                                               "InteractionEvent 247 221 0 0 0 0 0\n"
                                               "MouseMoveEvent 248 215 0 0 0 0 0\n"
                                               "RenderEvent 248 215 0 0 0 0 0\n"
                                               "InteractionEvent 248 215 0 0 0 0 0\n"
                                               "MouseMoveEvent 249 207 0 0 0 0 0\n"
                                               "RenderEvent 249 207 0 0 0 0 0\n"
                                               "InteractionEvent 249 207 0 0 0 0 0\n"
                                               "MouseMoveEvent 249 200 0 0 0 0 0\n"
                                               "RenderEvent 249 200 0 0 0 0 0\n"
                                               "InteractionEvent 249 200 0 0 0 0 0\n"
                                               "MouseMoveEvent 249 196 0 0 0 0 0\n"
                                               "RenderEvent 249 196 0 0 0 0 0\n"
                                               "InteractionEvent 249 196 0 0 0 0 0\n"
                                               "MouseMoveEvent 250 191 0 0 0 0 0\n"
                                               "RenderEvent 250 191 0 0 0 0 0\n"
                                               "InteractionEvent 250 191 0 0 0 0 0\n"
                                               "MouseMoveEvent 250 189 0 0 0 0 0\n"
                                               "RenderEvent 250 189 0 0 0 0 0\n"
                                               "InteractionEvent 250 189 0 0 0 0 0\n"
                                               "MouseMoveEvent 250 185 0 0 0 0 0\n"
                                               "RenderEvent 250 185 0 0 0 0 0\n"
                                               "InteractionEvent 250 185 0 0 0 0 0\n"
                                               "MouseMoveEvent 250 179 0 0 0 0 0\n"
                                               "RenderEvent 250 179 0 0 0 0 0\n"
                                               "InteractionEvent 250 179 0 0 0 0 0\n"
                                               "MouseMoveEvent 251 178 0 0 0 0 0\n"
                                               "RenderEvent 251 178 0 0 0 0 0\n"
                                               "InteractionEvent 251 178 0 0 0 0 0\n"
                                               "MouseMoveEvent 251 177 0 0 0 0 0\n"
                                               "RenderEvent 251 177 0 0 0 0 0\n"
                                               "InteractionEvent 251 177 0 0 0 0 0\n"
                                               "MouseMoveEvent 251 176 0 0 0 0 0\n"
                                               "RenderEvent 251 176 0 0 0 0 0\n"
                                               "InteractionEvent 251 176 0 0 0 0 0\n"
                                               "MouseMoveEvent 251 175 0 0 0 0 0\n"
                                               "RenderEvent 251 175 0 0 0 0 0\n"
                                               "InteractionEvent 251 175 0 0 0 0 0\n"
                                               "MouseMoveEvent 251 174 0 0 0 0 0\n"
                                               "RenderEvent 251 174 0 0 0 0 0\n"
                                               "InteractionEvent 251 174 0 0 0 0 0\n"
                                               "MouseMoveEvent 251 172 0 0 0 0 0\n"
                                               "RenderEvent 251 172 0 0 0 0 0\n"
                                               "InteractionEvent 251 172 0 0 0 0 0\n"
                                               "MouseMoveEvent 251 170 0 0 0 0 0\n"
                                               "RenderEvent 251 170 0 0 0 0 0\n"
                                               "InteractionEvent 251 170 0 0 0 0 0\n"
                                               "MouseMoveEvent 251 167 0 0 0 0 0\n"
                                               "RenderEvent 251 167 0 0 0 0 0\n"
                                               "InteractionEvent 251 167 0 0 0 0 0\n"
                                               "MouseMoveEvent 251 166 0 0 0 0 0\n"
                                               "RenderEvent 251 166 0 0 0 0 0\n"
                                               "InteractionEvent 251 166 0 0 0 0 0\n"
                                               "MouseMoveEvent 251 165 0 0 0 0 0\n"
                                               "RenderEvent 251 165 0 0 0 0 0\n"
                                               "InteractionEvent 251 165 0 0 0 0 0\n"
                                               "MouseMoveEvent 251 164 0 0 0 0 0\n"
                                               "RenderEvent 251 164 0 0 0 0 0\n"
                                               "InteractionEvent 251 164 0 0 0 0 0\n"
                                               "MouseMoveEvent 251 162 0 0 0 0 0\n"
                                               "RenderEvent 251 162 0 0 0 0 0\n"
                                               "InteractionEvent 251 162 0 0 0 0 0\n"
                                               "MouseMoveEvent 251 161 0 0 0 0 0\n"
                                               "RenderEvent 251 161 0 0 0 0 0\n"
                                               "InteractionEvent 251 161 0 0 0 0 0\n"
                                               "MouseMoveEvent 251 159 0 0 0 0 0\n"
                                               "RenderEvent 251 159 0 0 0 0 0\n"
                                               "InteractionEvent 251 159 0 0 0 0 0\n"
                                               "MouseMoveEvent 251 157 0 0 0 0 0\n"
                                               "RenderEvent 251 157 0 0 0 0 0\n"
                                               "InteractionEvent 251 157 0 0 0 0 0\n"
                                               "MouseMoveEvent 250 159 0 0 0 0 0\n"
                                               "RenderEvent 250 159 0 0 0 0 0\n"
                                               "InteractionEvent 250 159 0 0 0 0 0\n"
                                               "MouseMoveEvent 250 160 0 0 0 0 0\n"
                                               "RenderEvent 250 160 0 0 0 0 0\n"
                                               "InteractionEvent 250 160 0 0 0 0 0\n"
                                               "MouseMoveEvent 249 162 0 0 0 0 0\n"
                                               "RenderEvent 249 162 0 0 0 0 0\n"
                                               "InteractionEvent 249 162 0 0 0 0 0\n"
                                               "MouseMoveEvent 249 163 0 0 0 0 0\n"
                                               "RenderEvent 249 163 0 0 0 0 0\n"
                                               "InteractionEvent 249 163 0 0 0 0 0\n"
                                               "MouseMoveEvent 249 165 0 0 0 0 0\n"
                                               "RenderEvent 249 165 0 0 0 0 0\n"
                                               "InteractionEvent 249 165 0 0 0 0 0\n"
                                               "MouseMoveEvent 249 167 0 0 0 0 0\n"
                                               "RenderEvent 249 167 0 0 0 0 0\n"
                                               "InteractionEvent 249 167 0 0 0 0 0\n"
                                               "MouseMoveEvent 249 168 0 0 0 0 0\n"
                                               "RenderEvent 249 168 0 0 0 0 0\n"
                                               "InteractionEvent 249 168 0 0 0 0 0\n"
                                               "MouseMoveEvent 249 169 0 0 0 0 0\n"
                                               "RenderEvent 249 169 0 0 0 0 0\n"
                                               "InteractionEvent 249 169 0 0 0 0 0\n"
                                               "MouseMoveEvent 249 170 0 0 0 0 0\n"
                                               "RenderEvent 249 170 0 0 0 0 0\n"
                                               "InteractionEvent 249 170 0 0 0 0 0\n"
                                               "MouseMoveEvent 249 171 0 0 0 0 0\n"
                                               "RenderEvent 249 171 0 0 0 0 0\n"
                                               "InteractionEvent 249 171 0 0 0 0 0\n"
                                               "MouseMoveEvent 249 172 0 0 0 0 0\n"
                                               "RenderEvent 249 172 0 0 0 0 0\n"
                                               "InteractionEvent 249 172 0 0 0 0 0\n"
                                               "MouseMoveEvent 249 173 0 0 0 0 0\n"
                                               "RenderEvent 249 173 0 0 0 0 0\n"
                                               "InteractionEvent 249 173 0 0 0 0 0\n"
                                               "MouseMoveEvent 249 174 0 0 0 0 0\n"
                                               "RenderEvent 249 174 0 0 0 0 0\n"
                                               "InteractionEvent 249 174 0 0 0 0 0\n"
                                               "MouseMoveEvent 249 175 0 0 0 0 0\n"
                                               "RenderEvent 249 175 0 0 0 0 0\n"
                                               "InteractionEvent 249 175 0 0 0 0 0\n"
                                               "MouseMoveEvent 249 176 0 0 0 0 0\n"
                                               "RenderEvent 249 176 0 0 0 0 0\n"
                                               "InteractionEvent 249 176 0 0 0 0 0\n"
                                               "MouseMoveEvent 249 177 0 0 0 0 0\n"
                                               "RenderEvent 249 177 0 0 0 0 0\n"
                                               "InteractionEvent 249 177 0 0 0 0 0\n"
                                               "MouseMoveEvent 249 178 0 0 0 0 0\n"
                                               "RenderEvent 249 178 0 0 0 0 0\n"
                                               "InteractionEvent 249 178 0 0 0 0 0\n"
                                               "MouseMoveEvent 249 179 0 0 0 0 0\n"
                                               "RenderEvent 249 179 0 0 0 0 0\n"
                                               "InteractionEvent 249 179 0 0 0 0 0\n"
                                               "MouseMoveEvent 250 181 0 0 0 0 0\n"
                                               "RenderEvent 250 181 0 0 0 0 0\n"
                                               "InteractionEvent 250 181 0 0 0 0 0\n"
                                               "MiddleButtonReleaseEvent 250 181 0 0 0 0 0\n"
                                               "EndInteractionEvent 250 181 0 0 0 0 0\n"
                                               "RenderEvent 250 181 0 0 0 0 0\n"
                                               "MouseMoveEvent 384 1 0 0 0 0 0\n"
                                               "LeaveEvent 399 -8 0 0 0 0 0\n";

int TestAnariVolumeWavelet(int argc, char* argv[])
{
  vtkLogger::SetStderrVerbosity(vtkLogger::Verbosity::VERBOSITY_WARNING);
  std::cout << "CTEST_FULL_OUTPUT (Avoid ctest truncation of output)" << std::endl;
  bool useDebugDevice = false;

  for (int i = 0; i < argc; i++)
  {
    if (!strcmp(argv[i], "-trace"))
    {
      useDebugDevice = true;
      vtkLogger::SetStderrVerbosity(vtkLogger::Verbosity::VERBOSITY_INFO);
    }
  }

  vtkNew<vtkRTAnalyticSource> wavelet;
  wavelet->SetWholeExtent(-10, 10, -10, 10, -10, 10);
  wavelet->SetCenter(0.0, 0.0, 0.0);

  vtkNew<vtkTest::ErrorObserver> errorObserver;

  vtkNew<vtkGPUVolumeRayCastMapper> volumeMapper;
  volumeMapper->SetAutoAdjustSampleDistances(0);
  volumeMapper->SetSampleDistance(0.5);
  volumeMapper->SetInputConnection(wavelet->GetOutputPort());
  volumeMapper->AddObserver(vtkCommand::ErrorEvent, errorObserver);

  vtkNew<vtkVolumeProperty> volumeProperty;
  vtkNew<vtkColorTransferFunction> ctf;
  ctf->AddRGBPoint(37.3531, 0.2, 0.29, 1);
  ctf->AddRGBPoint(157.091, 0.87, 0.87, 0.87);
  ctf->AddRGBPoint(276.829, 0.7, 0.015, 0.15);

  vtkNew<vtkPiecewiseFunction> pwf;
  pwf->AddPoint(37.3531, 0.0);
  pwf->AddPoint(276.829, 1.0);

  volumeProperty->SetColor(ctf);
  volumeProperty->SetScalarOpacity(pwf);
  volumeProperty->SetShade(0);
  volumeProperty->SetScalarOpacityUnitDistance(1.732);

  vtkNew<vtkVolume> volume;
  volume->SetMapper(volumeMapper);
  volume->SetProperty(volumeProperty);

  // Create the renderwindow, interactor and renderer
  vtkNew<vtkRenderWindow> renderWindow;
  renderWindow->SetMultiSamples(0);
  renderWindow->SetSize(401, 399); // NPOT size
  vtkNew<vtkRenderWindowInteractor> iren;
  iren->SetRenderWindow(renderWindow);
  vtkNew<vtkInteractorStyleTrackballCamera> style;
  iren->SetInteractorStyle(style);
  vtkNew<vtkRenderer> renderer;
  renderer->SetBackground(0.3, 0.3, 0.4);
  renderWindow->AddRenderer(renderer);

  renderer->AddVolume(volume);

  // Attach ANARI render pass
  vtkNew<vtkAnariPass> anariPass;
  renderer->SetPass(anariPass);

  if (useDebugDevice)
  {
    vtkAnariRendererNode::SetUseDebugDevice(1, renderer);
    vtkNew<vtkTesting> testing;

    std::string traceDir = testing->GetTempDirectory();
    traceDir += "/anari-trace";
    traceDir += "/TestAnariVolumeWavelet";
    vtkAnariRendererNode::SetDebugDeviceDirectory(traceDir.c_str(), renderer);
  }

  vtkAnariRendererNode::SetLibraryName("environment", renderer);
  vtkAnariRendererNode::SetSamplesPerPixel(6, renderer);
  vtkAnariRendererNode::SetLightFalloff(.5, renderer);
  vtkAnariRendererNode::SetUseDenoiser(1, renderer);
  vtkAnariRendererNode::SetCompositeOnGL(1, renderer);

  renderer->ResetCamera();
  renderWindow->Render();

  auto anariRendererNode = anariPass->GetSceneGraph();
  auto extensions = anariRendererNode->GetAnariDeviceExtensions();

  if (extensions.ANARI_KHR_SPATIAL_FIELD_STRUCTURED_REGULAR)
  {
    iren->Initialize();

    vtkNew<vtkInteractorEventRecorder> recorder;
    recorder->SetInteractor(iren);
    recorder->ReadFromInputStringOn();
    recorder->SetInputString(TestAnariVolumeWaveletLog);
    recorder->Play();
    recorder->Off();

    int retVal = vtkRegressionTestImageThreshold(renderWindow, 1.0);
    return !retVal;
  }

  std::cout << "Required feature KHR_VOLUME_TRANSFER_FUNCTION1D not supported." << std::endl;
  return VTK_SKIP_RETURN_CODE;
}
