/*=========================================================================

  Program:   Visualization Toolkit
  Module:    TestAnariCameraInside.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

  This software is distributed WITHOUT ANY WARRANTY; without even
  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

// Description
// This is a test for clipping of volume using the camera near plane when the
// camera is inside the volume. The test renders the ironProt dataset and
// dollies the camera inside the dataset.

#include "vtkColorTransferFunction.h"
#include "vtkGPUVolumeRayCastMapper.h"
#include "vtkInteractorEventRecorder.h"
#include "vtkInteractorStyleTrackballCamera.h"
#include "vtkLogger.h"
#include "vtkNew.h"
#include "vtkPiecewiseFunction.h"
#include "vtkRegressionTestImage.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkRenderer.h"
#include "vtkStructuredPointsReader.h"
#include "vtkTestUtilities.h"
#include "vtkTesting.h"
#include "vtkVolume.h"
#include "vtkVolumeProperty.h"

#include "vtkAnariPass.h"
#include "vtkAnariRendererNode.h"

static const char* TestAnariCameraInsideLog = "# StreamVersion 1\n"
                                              "EnterEvent 298 27 0 0 0 0 0\n"
                                              "MouseMoveEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelBackwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelBackwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelBackwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelBackwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelBackwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelBackwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelBackwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelBackwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelBackwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelBackwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelBackwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelBackwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelBackwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseWheelBackwardEvent 200 142 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 1 0\n"
                                              "RenderEvent 200 142 0 0 0 1 0\n"
                                              "MouseWheelBackwardEvent 200 142 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 142 0 0 0 0 0\n"
                                              "RenderEvent 200 142 0 0 0 0 0\n"
                                              "MouseMoveEvent 200 141 0 0 0 0 0\n"
                                              "MouseWheelBackwardEvent 200 141 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 141 0 0 0 1 0\n"
                                              "RenderEvent 200 141 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 141 0 0 0 1 0\n"
                                              "RenderEvent 200 141 0 0 0 1 0\n"
                                              "MouseWheelBackwardEvent 200 141 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 141 0 0 0 0 0\n"
                                              "RenderEvent 200 141 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 141 0 0 0 0 0\n"
                                              "RenderEvent 200 141 0 0 0 0 0\n"
                                              "MouseWheelBackwardEvent 200 141 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 141 0 0 0 1 0\n"
                                              "RenderEvent 200 141 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 141 0 0 0 1 0\n"
                                              "RenderEvent 200 141 0 0 0 1 0\n"
                                              "MouseWheelBackwardEvent 200 141 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 141 0 0 0 0 0\n"
                                              "RenderEvent 200 141 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 141 0 0 0 0 0\n"
                                              "RenderEvent 200 141 0 0 0 0 0\n"
                                              "MouseWheelBackwardEvent 200 141 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 141 0 0 0 1 0\n"
                                              "RenderEvent 200 141 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 141 0 0 0 1 0\n"
                                              "RenderEvent 200 141 0 0 0 1 0\n"
                                              "MouseWheelBackwardEvent 200 141 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 141 0 0 0 0 0\n"
                                              "RenderEvent 200 141 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 141 0 0 0 0 0\n"
                                              "RenderEvent 200 141 0 0 0 0 0\n"
                                              "MouseWheelBackwardEvent 200 141 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 141 0 0 0 1 0\n"
                                              "RenderEvent 200 141 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 141 0 0 0 1 0\n"
                                              "RenderEvent 200 141 0 0 0 1 0\n"
                                              "MouseWheelBackwardEvent 200 141 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 141 0 0 0 0 0\n"
                                              "RenderEvent 200 141 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 141 0 0 0 0 0\n"
                                              "RenderEvent 200 141 0 0 0 0 0\n"
                                              "MouseWheelBackwardEvent 200 141 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 141 0 0 0 1 0\n"
                                              "RenderEvent 200 141 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 141 0 0 0 1 0\n"
                                              "RenderEvent 200 141 0 0 0 1 0\n"
                                              "MouseWheelBackwardEvent 200 141 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 141 0 0 0 0 0\n"
                                              "RenderEvent 200 141 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 141 0 0 0 0 0\n"
                                              "RenderEvent 200 141 0 0 0 0 0\n"
                                              "MouseWheelBackwardEvent 200 141 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 141 0 0 0 0 0\n"
                                              "RenderEvent 200 141 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 141 0 0 0 0 0\n"
                                              "RenderEvent 200 141 0 0 0 0 0\n"
                                              "MouseWheelBackwardEvent 200 141 0 0 0 1 0\n"
                                              "StartInteractionEvent 200 141 0 0 0 1 0\n"
                                              "RenderEvent 200 141 0 0 0 1 0\n"
                                              "EndInteractionEvent 200 141 0 0 0 1 0\n"
                                              "RenderEvent 200 141 0 0 0 1 0\n"
                                              "MouseWheelBackwardEvent 200 141 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 141 0 0 0 0 0\n"
                                              "RenderEvent 200 141 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 141 0 0 0 0 0\n"
                                              "RenderEvent 200 141 0 0 0 0 0\n"
                                              "MouseWheelBackwardEvent 200 141 0 0 0 0 0\n"
                                              "StartInteractionEvent 200 141 0 0 0 0 0\n"
                                              "RenderEvent 200 141 0 0 0 0 0\n"
                                              "EndInteractionEvent 200 141 0 0 0 0 0\n"
                                              "RenderEvent 200 141 0 0 0 0 0\n"
                                              "MouseMoveEvent 154 175 0 0 0 0 0\n"
                                              "LeftButtonPressEvent 154 175 0 0 0 0 0\n"
                                              "StartInteractionEvent 154 175 0 0 0 0 0\n"
                                              "MouseMoveEvent 153 176 0 0 0 0 0\n"
                                              "RenderEvent 153 176 0 0 0 0 0\n"
                                              "InteractionEvent 153 176 0 0 0 0 0\n"
                                              "MouseMoveEvent 152 175 0 0 0 0 0\n"
                                              "RenderEvent 152 175 0 0 0 0 0\n"
                                              "InteractionEvent 152 175 0 0 0 0 0\n"
                                              "MouseMoveEvent 152 174 0 0 0 0 0\n"
                                              "RenderEvent 152 174 0 0 0 0 0\n"
                                              "InteractionEvent 152 174 0 0 0 0 0\n"
                                              "MouseMoveEvent 152 173 0 0 0 0 0\n"
                                              "RenderEvent 152 173 0 0 0 0 0\n"
                                              "InteractionEvent 152 173 0 0 0 0 0\n"
                                              "MouseMoveEvent 152 172 0 0 0 0 0\n"
                                              "RenderEvent 152 172 0 0 0 0 0\n"
                                              "InteractionEvent 152 172 0 0 0 0 0\n"
                                              "MouseMoveEvent 152 169 0 0 0 0 0\n"
                                              "RenderEvent 152 169 0 0 0 0 0\n"
                                              "InteractionEvent 152 169 0 0 0 0 0\n"
                                              "MouseMoveEvent 152 168 0 0 0 0 0\n"
                                              "RenderEvent 152 168 0 0 0 0 0\n"
                                              "InteractionEvent 152 168 0 0 0 0 0\n"
                                              "MouseMoveEvent 152 165 0 0 0 0 0\n"
                                              "RenderEvent 152 165 0 0 0 0 0\n"
                                              "InteractionEvent 152 165 0 0 0 0 0\n"
                                              "MouseMoveEvent 152 162 0 0 0 0 0\n"
                                              "RenderEvent 152 162 0 0 0 0 0\n"
                                              "InteractionEvent 152 162 0 0 0 0 0\n"
                                              "MouseMoveEvent 152 160 0 0 0 0 0\n"
                                              "RenderEvent 152 160 0 0 0 0 0\n"
                                              "InteractionEvent 152 160 0 0 0 0 0\n"
                                              "MouseMoveEvent 152 156 0 0 0 0 0\n"
                                              "RenderEvent 152 156 0 0 0 0 0\n"
                                              "InteractionEvent 152 156 0 0 0 0 0\n"
                                              "MouseMoveEvent 152 152 0 0 0 0 0\n"
                                              "RenderEvent 152 152 0 0 0 0 0\n"
                                              "InteractionEvent 152 152 0 0 0 0 0\n"
                                              "MouseMoveEvent 152 148 0 0 0 0 0\n"
                                              "RenderEvent 152 148 0 0 0 0 0\n"
                                              "InteractionEvent 152 148 0 0 0 0 0\n"
                                              "MouseMoveEvent 152 144 0 0 0 0 0\n"
                                              "RenderEvent 152 144 0 0 0 0 0\n"
                                              "InteractionEvent 152 144 0 0 0 0 0\n"
                                              "MouseMoveEvent 152 141 0 0 0 0 0\n"
                                              "RenderEvent 152 141 0 0 0 0 0\n"
                                              "InteractionEvent 152 141 0 0 0 0 0\n"
                                              "MouseMoveEvent 152 138 0 0 0 0 0\n"
                                              "RenderEvent 152 138 0 0 0 0 0\n"
                                              "InteractionEvent 152 138 0 0 0 0 0\n"
                                              "MouseMoveEvent 152 134 0 0 0 0 0\n"
                                              "RenderEvent 152 134 0 0 0 0 0\n"
                                              "InteractionEvent 152 134 0 0 0 0 0\n"
                                              "MouseMoveEvent 152 130 0 0 0 0 0\n"
                                              "RenderEvent 152 130 0 0 0 0 0\n"
                                              "InteractionEvent 152 130 0 0 0 0 0\n"
                                              "MouseMoveEvent 152 127 0 0 0 0 0\n"
                                              "RenderEvent 152 127 0 0 0 0 0\n"
                                              "InteractionEvent 152 127 0 0 0 0 0\n"
                                              "MouseMoveEvent 152 123 0 0 0 0 0\n"
                                              "RenderEvent 152 123 0 0 0 0 0\n"
                                              "InteractionEvent 152 123 0 0 0 0 0\n"
                                              "MouseMoveEvent 152 119 0 0 0 0 0\n"
                                              "RenderEvent 152 119 0 0 0 0 0\n"
                                              "InteractionEvent 152 119 0 0 0 0 0\n"
                                              "MouseMoveEvent 151 115 0 0 0 0 0\n"
                                              "RenderEvent 151 115 0 0 0 0 0\n"
                                              "InteractionEvent 151 115 0 0 0 0 0\n"
                                              "MouseMoveEvent 151 113 0 0 0 0 0\n"
                                              "RenderEvent 151 113 0 0 0 0 0\n"
                                              "InteractionEvent 151 113 0 0 0 0 0\n"
                                              "MouseMoveEvent 151 112 0 0 0 0 0\n"
                                              "RenderEvent 151 112 0 0 0 0 0\n"
                                              "InteractionEvent 151 112 0 0 0 0 0\n"
                                              "MouseMoveEvent 151 111 0 0 0 0 0\n"
                                              "RenderEvent 151 111 0 0 0 0 0\n"
                                              "InteractionEvent 151 111 0 0 0 0 0\n"
                                              "MouseMoveEvent 151 110 0 0 0 0 0\n"
                                              "RenderEvent 151 110 0 0 0 0 0\n"
                                              "InteractionEvent 151 110 0 0 0 0 0\n"
                                              "MouseMoveEvent 150 109 0 0 0 0 0\n"
                                              "RenderEvent 150 109 0 0 0 0 0\n"
                                              "InteractionEvent 150 109 0 0 0 0 0\n"
                                              "MouseMoveEvent 150 110 0 0 0 0 0\n"
                                              "RenderEvent 150 110 0 0 0 0 0\n"
                                              "InteractionEvent 150 110 0 0 0 0 0\n"
                                              "MouseMoveEvent 150 111 0 0 0 0 0\n"
                                              "RenderEvent 150 111 0 0 0 0 0\n"
                                              "InteractionEvent 150 111 0 0 0 0 0\n"
                                              "MouseMoveEvent 150 112 0 0 0 0 0\n"
                                              "RenderEvent 150 112 0 0 0 0 0\n"
                                              "InteractionEvent 150 112 0 0 0 0 0\n"
                                              "MouseMoveEvent 149 114 0 0 0 0 0\n"
                                              "RenderEvent 149 114 0 0 0 0 0\n"
                                              "InteractionEvent 149 114 0 0 0 0 0\n"
                                              "MouseMoveEvent 148 118 0 0 0 0 0\n"
                                              "RenderEvent 148 118 0 0 0 0 0\n"
                                              "InteractionEvent 148 118 0 0 0 0 0\n"
                                              "MouseMoveEvent 148 122 0 0 0 0 0\n"
                                              "RenderEvent 148 122 0 0 0 0 0\n"
                                              "InteractionEvent 148 122 0 0 0 0 0\n"
                                              "MouseMoveEvent 148 125 0 0 0 0 0\n"
                                              "RenderEvent 148 125 0 0 0 0 0\n"
                                              "InteractionEvent 148 125 0 0 0 0 0\n"
                                              "MouseMoveEvent 148 127 0 0 0 0 0\n"
                                              "RenderEvent 148 127 0 0 0 0 0\n"
                                              "InteractionEvent 148 127 0 0 0 0 0\n"
                                              "LeftButtonReleaseEvent 148 127 0 0 0 0 0\n"
                                              "EndInteractionEvent 148 127 0 0 0 0 0\n"
                                              "RenderEvent 148 127 0 0 0 0 0\n"
                                              "MouseMoveEvent 147 128 0 0 0 0 0\n"
                                              "MouseMoveEvent 146 127 0 0 0 0 0\n"
                                              "MouseMoveEvent 146 126 0 0 0 0 0\n"
                                              "MouseMoveEvent 146 125 0 0 0 0 0\n"
                                              "MouseMoveEvent 146 124 0 0 0 0 0\n"
                                              "MouseMoveEvent 146 123 0 0 0 0 0\n"
                                              "MouseMoveEvent 146 122 0 0 0 0 0\n"
                                              "MouseMoveEvent 146 120 0 0 0 0 0\n"
                                              "MouseMoveEvent 146 119 0 0 0 0 0\n"
                                              "MouseMoveEvent 146 118 0 0 0 0 0\n"
                                              "MouseMoveEvent 146 117 0 0 0 0 0\n"
                                              "MouseMoveEvent 146 116 0 0 0 0 0\n"
                                              "MouseMoveEvent 147 114 0 0 0 0 0\n"
                                              "MouseMoveEvent 148 113 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 148 113 0 0 0 0 0\n"
                                              "StartInteractionEvent 148 113 0 0 0 0 0\n"
                                              "RenderEvent 148 113 0 0 0 0 0\n"
                                              "EndInteractionEvent 148 113 0 0 0 0 0\n"
                                              "RenderEvent 148 113 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 148 113 0 0 0 0 0\n"
                                              "StartInteractionEvent 148 113 0 0 0 0 0\n"
                                              "RenderEvent 148 113 0 0 0 0 0\n"
                                              "EndInteractionEvent 148 113 0 0 0 0 0\n"
                                              "RenderEvent 148 113 0 0 0 0 0\n"
                                              "MouseMoveEvent 199 55 0 0 0 0 0\n"
                                              "LeftButtonPressEvent 199 55 0 0 0 0 0\n"
                                              "StartInteractionEvent 199 55 0 0 0 0 0\n"
                                              "MouseMoveEvent 200 56 0 0 0 0 0\n"
                                              "RenderEvent 200 56 0 0 0 0 0\n"
                                              "InteractionEvent 200 56 0 0 0 0 0\n"
                                              "MouseMoveEvent 200 57 0 0 0 0 0\n"
                                              "RenderEvent 200 57 0 0 0 0 0\n"
                                              "InteractionEvent 200 57 0 0 0 0 0\n"
                                              "MouseMoveEvent 200 58 0 0 0 0 0\n"
                                              "RenderEvent 200 58 0 0 0 0 0\n"
                                              "InteractionEvent 200 58 0 0 0 0 0\n"
                                              "MouseMoveEvent 200 59 0 0 0 0 0\n"
                                              "RenderEvent 200 59 0 0 0 0 0\n"
                                              "InteractionEvent 200 59 0 0 0 0 0\n"
                                              "MouseMoveEvent 199 60 0 0 0 0 0\n"
                                              "RenderEvent 199 60 0 0 0 0 0\n"
                                              "InteractionEvent 199 60 0 0 0 0 0\n"
                                              "MouseMoveEvent 199 62 0 0 0 0 0\n"
                                              "RenderEvent 199 62 0 0 0 0 0\n"
                                              "InteractionEvent 199 62 0 0 0 0 0\n"
                                              "MouseMoveEvent 198 64 0 0 0 0 0\n"
                                              "RenderEvent 198 64 0 0 0 0 0\n"
                                              "InteractionEvent 198 64 0 0 0 0 0\n"
                                              "MouseMoveEvent 198 66 0 0 0 0 0\n"
                                              "RenderEvent 198 66 0 0 0 0 0\n"
                                              "InteractionEvent 198 66 0 0 0 0 0\n"
                                              "MouseMoveEvent 197 67 0 0 0 0 0\n"
                                              "RenderEvent 197 67 0 0 0 0 0\n"
                                              "InteractionEvent 197 67 0 0 0 0 0\n"
                                              "MouseMoveEvent 197 68 0 0 0 0 0\n"
                                              "RenderEvent 197 68 0 0 0 0 0\n"
                                              "InteractionEvent 197 68 0 0 0 0 0\n"
                                              "MouseMoveEvent 197 69 0 0 0 0 0\n"
                                              "RenderEvent 197 69 0 0 0 0 0\n"
                                              "InteractionEvent 197 69 0 0 0 0 0\n"
                                              "LeftButtonReleaseEvent 197 69 0 0 0 0 0\n"
                                              "EndInteractionEvent 197 69 0 0 0 0 0\n"
                                              "RenderEvent 197 69 0 0 0 0 0\n"
                                              "MouseMoveEvent 205 52 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 205 52 0 0 0 0 0\n"
                                              "StartInteractionEvent 205 52 0 0 0 0 0\n"
                                              "RenderEvent 205 52 0 0 0 0 0\n"
                                              "EndInteractionEvent 205 52 0 0 0 0 0\n"
                                              "RenderEvent 205 52 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 205 52 0 0 0 0 0\n"
                                              "StartInteractionEvent 205 52 0 0 0 0 0\n"
                                              "RenderEvent 205 52 0 0 0 0 0\n"
                                              "EndInteractionEvent 205 52 0 0 0 0 0\n"
                                              "RenderEvent 205 52 0 0 0 0 0\n"
                                              "MouseMoveEvent 206 51 0 0 0 0 0\n"
                                              "MouseMoveEvent 207 50 0 0 0 0 0\n"
                                              "LeftButtonPressEvent 207 50 0 0 0 0 0\n"
                                              "StartInteractionEvent 207 50 0 0 0 0 0\n"
                                              "MouseMoveEvent 206 51 0 0 0 0 0\n"
                                              "RenderEvent 206 51 0 0 0 0 0\n"
                                              "InteractionEvent 206 51 0 0 0 0 0\n"
                                              "MouseMoveEvent 205 51 0 0 0 0 0\n"
                                              "RenderEvent 205 51 0 0 0 0 0\n"
                                              "InteractionEvent 205 51 0 0 0 0 0\n"
                                              "MouseMoveEvent 204 52 0 0 0 0 0\n"
                                              "RenderEvent 204 52 0 0 0 0 0\n"
                                              "InteractionEvent 204 52 0 0 0 0 0\n"
                                              "MouseMoveEvent 203 52 0 0 0 0 0\n"
                                              "RenderEvent 203 52 0 0 0 0 0\n"
                                              "InteractionEvent 203 52 0 0 0 0 0\n"
                                              "MouseMoveEvent 201 52 0 0 0 0 0\n"
                                              "RenderEvent 201 52 0 0 0 0 0\n"
                                              "InteractionEvent 201 52 0 0 0 0 0\n"
                                              "MouseMoveEvent 199 54 0 0 0 0 0\n"
                                              "RenderEvent 199 54 0 0 0 0 0\n"
                                              "InteractionEvent 199 54 0 0 0 0 0\n"
                                              "MouseMoveEvent 197 56 0 0 0 0 0\n"
                                              "RenderEvent 197 56 0 0 0 0 0\n"
                                              "InteractionEvent 197 56 0 0 0 0 0\n"
                                              "MouseMoveEvent 196 57 0 0 0 0 0\n"
                                              "RenderEvent 196 57 0 0 0 0 0\n"
                                              "InteractionEvent 196 57 0 0 0 0 0\n"
                                              "MouseMoveEvent 195 58 0 0 0 0 0\n"
                                              "RenderEvent 195 58 0 0 0 0 0\n"
                                              "InteractionEvent 195 58 0 0 0 0 0\n"
                                              "MouseMoveEvent 194 59 0 0 0 0 0\n"
                                              "RenderEvent 194 59 0 0 0 0 0\n"
                                              "InteractionEvent 194 59 0 0 0 0 0\n"
                                              "MouseMoveEvent 192 61 0 0 0 0 0\n"
                                              "RenderEvent 192 61 0 0 0 0 0\n"
                                              "InteractionEvent 192 61 0 0 0 0 0\n"
                                              "MouseMoveEvent 191 62 0 0 0 0 0\n"
                                              "RenderEvent 191 62 0 0 0 0 0\n"
                                              "InteractionEvent 191 62 0 0 0 0 0\n"
                                              "MouseMoveEvent 190 63 0 0 0 0 0\n"
                                              "RenderEvent 190 63 0 0 0 0 0\n"
                                              "InteractionEvent 190 63 0 0 0 0 0\n"
                                              "MouseMoveEvent 189 64 0 0 0 0 0\n"
                                              "RenderEvent 189 64 0 0 0 0 0\n"
                                              "InteractionEvent 189 64 0 0 0 0 0\n"
                                              "MouseMoveEvent 189 65 0 0 0 0 0\n"
                                              "RenderEvent 189 65 0 0 0 0 0\n"
                                              "InteractionEvent 189 65 0 0 0 0 0\n"
                                              "MouseMoveEvent 188 66 0 0 0 0 0\n"
                                              "RenderEvent 188 66 0 0 0 0 0\n"
                                              "InteractionEvent 188 66 0 0 0 0 0\n"
                                              "MouseMoveEvent 188 67 0 0 0 0 0\n"
                                              "RenderEvent 188 67 0 0 0 0 0\n"
                                              "InteractionEvent 188 67 0 0 0 0 0\n"
                                              "MouseMoveEvent 187 68 0 0 0 0 0\n"
                                              "RenderEvent 187 68 0 0 0 0 0\n"
                                              "InteractionEvent 187 68 0 0 0 0 0\n"
                                              "MouseMoveEvent 187 69 0 0 0 0 0\n"
                                              "RenderEvent 187 69 0 0 0 0 0\n"
                                              "InteractionEvent 187 69 0 0 0 0 0\n"
                                              "MouseMoveEvent 186 70 0 0 0 0 0\n"
                                              "RenderEvent 186 70 0 0 0 0 0\n"
                                              "InteractionEvent 186 70 0 0 0 0 0\n"
                                              "LeftButtonReleaseEvent 186 70 0 0 0 0 0\n"
                                              "EndInteractionEvent 186 70 0 0 0 0 0\n"
                                              "RenderEvent 186 70 0 0 0 0 0\n"
                                              "MouseMoveEvent 255 7 0 0 0 0 0\n"
                                              "LeaveEvent 265 -1 0 0 0 0 0\n"
                                              "EnterEvent 273 0 0 0 0 0 0\n"
                                              "MouseMoveEvent 248 44 0 0 0 0 0\n"
                                              "MouseWheelForwardEvent 248 44 0 0 0 0 0\n"
                                              "StartInteractionEvent 248 44 0 0 0 0 0\n"
                                              "RenderEvent 248 44 0 0 0 0 0\n"
                                              "EndInteractionEvent 248 44 0 0 0 0 0\n"
                                              "RenderEvent 248 44 0 0 0 0 0\n"
                                              "LeftButtonPressEvent 248 44 0 0 0 0 0\n"
                                              "StartInteractionEvent 248 44 0 0 0 0 0\n"
                                              "MouseMoveEvent 246 45 0 0 0 0 0\n"
                                              "RenderEvent 246 45 0 0 0 0 0\n"
                                              "InteractionEvent 246 45 0 0 0 0 0\n"
                                              "MouseMoveEvent 245 46 0 0 0 0 0\n"
                                              "RenderEvent 245 46 0 0 0 0 0\n"
                                              "InteractionEvent 245 46 0 0 0 0 0\n"
                                              "MouseMoveEvent 244 47 0 0 0 0 0\n"
                                              "RenderEvent 244 47 0 0 0 0 0\n"
                                              "InteractionEvent 244 47 0 0 0 0 0\n"
                                              "MouseMoveEvent 243 49 0 0 0 0 0\n"
                                              "RenderEvent 243 49 0 0 0 0 0\n"
                                              "InteractionEvent 243 49 0 0 0 0 0\n"
                                              "MouseMoveEvent 242 50 0 0 0 0 0\n"
                                              "RenderEvent 242 50 0 0 0 0 0\n"
                                              "InteractionEvent 242 50 0 0 0 0 0\n"
                                              "MouseMoveEvent 241 52 0 0 0 0 0\n"
                                              "RenderEvent 241 52 0 0 0 0 0\n"
                                              "InteractionEvent 241 52 0 0 0 0 0\n"
                                              "MouseMoveEvent 240 53 0 0 0 0 0\n"
                                              "RenderEvent 240 53 0 0 0 0 0\n"
                                              "InteractionEvent 240 53 0 0 0 0 0\n"
                                              "MouseMoveEvent 240 54 0 0 0 0 0\n"
                                              "RenderEvent 240 54 0 0 0 0 0\n"
                                              "InteractionEvent 240 54 0 0 0 0 0\n"
                                              "MouseMoveEvent 238 57 0 0 0 0 0\n"
                                              "RenderEvent 238 57 0 0 0 0 0\n"
                                              "InteractionEvent 238 57 0 0 0 0 0\n"
                                              "MouseMoveEvent 238 58 0 0 0 0 0\n"
                                              "RenderEvent 238 58 0 0 0 0 0\n"
                                              "InteractionEvent 238 58 0 0 0 0 0\n"
                                              "MouseMoveEvent 237 59 0 0 0 0 0\n"
                                              "RenderEvent 237 59 0 0 0 0 0\n"
                                              "InteractionEvent 237 59 0 0 0 0 0\n"
                                              "MouseMoveEvent 237 60 0 0 0 0 0\n"
                                              "RenderEvent 237 60 0 0 0 0 0\n"
                                              "InteractionEvent 237 60 0 0 0 0 0\n"
                                              "MouseMoveEvent 236 61 0 0 0 0 0\n"
                                              "RenderEvent 236 61 0 0 0 0 0\n"
                                              "InteractionEvent 236 61 0 0 0 0 0\n"
                                              "MouseMoveEvent 236 62 0 0 0 0 0\n"
                                              "RenderEvent 236 62 0 0 0 0 0\n"
                                              "InteractionEvent 236 62 0 0 0 0 0\n"
                                              "MouseMoveEvent 235 63 0 0 0 0 0\n"
                                              "RenderEvent 235 63 0 0 0 0 0\n"
                                              "InteractionEvent 235 63 0 0 0 0 0\n"
                                              "LeftButtonReleaseEvent 235 63 0 0 0 0 0\n"
                                              "EndInteractionEvent 235 63 0 0 0 0 0\n"
                                              "RenderEvent 235 63 0 0 0 0 0\n"
                                              "MouseMoveEvent 293 51 0 0 0 0 0\n"
                                              "LeaveEvent 304 46 0 0 0 0 0\n"
                                              "EnterEvent 251 4 0 0 0 0 0\n"
                                              "MouseMoveEvent 165 125 0 0 0 0 0\n"
                                              "MouseWheelBackwardEvent 165 125 0 0 0 0 0\n"
                                              "StartInteractionEvent 165 125 0 0 0 0 0\n"
                                              "RenderEvent 165 125 0 0 0 0 0\n"
                                              "EndInteractionEvent 165 125 0 0 0 0 0\n"
                                              "RenderEvent 165 125 0 0 0 0 0\n"
                                              "MouseMoveEvent 161 125 0 0 0 0 0\n"
                                              "LeftButtonPressEvent 161 125 0 0 0 0 0\n"
                                              "StartInteractionEvent 161 125 0 0 0 0 0\n"
                                              "MouseMoveEvent 163 124 0 0 0 0 0\n"
                                              "RenderEvent 163 124 0 0 0 0 0\n"
                                              "InteractionEvent 163 124 0 0 0 0 0\n"
                                              "MouseMoveEvent 164 123 0 0 0 0 0\n"
                                              "RenderEvent 164 123 0 0 0 0 0\n"
                                              "InteractionEvent 164 123 0 0 0 0 0\n"
                                              "MouseMoveEvent 165 122 0 0 0 0 0\n"
                                              "RenderEvent 165 122 0 0 0 0 0\n"
                                              "InteractionEvent 165 122 0 0 0 0 0\n"
                                              "MouseMoveEvent 167 121 0 0 0 0 0\n"
                                              "RenderEvent 167 121 0 0 0 0 0\n"
                                              "InteractionEvent 167 121 0 0 0 0 0\n"
                                              "MouseMoveEvent 169 120 0 0 0 0 0\n"
                                              "RenderEvent 169 120 0 0 0 0 0\n"
                                              "InteractionEvent 169 120 0 0 0 0 0\n"
                                              "LeftButtonReleaseEvent 169 120 0 0 0 0 0\n"
                                              "EndInteractionEvent 169 120 0 0 0 0 0\n"
                                              "RenderEvent 169 120 0 0 0 0 0\n"
                                              "MouseWheelBackwardEvent 169 120 0 0 0 0 0\n"
                                              "StartInteractionEvent 169 120 0 0 0 0 0\n"
                                              "RenderEvent 169 120 0 0 0 0 0\n"
                                              "EndInteractionEvent 169 120 0 0 0 0 0\n"
                                              "RenderEvent 169 120 0 0 0 0 0\n"
                                              "MouseMoveEvent 290 78 0 0 0 0 0\n"
                                              "LeaveEvent 311 71 0 0 0 0 0\n";

int TestAnariCameraInside(int argc, char* argv[])
{
  vtkLogger::SetStderrVerbosity(vtkLogger::Verbosity::VERBOSITY_WARNING);
  std::cout << "CTEST_FULL_OUTPUT (Avoid ctest truncation of output)" << std::endl;
  bool useDebugDevice = false;

  for (int i = 0; i < argc; i++)
  {
    if (!strcmp(argv[i], "-trace"))
    {
      useDebugDevice = true;
      vtkLogger::SetStderrVerbosity(vtkLogger::Verbosity::VERBOSITY_INFO);
    }
  }

  char* volumeFile = vtkTestUtilities::ExpandDataFileName(argc, argv, "Data/ironProt.vtk");
  vtkNew<vtkStructuredPointsReader> reader;
  reader->SetFileName(volumeFile);
  delete[] volumeFile;

  vtkNew<vtkGPUVolumeRayCastMapper> mapper;
  mapper->SetInputConnection(reader->GetOutputPort());
  mapper->SetAutoAdjustSampleDistances(0);
  mapper->SetSampleDistance(1.0);

  vtkNew<vtkColorTransferFunction> color;
  color->AddRGBPoint(0.0, 0.0, 0.0, 0.0);
  color->AddRGBPoint(64.0, 1.0, 0.0, 0.0);
  color->AddRGBPoint(128.0, 0.0, 0.0, 1.0);
  color->AddRGBPoint(192.0, 0.0, 1.0, 0.0);
  color->AddRGBPoint(255.0, 0.0, 0.2, 0.0);

  vtkNew<vtkPiecewiseFunction> opacity;
  opacity->AddPoint(0.0, 0.0);
  opacity->AddPoint(255.0, 1.0);

  vtkNew<vtkVolumeProperty> property;
  property->SetColor(color);
  property->SetScalarOpacity(opacity);
  property->SetInterpolationTypeToLinear();
  property->ShadeOff();

  vtkNew<vtkVolume> volume;
  volume->SetMapper(mapper);
  volume->SetProperty(property);

  vtkNew<vtkRenderWindow> renWin;
  renWin->SetSize(301, 300);
  renWin->SetMultiSamples(0);

  vtkNew<vtkRenderWindowInteractor> iren;
  iren->SetRenderWindow(renWin);
  vtkNew<vtkInteractorStyleTrackballCamera> style;
  iren->SetInteractorStyle(style);

  vtkNew<vtkRenderer> ren;
  renWin->AddRenderer(ren);

  // Attach ANARI render pass
  vtkNew<vtkAnariPass> anariPass;
  ren->SetPass(anariPass);

  if (useDebugDevice)
  {
    vtkAnariRendererNode::SetUseDebugDevice(1, ren);
    vtkNew<vtkTesting> testing;

    std::string traceDir = testing->GetTempDirectory();
    traceDir += "/anari-trace";
    traceDir += "/TestAnariCameraInside";
    vtkAnariRendererNode::SetDebugDeviceDirectory(traceDir.c_str(), ren);
  }

  vtkAnariRendererNode::SetLibraryName("environment", ren);
  vtkAnariRendererNode::SetSamplesPerPixel(6, ren);
  vtkAnariRendererNode::SetLightFalloff(.5, ren);
  vtkAnariRendererNode::SetUseDenoiser(1, ren);
  vtkAnariRendererNode::SetCompositeOnGL(1, ren);

  ren->AddVolume(volume);
  ren->ResetCamera();
  renWin->Render();

  auto anariRendererNode = anariPass->GetSceneGraph();
  auto extensions = anariRendererNode->GetAnariDeviceExtensions();

  if (extensions.ANARI_KHR_SPATIAL_FIELD_STRUCTURED_REGULAR)
  {
    iren->Initialize();

    vtkNew<vtkInteractorEventRecorder> recorder;
    recorder->SetInteractor(iren);
    recorder->ReadFromInputStringOn();
    recorder->SetInputString(TestAnariCameraInsideLog);
    recorder->Play();
    recorder->Off();

    int retVal = vtkRegressionTestImageThreshold(renWin, 1.0);
    return !retVal;
  }

  std::cout << "Required feature KHR_SPATIAL_FIELD_STRUCTURED_REGULAR not supported." << std::endl;
  return VTK_SKIP_RETURN_CODE;
}
