// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkSynchronizableOpenGLAvatars
 * @brief   Serialize/deserialize collection of objects to/from stream/renderer
 *
 * vtkSynchronizableOpenGLAvatars is an abstract base class for
 *
 * @sa
 * vtkSynchronizedRenderers
 */

#ifndef vtkSynchronizableOpenGLAvatars_h
#define vtkSynchronizableOpenGLAvatars_h

#include "vtkSynchronizableActors.h"
#include "vtkRenderingParallelModule.h" // For export macro

#include <memory>                       // for std::unique_ptr

VTK_ABI_NAMESPACE_BEGIN
class vtkRenderer;

class VTKRENDERINGPARALLEL_EXPORT vtkSynchronizableOpenGLAvatars : public vtkSynchronizableActors
{
public:
  ///@{
  /**
   * Standard new, type, and print methods.
   */
  static vtkSynchronizableOpenGLAvatars* New();
  vtkTypeMacro(vtkSynchronizableOpenGLAvatars, vtkSynchronizableActors);
  void PrintSelf(ostream& os, vtkIndent indent) override;
  ///@}

  ///@{
  /**
   *
   */
  void InitializeRenderer(vtkRenderer* ren) override;
  ///@}

  ///@{
  /**
   *
   */
  void CleanUpRenderer(vtkRenderer* ren) override;
  ///@}

  ///@{
  /**
   *
   */
  void SaveToStream(vtkMultiProcessStream& stream, vtkRenderer* ren) override;
  ///@}

  ///@{
  /**
   *
   */
  void RestoreFromStream(vtkMultiProcessStream& stream, vtkRenderer* ren) override;
  ///@}

protected:
  vtkSynchronizableOpenGLAvatars();
  ~vtkSynchronizableOpenGLAvatars() override;

private:
  vtkSynchronizableOpenGLAvatars(const vtkSynchronizableOpenGLAvatars&) = delete;
  void operator=(const vtkSynchronizableOpenGLAvatars&) = delete;

  class vtkInternals;
  std::unique_ptr<vtkInternals> Internal;
};

VTK_ABI_NAMESPACE_END
#endif
