// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkSynchronizableActors
 * @brief   abstract base class for
 *
 * vtkSynchronizableActors is an abstract base class for
 *
 * @sa
 * vtkSynchronizedRenderers
 */

#ifndef vtkSynchronizableActors_h
#define vtkSynchronizableActors_h

#include "vtkRenderingParallelModule.h" // For export macro
#include "vtkObject.h"
#include "vtkMultiProcessStream.h"

VTK_ABI_NAMESPACE_BEGIN
class vtkRenderer;

class VTKRENDERINGPARALLEL_EXPORT vtkSynchronizableActors : public vtkObject
{
public:
  ///@{
  /**
   * Standard new, type, and print methods.
   */
  vtkTypeMacro(vtkSynchronizableActors, vtkObject);
  void PrintSelf(ostream& os, vtkIndent indent) override;
  ///@}

  ///@{
  /**
   *
   */
  virtual void InitializeRenderer(vtkRenderer* ren) = 0;
  ///@}

  ///@{
  /**
   *
   */
  virtual void CleanUpRenderer(vtkRenderer* ren) = 0;
  ///@}

  ///@{
  /**
   *
   */
  virtual void SaveToStream(vtkMultiProcessStream& stream, vtkRenderer* ren) = 0;
  ///@}

  ///@{
  /**
   *
   */
  virtual void RestoreFromStream(vtkMultiProcessStream& stream, vtkRenderer* ren) = 0;
  ///@}

protected:
  vtkSynchronizableActors();
  ~vtkSynchronizableActors() override;

private:
  vtkSynchronizableActors(const vtkSynchronizableActors&) = delete;
  void operator=(const vtkSynchronizableActors&) = delete;
};

VTK_ABI_NAMESPACE_END
#endif
