// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkOpenGLCAVERenderer
 * @brief   OpenXR renderer
 *
 * vtkOpenGLCAVERenderer exists just to create a specific type of camera for
 * CAVE interaction environments.
 */

#ifndef vtkOpenGLCAVERenderer_h
#define vtkOpenGLCAVERenderer_h

#include "vtkRenderingOpenGL2Module.h" // For export macro
#include "vtkOpenGLRenderer.h"

VTK_ABI_NAMESPACE_BEGIN
class VTKRENDERINGOPENGL2_EXPORT vtkOpenGLCAVERenderer : public vtkOpenGLRenderer
{
public:
  static vtkOpenGLCAVERenderer* New();
  vtkTypeMacro(vtkOpenGLCAVERenderer, vtkOpenGLRenderer);
  void PrintSelf(ostream& os, vtkIndent indent) override;

  /**
   * Create a new Camera suitable for use with this type of Renderer.
   */
  VTK_NEWINSTANCE vtkCamera* MakeCamera() override;

protected:
  vtkOpenGLCAVERenderer();
  ~vtkOpenGLCAVERenderer() override = default;

private:
  vtkOpenGLCAVERenderer(const vtkOpenGLCAVERenderer&) = delete;
  void operator=(const vtkOpenGLCAVERenderer&) = delete;
};

VTK_ABI_NAMESPACE_END
#endif
