// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-FileCopyrightText: Copyright (c) 2015, Valve Corporation
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkOpenGLCAVERenderer.h"

#include "vtkCommand.h"
#include "vtkObjectFactory.h"
#include "vtkOpenGLCAVECamera.h"

VTK_ABI_NAMESPACE_BEGIN
vtkStandardNewMacro(vtkOpenGLCAVERenderer);

//------------------------------------------------------------------------------
vtkOpenGLCAVERenderer::vtkOpenGLCAVERenderer()
{
  std::cout << "vtkOpenGLCAVERenderer::vtkOpenGLCAVERenderer()" << std::endl;
}

//------------------------------------------------------------------------------
vtkCamera* vtkOpenGLCAVERenderer::MakeCamera()
{
  std::cout << "vtkOpenGLCAVERenderer::MakeCamera()" << std::endl;
  vtkCamera* cam = vtkOpenGLCAVECamera::New();
  this->InvokeEvent(vtkCommand::CreateCameraEvent, cam);
  return cam;
}

//------------------------------------------------------------------------------
void vtkOpenGLCAVERenderer::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}
VTK_ABI_NAMESPACE_END
