// SPDX-FileCopyrightText: Copyright (c) Kitware Inc.
// SPDX-FileCopyrightText: Copyright (c) Sandia Corporation
// SPDX-License-Identifier: BSD-3-Clause
#ifndef vtkOpenGLCAVECamera_h
#define vtkOpenGLCAVECamera_h

#include "vtkRenderingOpenGL2Module.h" // for export macro
#include <vtkOpenGLCamera.h>

#include <map>
#include <string>
#include <vector>
#include <memory>

class vtkMatrix3x3;
class vtkMatrix4x4;
class vtkRenderer;

class VTKRENDERINGOPENGL2_EXPORT vtkOpenGLCAVECamera : public vtkOpenGLCamera
{
public:
  static vtkOpenGLCAVECamera* New();
  vtkTypeMacro(vtkOpenGLCAVECamera, vtkOpenGLCamera);
  void PrintSelf(ostream& os, vtkIndent indent) override;

  void GetKeyMatrices(vtkRenderer* ren, vtkMatrix4x4*& WCVCMatrix,
    vtkMatrix3x3*& normalMatrix, vtkMatrix4x4*& VCDCMatrix, vtkMatrix4x4*& WCDCMatrix) override;

protected:
  vtkOpenGLCAVECamera();
  virtual ~vtkOpenGLCAVECamera();

private:
  vtkOpenGLCAVECamera(const vtkOpenGLCAVECamera&) = delete;
  void operator=(const vtkOpenGLCAVECamera&) = delete;

  class vtkInternal;
  std::unique_ptr<vtkInternal> Internal;
};

#endif
