#!/bin/sh

set -e

readonly version="3.21.4"

case "$( uname -s )" in
    Linux)
        shatool="sha256sum"
        sha256sum="eddba9da5b60e0b5ec5cbb1a65e504d776e247573204df14f6d004da9bc611f9"
        platform="linux-x86_64"
        ;;
    Darwin)
        shatool="shasum -a 256"
        sha256sum="f818a10fe625b215e31d0c29c19a6563fb5f51ed7cc7727e5011626c11ea321a"
        platform="macos-universal"
        ;;
    *)
        echo "Unrecognized platform $( uname -s )"
        exit 1
        ;;
esac
readonly shatool
readonly sha256sum
readonly platform

readonly filename="cmake-$version-$platform"
readonly tarball="$filename.tar.gz"

cd .gitlab

echo "$sha256sum  $tarball" > cmake.sha256sum
curl -OL "https://github.com/Kitware/CMake/releases/download/v$version/$tarball"
$shatool --check cmake.sha256sum
tar xf "$tarball"
mv "$filename" cmake

if [ "$( uname -s )" = "Darwin" ]; then
    ln -s CMake.app/Contents/bin cmake/bin
fi
