set(vcProjectFile "${RunCMake_TEST_BINARY_DIR}/foo.vcxproj")
if(NOT EXISTS "${vcProjectFile}")
  set(RunCMake_TEST_FAILED "Project file ${vcProjectFile} does not exist.")
  return()
endif()

set(found_CustomBuild_cmp0147_new 0)
set(found_CustomBuild_cmp0147_old 0)
set(found_BuildInParallel_cmp0147_new 0)
set(found_BuildInParallel_cmp0147_old 0)
set(in_CustomBuild_cmp0147 "")
file(STRINGS "${vcProjectFile}" lines)
foreach(line IN LISTS lines)
  if(line MATCHES [[<CustomBuild Include=".*\\cmp0147-old\.txt\.rule">]])
    set(found_CustomBuild_cmp0147_old 1)
    set(in_CustomBuild_cmp0147 "old")
  endif()
  if(line MATCHES [[<CustomBuild Include=".*\\cmp0147-new\.txt\.rule">]])
    set(found_CustomBuild_cmp0147_new 1)
    set(in_CustomBuild_cmp0147 "new")
  endif()
  if(line MATCHES [[</CustomBuild>]])
    set(in_CustomBuild_cmp0147 "")
  endif()
  if(line MATCHES [[<BuildInParallel .*>true</BuildInParallel>]] AND in_CustomBuild_cmp0147)
    set(found_BuildInParallel_cmp0147_${in_CustomBuild_cmp0147} 1)
  endif()
endforeach()
if(NOT found_CustomBuild_cmp0147_new)
  string(APPEND RunCMake_TEST_FAILED "CustomBuild for cmp0147-new.txt.rule not found in\n  ${vcProjectFile}\n")
endif()
if(NOT found_CustomBuild_cmp0147_old)
  string(APPEND RunCMake_TEST_FAILED "CustomBuild for cmp0147-old.txt.rule not found in\n  ${vcProjectFile}\n")
endif()
if(NOT found_BuildInParallel_cmp0147_new)
  string(APPEND RunCMake_TEST_FAILED "BuildInParallel for cmp0147-new.txt.rule not found in\n  ${vcProjectFile}\n")
endif()
if(found_BuildInParallel_cmp0147_old)
  string(APPEND RunCMake_TEST_FAILED "BuildInParallel for cmp0147-old.txt.rule incorrectly found in\n  ${vcProjectFile}\n")
endif()
