﻿using UnityEngine;

namespace ImstkUnity
{
    /// <summary>
    /// This is the base class of Imstk interaction scripts. It exists to provide
    /// different init functions for Imstk classes. This is so that we
    /// can control initialization order in the SimulationManager
    /// </summary>
    public class ImstkInteractionBehaviour : MonoBehaviour
    {
        // TODO Interaction behavior is not ImstkBehavior ???? 
        public string GetFullName()
        {
            string name = gameObject.name;
            Transform parent = gameObject.transform.parent;
            while (parent != null)
            {
                name = parent.gameObject.name + "/" + name;
                parent = parent.transform.parent;
            }
            return name;
        }
        public void ImstkDestroy()
        {
            OnImstkDestroy();
        }

        public virtual Imstk.SceneObject GetImstkInteraction() { return null; }

        public void ImstkInit() { OnImstkInit(); }

        public void ImstkStart() { OnImstkStart(); }


        /// <summary>
        /// Called before initializing the scene
        /// </summary>
        protected virtual void OnImstkInit() { }

        /// <summary>
        /// Called after scene has been initialized
        /// </summary>
        protected virtual void OnImstkStart() { }


        /// <summary>
        /// Called when done
        /// </summary>
        protected virtual void OnImstkDestroy() { }

        static public (T a, U b) ConvertAndOrder<T, U>(DynamicalModel model1, DynamicalModel model2)
        where T : Imstk.CollidingObject
        where U : Imstk.CollidingObject
            {
                if (model1 == null || model2 == null)
                {
                    Debug.LogError("Interaction input can't be null");
                }

                if (model1 as T == null && model2 as T == null)
                {
                    Debug.LogError("One of the models has to be a " + typeof(T).Name);
                }
                if (model1 as U == null && model2 as U == null)
                {
                    Debug.LogError("One of the models has to be a " + typeof(U).Name);
                }

                // This will always return null, null if any of the above errors occur
                if (model1 as T != null) return (model1 as T, model2 as U);
                else return (model2 as T, model1 as U);
            }
    }
}