﻿using UnityEngine;

namespace ImstkUnity
{
    public class Sphere : Geometry
    {
        public Vector3 center = Vector3.zero;
        public float radius = 0.5f;

        public Sphere()
        {
            geomType = GeometryType.Sphere;
        }

        public Vector3 GetTransformedCenter(Transform transform)
        {
            return transform.TransformPoint(center);
        }

        public float GetTransformedRadius(Transform transform)
        {
            Vector3 localScale = transform.localScale;
            float max = Mathf.Max(Mathf.Max(localScale.x, localScale.y), localScale.z);
            return radius * max;
        }

        public Mesh GetMesh()
        {
            Imstk.Sphere geom = this.ToImstkGeometry() as Imstk.Sphere;
            Imstk.SurfaceMesh surfMesh = Imstk.Utils.toUVSphereSurfaceMesh(geom, 7, 7);
            return surfMesh.ToMesh();
        }
    }
}