﻿using UnityEngine;

namespace ImstkUnity
{
    public class Plane : Geometry
    {
        public Plane()
        {
            geomType = GeometryType.Plane;
        }

        public Vector3 GetTransformedCenter(Transform transform)
        {
            return transform.TransformPoint(center);
        }

        public Vector3 GetTransformedNormal(Transform transform)
        {
            return transform.TransformDirection(normal).normalized;
        }

        public Vector3 center = Vector3.zero;
        public Vector3 normal = Vector3.up;
        public float visualWidth = 1.0f; ///> Purely used for visualization
    }
}