﻿using UnityEngine;

namespace ImstkUnity
{
    public enum GeometryType
    {
        Capsule,
        Cylinder,
        HexahedralMesh,
        ImageData,
        LineMesh,
        OrientedBox,
        Plane,
        PointSet,
        Sphere,
        SurfaceMesh,
        TetrahedralMesh,
        UnityMesh
    };

    /// <summary>
    /// We need to reimplement storage for all geometry classes in iMSTK as Unity
    /// import and transfer from editor to runtime works via serialization
    /// afaik it would be quite significant undertaking, and very possibly impossible
    /// to serialize non C# classes, not to mention sensitive to changes. Thus the
    /// base iMSTK geometry cannot be used for geometry storage
    /// </summary>
    public class Geometry : ScriptableObject
    {
        public GeometryType geomType = GeometryType.Plane;

        public bool IsMesh { get { return
                    (geomType == GeometryType.PointSet ||
                    geomType == GeometryType.LineMesh ||
                    geomType == GeometryType.SurfaceMesh ||
                    geomType == GeometryType.TetrahedralMesh ||
                    geomType == GeometryType.HexahedralMesh); } }
        public bool IsVolume { get { return (geomType == GeometryType.TetrahedralMesh || geomType == GeometryType.HexahedralMesh); } }
    };
}