﻿using UnityEngine;

namespace ImstkUnity
{
    public class Cylinder : Geometry
    {
        public Vector3 center = Vector3.zero;
        public float radius = 0.5f;
        public Quaternion orientation = Quaternion.identity;
        public float length = 1.0f;

        public Cylinder()
        {
            geomType = GeometryType.Cylinder;
        }

        public Vector3 GetTransformedCenter(Transform transform)
        {
            return transform.TransformPoint(center);
        }

        public Quaternion GetTransformedOrientation(Transform transform)
        {
            return orientation * transform.rotation;
        }

        public Mesh GetMesh()
        {
            Imstk.Cylinder geom = this.ToImstkGeometry() as Imstk.Cylinder;
            Imstk.SurfaceMesh surfMesh = Imstk.Utils.toSurfaceMesh(geom);
            return surfMesh.ToMesh();
        }
    }
}