﻿using UnityEngine;

namespace ImstkUnity
{
    public class Capsule : Geometry
    {
        public Vector3 center = Vector3.zero;
        public float radius = 0.5f;
        public Quaternion orientation = Quaternion.identity;
        public float length = 1.0f;

        public Capsule()
        {
            geomType = GeometryType.Capsule;
        }

        public Vector3 GetTransformedCenter(Transform transform)
        {
            return transform.TransformPoint(center);
        }

        public Quaternion GetTransformedOrientation(Transform transform)
        {
            return orientation * transform.rotation;
        }

        public Mesh GetMesh()
        {
            Imstk.Capsule geom = this.ToImstkGeometry() as Imstk.Capsule;
            Imstk.SurfaceMesh surfMesh = Imstk.Utils.toSurfaceMesh(geom);
            return surfMesh.ToMesh();
        }
    }
}