using System.Collections;
using System.Threading;
using UnityEngine;

namespace ImstkUnity
{
    [AddComponentMenu("Imstk/VrpnDevice")]
    public class VrpnDevice : TrackingDevice
    {
  
        public string Name = "Tracker0";
        private int _type = 0;
        public int Type { get { return _type; } }

        public bool TrackAnalog = false;
        public bool TrackButtons = false;
        public bool TrackPosition = true;

        public ImstkUnity.VrpnDeviceManager manager;

        public void Awake()
        {
            if (TrackAnalog) _type |= 0x1;
            if (TrackButtons) _type |= 0x2;
            if (TrackPosition) _type |= 0x4;

        }

        public void Start()
        {
            GetDevice();
        }

        protected override Imstk.DeviceClient MakeDevice()
        {
            return manager.MakeDeviceClient(this);
        }
    }
}
