﻿using UnityEngine;

namespace ImstkUnity
{
    /// <summary>
    /// Will produce one ot one map if possible
    /// </summary>
    [AddComponentMenu("Imstk/DeformableMap")]
    public class DeformableMap : GeometryMap
    {
        public bool forceOneOne = false;
        protected override Imstk.GeometryMap MakeMap()
        {
            Imstk.Geometry parent = parentGeom.GetOutputGeometry();
            Imstk.Geometry child = childGeom.GetOutputGeometry();

            if (parentGeom == null || childGeom == null)
            {
                Debug.LogError("GeometryMap: can't create map when one or more inputs is null");
            }


            if (!forceOneOne && (parent.getTypeName() == "TetrahedralMesh" || child.getTypeName() == "TetrahedralMesh"))
            {
                Debug.Log("Trying to make tetrahedral map with " + parent.getTypeName() + " and " + child.getTypeName());
                Imstk.TetraTriangleMap tetraTriangle = new Imstk.TetraTriangleMap(parent, child);
                tetraTriangle.compute();
                if (tetraTriangle.isValid())
                {
                    return tetraTriangle;
                }
            }
            else
            {
                Debug.Log("Trying to make one to one map with " + parent.getTypeName() + " and " + child.getTypeName());
                Imstk.OneToOneMap oneToOne = new Imstk.OneToOneMap(parent, child);
                // Tolerance needed to avoid issues with double/float conversions
                oneToOne.setTolerance(1e-4);
                if (oneToOne.isValid())
                {
                    return oneToOne;
                }
            }

            return null;
        }
    }
}