﻿using UnityEditor;
using UnityEngine;

namespace ImstkUnity
{
    [System.Serializable]
    public class ImstkSettings : ScriptableObject
    {
        // This is absolute path, does not support moving the directory
        // Expects Imstk to be under "Imstk"
        public const string settingsPath = "Assets/Imstk/Resources/ImstkSettings.asset";

        [SerializeField]
        public bool useDeveloperMode = false;

        [SerializeField]
        public string installSourcePath = "";

        [SerializeField]
        public bool useLogger = false;

        [SerializeField]
        public bool useOptimalNumberOfThreads = true;

        [SerializeField]
        public int numThreads = 4;

        public static ImstkSettings Instance()
        {
        //
#if UNITY_EDITOR
            var settings = AssetDatabase.LoadAssetAtPath<ImstkSettings>(settingsPath);
            // If it doesn't exist, create default
            if (settings == null)
            {
                settings = CreateInstance<ImstkSettings>();
                AssetDatabase.CreateAsset(settings, settingsPath);
            }

            //string defines = PlayerSettings.GetScriptingDefineSymbolsForGroup(BuildTargetGroup.Standalone);
            //settings.useDebug = defines.Contains("IMSTK_DEBUG");

            AssetDatabase.SaveAssets();
#else
            var settings = CreateInstance<ImstkSettings>();
#endif
            // Temporary
            return settings;
        }
    }
}