// Upgrade NOTE: replaced 'mul(UNITY_MATRIX_MVP,*)' with 'UnityObjectToClipPos(*)'
// https://forum.unity.com/threads/issues-creating-fixed-width-lines-using-geometry-shader-in-view-space.442178/
// https://cyangamedev.wordpress.com/2020/06/05/urp-shader-code/
// https://docs.unity3d.com/Packages/com.unity.render-pipelines.universal@8.2/manual/writing-shaders-urp-basic-unlit-structure.html
// https://pastebin.com/6QUAGPYZ
Shader "iMSTK/ConnectiveTissue"
{
    Properties
    {
        _BaseMap("Base Map", 2D) = "white" {}
        _BaseColor("Base color", Color) = (1, 1, 1, 1)
        _Thickness("Line Width", Range(0,100)) = 1
        _UVThickness("UV Width", Range(0,1)) = 0.1
    }
        SubShader
        {
            Tags { "RenderType" = "Opaque" "RenderPipeline" = "UniversalRenderPipeline" }
            LOD 100

            Pass
            {

                HLSLPROGRAM
                #pragma vertex vert
                #pragma geometry geom
                #pragma fragment frag
                // make fog work
                #pragma multi_compile_fog

                // The Core.hlsl file contains definitions of frequently used HLSL
                // macros and functions, and also contains #include references to other
                // HLSL files (for example, Common.hlsl, SpaceTransforms.hlsl, etc.).
                #include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Core.hlsl"

                #pragma multi_compile _ _MAIN_LIGHT_SHADOWS
                #pragma multi_compile _ _MAIN_LIGHT_SHADOWS_CASCADE
                #pragma multi_compile _ _SHADOWS_SOFT

                #include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Lighting.hlsl"

                CBUFFER_START(UnityPerMaterial)
                float4 _BaseColor;
                float _Stickout;
                float _Thickness;
                float _UVThickness;
                CBUFFER_END

                struct appdata
                {
                    float4 positionOS : POSITION;
                    float4 normalOS : NORMAL;
                    float2 uv : TEXCOORD0;
                };

                struct v2g
                {
                    float4 positionCS : POSITION;
                    float3 positionWS : TEXCOORD2;
                    float3 normalWS : NORMAL;
                    float2 uv : TEXCOORD0;
                };

                struct g2f
                {
                    float4 positionCS : SV_POSITION;
                    float3 normalWS : NORMAL;
                    float3 positionWS : TEXCOORD2;
                    float2 uv : TEXCOORD0;
                    //UNITY_FOG_COORDS(1)
                };


                TEXTURE2D(_BaseMap);
                SAMPLER(sampler_BaseMap);
                float4 _BaseMap_ST;

                v2g vert(appdata v)
                {
                    v2g o;
                    o.uv = TRANSFORM_TEX(v.uv, _BaseMap);

                    VertexPositionInputs positionInputs = GetVertexPositionInputs(v.positionOS.xyz);
                    o.positionCS = positionInputs.positionCS;
                    o.positionWS = positionInputs.positionWS;

                    VertexNormalInputs normalInputs = GetVertexNormalInputs(v.normalOS.xyz);
                    o.normalWS = normalInputs.normalWS;

                    //UNITY_TRANSFER_FOG(o,o.vertex);
                    return o;
                }

                [maxvertexcount(4)]
                void geom(line v2g v[2], inout TriangleStream<g2f> ts)
                {
                    g2f g[4];

                    //float4 p1 = UnityObjectToClipPos(v[0].vertex);
                    //float4 p2 = UnityObjectToClipPos(v[1].vertex);

                    float4 p1 = v[0].positionCS;
                    float4 p2 = v[1].positionCS;

                    float2 dir = normalize(p2.xy - p1.xy);
                    float2 normal = float2(-dir.y, dir.x);

                    //float4 offset1 = float4(normal * p1.w * _Thickness / 2.0f, 0, 0);
                    //float4 offset2 = float4(normal * p2.w * _Thickness / 2.0f, 0, 0);
                    float4 offset1 = float4(normal * _Thickness / 2.0f, 0, 0);
                    float4 offset2 = float4(normal * _Thickness / 2.0f, 0, 0);
                    offset1.x *= _ScreenParams.y / _ScreenParams.x;
                    offset2.x *= _ScreenParams.y / _ScreenParams.x;

                    float4 o1 = p1 + offset1;
                    float4 o2 = p1 - offset1;
                    float4 o3 = p2 + offset2;
                    float4 o4 = p2 - offset2;

                    g[0].positionCS = o1;
                    g[1].positionCS = o2;
                    g[2].positionCS = o3;
                    g[3].positionCS = o4;

                    // TEMP forward world space position from incoming points
                    // => will make wonky lighting
                    g[0].positionWS = v[0].positionWS;
                    g[1].positionWS = v[0].positionWS;
                    g[2].positionWS = v[1].positionWS;
                    g[3].positionWS = v[1].positionWS;

                    // Forward normals from incoming points
                    g[0].normalWS = v[0].normalWS;
                    g[1].normalWS = v[0].normalWS;
                    g[2].normalWS = v[1].normalWS;
                    g[3].normalWS = v[1].normalWS;


                    // Calculate UV coordinates use thickness parameters 
                    float2 uv1 = v[0].uv;
                    float2 uv2 = v[1].uv;

                    float2 uvDir = normalize(uv2 - uv1);
                    float2 uvOffset = float2(-uvDir.y, uvDir.x) * _UVThickness;


                    g[0].uv = uv1 + uvOffset;
                    g[1].uv = uv1 - uvOffset;
                    g[2].uv = uv2 + uvOffset;
                    g[3].uv = uv2 - uvOffset;


                    ts.Append(g[0]);
                    ts.Append(g[1]);
                    ts.Append(g[2]);
                    ts.Append(g[3]);
                }

                half4  frag(g2f IN) : SV_Target
                {
                    // sample the texture
                    //half4  col = tex2D(_MainTex, i.uv);
                    // apply fog
                    //UNITY_APPLY_FOG(i.fogCoord, col);

                    half4 baseMap = SAMPLE_TEXTURE2D(_BaseMap, sampler_BaseMap, IN.uv);
                    half4 color = baseMap * _BaseColor; // *IN.color; No per vertex color yet

                    float4 shadowCoord = TransformWorldToShadowCoord(IN.positionWS.xyz);
                    Light light = GetMainLight(shadowCoord);

                    half3 diffuse = LightingLambert(light.color, light.direction, IN.normalWS);

                    return half4(color.rgb * diffuse * light.shadowAttenuation, color.a);
                }
                ENDHLSL
            }
        }
}
