#pragma once
#include <memory>
#include <unordered_map>

#include "PInvoke.h"

namespace imstk
{
class TaskGraph;
}

extern std::unordered_map<void*, std::shared_ptr<imstk::TaskGraph>> taskGraphs;

extern "C"
{
    ///
    /// \brief Generate a task graph
    ///
    IMSTK_EXPORT void* genTaskGraph();

    ///
    /// \brief Copy construct a task graph, returns handle to newly constructed taskGraph
    /// 
    IMSTK_EXPORT void* genTaskGraphCopy(void* objectHandle);

    ///
    /// \brief Generate a task graph from primitive data
    /// 
    //IMSTK_EXPORT void* genTaskGraph(PrimitiveTaskGraph data);

    ///
    /// \brief Execute the task graph
    ///
    IMSTK_EXPORT void executeTaskGraph(void* objectHandle, const bool sequential);

    ///
    /// \brief Write the task graph to a file
    ///
    IMSTK_EXPORT void writeTaskGraph(void* objectHandle, const char* filePathName);

    ///
    /// \brief Sets the parameters of the specified PbdObject's model
    ///
    IMSTK_EXPORT void deleteTaskGraph(void* objectHandle);
}