#pragma once

#include <imstkSceneManager.h>

#include <functional>
#include <memory>

#include "PInvoke.h"

namespace simManager
{
extern std::shared_ptr<imstk::SceneManager> sdk;

extern std::function<void()> PreUpdate;
extern std::function<void()> PostUpdate;

extern "C"
{
    ///
    /// \brief Creates the SimulationManager
    ///
    IMSTK_EXPORT void genSimManager(const int numThreads);

    ///
    /// \brief Sets the function to call after advancing the scene
    ///
    IMSTK_EXPORT void setSimManagerPostUpdateCallback(void (*func)());
    ///
    /// \brief Set the function to call before advancing the scene
    /// 
    IMSTK_EXPORT void setSimManagerPreUpdateCallback(void (*func)());

    ///
    /// \brief Set whether to write the task graph or not
    /// 
    IMSTK_EXPORT void setWriteTaskGraph(bool writeTaskGraph);

    ///
    /// \brief Adds an interaction pair to the collision graph
    ///
    IMSTK_EXPORT void addInteractionPair(void* objAHandle,
                                         void* objBHandle,
                                         int interactionType,
                                         int collisionDetectionType);

    ///
    /// \brief Starts the SimulationManager
    ///
    IMSTK_EXPORT void startSimManager();

    ///
    /// \brief Init the active scene
    /// 
    IMSTK_EXPORT void initSimManager();

    ///
    /// \brief Advances a single frame on the active scene
    ///
    IMSTK_EXPORT void advanceFrame(const double dt);

    ///
    /// \brief Gets the elapsed time of the active scene
    ///
    IMSTK_EXPORT double getActiveSceneDt();

    ///
    /// \brief Pauses the SimulationManager
    ///
    IMSTK_EXPORT void pauseSimManager();

    ///
    /// \brief Resumes the SimulationManager from pause
    ///
    IMSTK_EXPORT void resumeSimManager();

    ///
    /// \brief Returns the status of the SimulationManager
    ///
    IMSTK_EXPORT imstk::ThreadStatus getSimManagerStatus();

    ///
    /// \brief Returns the task graph of the active scene
    /// 
    IMSTK_EXPORT void* getTaskGraph();

    ///
    /// \brief Stops the SimulationManager
    ///
    IMSTK_EXPORT void stopSimManager();

    ///
    /// \brief Deletes the SimulationManager
    ///
    IMSTK_EXPORT void deleteSimManager();
}
}; // namespace simManager