#include "Logger.h"

#include <imstkLogger.h>

void (*Log)(const char* str) = nullptr;
void (*LogWarning)(const char* str) = nullptr;
void (*LogError)(const char* str) = nullptr;

void genLogger()
{
    imstk::Logger& logger = imstk::Logger::getInstance();
    // Add a sink to write to file
    //logger.addFileSink("unity", "./");
    logger.addFileSink("unity");
    // Add a sink to write to unity
    logger.addSink(std::make_unique<ForwardingG3Sink>(), &ForwardingG3Sink::ReceiveLogMessage);
}

void deleteLogger()
{
    imstk::Logger::getInstance().destroy();
}

void setLogFunc(void (*func)(const char* str)) { Log = func; }

void setLogWarningFunc(void (*func)(const char* str)) { LogWarning = func; }

void setLogErrorFunc(void (*func)(const char* str)) { LogError = func; }