#pragma once

#include <memory>
#include <string>
#include <thread>

#include "CommonStructs.h"
#include "PInvoke.h"
#include "glm/glm.hpp"

namespace imstk
{
class TrackingDeviceControl;
class HapticDeviceManager;
} // namespace imstk


extern std::shared_ptr<imstk::TrackingDeviceControl> hapticDeviceTracker;
extern std::shared_ptr<imstk::HapticDeviceManager> hapticDeviceTrackerServer;
extern std::thread thread;

extern "C"
{
    ///
    /// \brief Setups the Haptic Device
    ///
    IMSTK_EXPORT void configHapticDeviceTracker(const char* phantomOmni1Name);


    ///
    /// \brief Gets the device's current position
    ///
    IMSTK_EXPORT Vec3f getHapticDeviceTrackerPosition();

    ///
    /// \brief Gets the device's current rotation
    ///
    IMSTK_EXPORT Vec4f getHapticDeviceTrackerRotation();


    ///
    /// \brief Pauses the Haptics Server
    ///
    IMSTK_EXPORT void pauseHapticsServer();

    ///
    /// \brief Stops the Haptics Server and free the memory
    ///
    IMSTK_EXPORT void stopHapticsServer();
}
