#include "HapticDeviceTracker.h"

#include <iMSTK-3.0/imstkHapticDeviceClient.h>
#include <iMSTK-3.0/imstkHapticDeviceManager.h>
#include <iMSTK-3.0/imstkThreadObject.h>
#include <iMSTK-3.0/imstkTrackingDeviceControl.h>


#ifdef iMSTK_USE_OPENHAPTICS

std::shared_ptr<imstk::TrackingDeviceControl> hapticDeviceTracker = nullptr;
std::shared_ptr<imstk::HapticDeviceManager> hapticDeviceTrackerServer = nullptr;


void configHapticDeviceTracker(const char* phantomOmni1Name)
{
    // Device Name
    auto deviceName = std::string(phantomOmni1Name);


    // Device Server
    hapticDeviceTrackerServer = std::make_shared<imstk::HapticDeviceManager>();
    std::shared_ptr<imstk::HapticDeviceClient> client =
        hapticDeviceTrackerServer->makeDeviceClient(deviceName);

    hapticDeviceTrackerServer->start(true);


    // Device Tracker
    hapticDeviceTracker = std::make_shared<imstk::TrackingDeviceControl>(client);
    hapticDeviceTracker->updateTrackingData();
}


Vec3f getHapticDeviceTrackerPosition()
{
    hapticDeviceTracker->updateTrackingData();

    const imstk::Vec3d& deviceCurrentPosition = hapticDeviceTracker->getPosition();

    return Vec3f{ static_cast<float>(deviceCurrentPosition.x()),
                  static_cast<float>(deviceCurrentPosition.y()),
                  static_cast<float>(deviceCurrentPosition.z()) };
}


Vec4f getHapticDeviceTrackerRotation()
{
    hapticDeviceTracker->updateTrackingData();

    const imstk::Quatd& deviceCurrentRotation = hapticDeviceTracker->getRotation();

    return Vec4f{ static_cast<float>(deviceCurrentRotation.x()),
                  static_cast<float>(deviceCurrentRotation.y()),
                  static_cast<float>(deviceCurrentRotation.z()),
                  static_cast<float>(deviceCurrentRotation.w()) };
}


void pauseHapticsServer()
{
    hapticDeviceTrackerServer->stop(true);
}


void stopHapticsServer()
{
    hapticDeviceTrackerServer->stop(true);
    hapticDeviceTracker = nullptr;
    hapticDeviceTrackerServer = nullptr;
}

#endif