#pragma once
#include <memory>
#include <unordered_map>

#include "PInvoke.h"

namespace imstk
{
class DynamicObject;
class PointSet;
} // namespace imstk

extern std::unordered_map<void*, std::shared_ptr<imstk::DynamicObject>> dynamicObjects;

extern "C"
{
    ///
    /// \brief Sets the visual geometry
    ///
    IMSTK_EXPORT void setDynamicObjectVisualGeometry(void* objectHandle,
                                                     void* geometryHandle);

    ///
    /// \brief Sets the physics geometry
    ///
    IMSTK_EXPORT void setDynamicObjectPhysicsGeometry(void* objectHandle,
                                                      void* geometryHandle);

    ///
    /// \brief Sets the collision geometry
    ///
    IMSTK_EXPORT void setDynamicObjectCollisionGeometry(void* objectHandle,
                                                        void* geometryHandle);

    ///
    /// \brief Adds a mapping between the current collision and visual geometries
    ///
    IMSTK_EXPORT void addDynamicObjectCollidingToVisualMap(void* objectHandle);

    ///
    /// \brief Adds a mapping between the current physics and collision geometries
    ///
    IMSTK_EXPORT void addDynamicObjectPhysicsToCollidingMap(void* objectHandle);

    ///
    /// \brief Adds a mapping between the current physics and visual geometries
    ///
    IMSTK_EXPORT void addDynamicObjectPhysicsToVisualMap(void* objectHandle);

    ///
    /// \brief Exports the vertices of a visual geometry
    /// (this is the only unity specific function in our c api, it will likely change)
    ///
    IMSTK_EXPORT void updateDynamicObjectVisualGeometry(void* objectHandle,
                                                        float* vertexBufferPtr);

    ///
    /// \brief Frees the dynamic object
    ///
    IMSTK_EXPORT void deleteDynamicObject(void* objectHandle);
}