﻿using UnityEngine;
using System.Runtime.InteropServices;
using UnityEngine.UI;

namespace Imstk
{
    public class VirtualCoupling : ImstkBehaviour
    {
        public Text tex;
        public GameObject virtualTool;
        public Rigidbody virtualToolrb;

        public float stifness = 1000.0f;
        public Vector3 force;

        public float speed = 0.2f;
        public Vector3 pos;

        public float distance;

        public float closeness = 0.01f;

        public bool rotation = false;
        public float angle = 0.0f;
        public Vector3 torque;
        public float rotationalSpeed = 2.0f;
        public float stifnessTorque = 3000.0f;

        public Quaternion initRot;

        public Quaternion rotationalQuat;
        public bool forceEnabled = false;
        public float outputForceStifness = 0.00001f;

        public float[] forceOutput = new float[3];
        public Collider colliderVIRTUAL;

        public Collider colliderOBSTACLE;
        public GameObject objectOBSTACLE;

        public float forceStartingDistance = 2.0f;

        public string hapticDeviceTrackerName;
        public float setForce;

        private Vector3 hapticsTransformValues;

        private Vector4 hapticsRotationValues;


        protected override void OnImstkInit()
        {
            configHapticDeviceTracker(hapticDeviceTrackerName);

        }

        protected override void OnImstkStart()
        {
            RegisterPostUpdate();


        }

        private void Start()
        {

            virtualToolrb = virtualTool.GetComponent<Rigidbody>();
            initRot = transform.rotation;
        }
        // Update is called once per frame
        //private void Update()
        //{
        //    this.transform.position = new Vector3(-hapticsTransformValues.x * speed, -hapticsTransformValues.y * speed, -hapticsTransformValues.z * speed);
        //    this.transform.rotation = new Quaternion(-hapticsRotationValues.x, -hapticsRotationValues.y, hapticsRotationValues.z, hapticsRotationValues.w);
        //}

        protected override void OnImstkPostUpdate()
        {
            hapticsTransformValues = getHapticDeviceTrackerPosition();
            hapticsRotationValues = getHapticDeviceTrackerRotation();
        }

        void Update()
        {
            if (Input.GetKeyDown(KeyCode.LeftControl) || Input.GetKeyUp(KeyCode.LeftControl))
            {

                rotation = !rotation;
            }


        }

        protected override void OnImstkDestroy()
        {

            stopHapticsServer();
        }

        void getPositionInputFromKeyboard()
        {
            float translationy = Input.GetAxis("Vertical") * speed;
            float translationx = Input.GetAxis("Horizontal") * speed;
            if (!rotation)
            {
                this.transform.position = transform.position + new Vector3(translationx, translationy, 0.0f);
            }


        }
        void getRotationalInputFromKeyboard()
        {
            if (rotation)
            {
                float rotx = Input.GetAxis("Vertical") * rotationalSpeed * 360;
                float roty = Input.GetAxis("Horizontal") * rotationalSpeed * 360;
                // float roty = Input.GetAxis("Horizontal") * speed;
                Quaternion quat = Quaternion.AngleAxis(rotx, transform.forward);
                Quaternion quat1 = Quaternion.AngleAxis(roty, transform.right);
                this.transform.rotation = quat1 * quat * this.transform.rotation;

            }

        }

        void getPositionInputFromHaptic()
        {
            this.transform.position = new Vector3(-hapticsTransformValues.x * speed, -hapticsTransformValues.y * speed, -hapticsTransformValues.z * speed);

        }

        void getRotationalInputFromHaptic()
        {
            this.transform.rotation = new Quaternion(-hapticsRotationValues.x, -hapticsRotationValues.y, hapticsRotationValues.z, hapticsRotationValues.w);
        }

        bool computeSurfaceNormals(out Vector3 p_direction, out float p_distance)
        {
            p_direction = new Vector3(0.0f, 0.0f, 0.0f);
            p_distance = 0.0f;
            if (Physics.ComputePenetration(colliderVIRTUAL, virtualTool.transform.position, virtualTool.transform.rotation, colliderOBSTACLE,
                objectOBSTACLE.transform.position,
                objectOBSTACLE.transform.rotation, out p_direction, out p_distance))
            {


                return true;
                //Debug.Log("hitsss...");
                //Debug.DrawRay(objectOBSTACLE.transform.position, objectOBSTACLE.transform.position + direction * 100.0f, Color.yellow);
            }
            else
                return false;





        }
        void computeTranslationForces()
        {
            Vector3 normalizedForce;
            forceOutput[0] = 0.0f;
            forceOutput[1] = 0.0f;
            forceOutput[2] = 0.0f;

            //getPositionInputFromKeyboard();

            getPositionInputFromHaptic();
            distance = Vector3.Distance(virtualTool.transform.position, this.transform.position);

            if (distance > closeness)
            {
                normalizedForce = (virtualTool.transform.position - this.transform.position).normalized;
                force = -stifness * normalizedForce * distance;
                virtualToolrb.AddForce(force, ForceMode.Force);

                ///trying to compute the surface penetration. It is for testing. you could comment this later on
                ///

                if (distance > forceStartingDistance)
                {
                    Vector3 normalizedForce2;
                    //if (computeSurfaceNormals(out normalizedForce2, out distance))
                    //  normalizedForce = (normalizedForce+ normalizedForce2).normalized;
                    //Debug.Log("hitssssssss");
                    forceOutput[0] = Mathf.Clamp(normalizedForce.x * Mathf.Abs(distance - forceStartingDistance) * outputForceStifness, -3.5f, 3.5f);
                    forceOutput[1] = Mathf.Clamp(normalizedForce.y * Mathf.Abs(distance - forceStartingDistance) * outputForceStifness, -3.5f, 3.5f);
                    forceOutput[2] = Mathf.Clamp(-normalizedForce.z * Mathf.Abs(distance - forceStartingDistance) * outputForceStifness, -3.5f, 3.5f);
                    //setForce(forceOutput);
                    Debug.DrawRay(this.transform.position, this.transform.position + normalizedForce * 1000.0f, Color.green);
                }
                else
                {

                    forceOutput[0] = 0.0f;
                    forceOutput[1] = 0.0f;
                    forceOutput[2] = 0.0f;
                    //setForce(forceOutput);


                }


                //if (distance > 2.0) {
                //    forceOutput[0] = Mathf.Clamp(normalizedForce.x * Mathf.Abs((distance - 2.0f))*outputForceStifness, -3.5f, 3.5f);
                //    forceOutput[1] = Mathf.Clamp(normalizedForce.y * Mathf.Abs((distance - 2.0f)) * outputForceStifness, -3.5f, 3.5f);
                //    forceOutput[2] = Mathf.Clamp(-normalizedForce.z * Mathf.Abs((distance - 2.0f)) * outputForceStifness, -3.5f, 3.5f);
                //    setForce(forceOutput);
                //    Debug.DrawRay(this.transform.position, this.transform.position + normalizedForce * 1000.0f, Color.green);
                //}
                //else
                //{
                //    forceOutput[0] = 0.0f;
                //    forceOutput[1] = 0.0f;
                //    forceOutput[2] = 0.0f;
                //    setForce(forceOutput);

                //}
            }
            else

            {
                force.Set(0.0f, 0.0f, 0.0f);
                virtualToolrb.AddForce(force, ForceMode.Force);
                virtualToolrb.velocity.Set(0.0f, 0.0f, 0.0f);

                virtualTool.transform.position = this.transform.position;
            }




        }



        void computeTorqueOneAxis()
        {
            getRotationalInputFromHaptic();
            Quaternion tempQ = transform.rotation * Quaternion.Inverse(virtualTool.transform.rotation);
            Vector3 torqueVector;
            tempQ.ToAngleAxis(out angle, out torqueVector);
            if (angle > 180.0f)
                angle = 180.0f - angle;

            //torqueVector = OrientTorque(torqueVector);
            // torqueVector = new Vector3(tempQ.x, tempQ.y, tempQ.z);
            // angle=tempQ.

            torque = stifnessTorque * torqueVector * angle;// * Time.deltaTime;
            if (Mathf.Abs(angle) > 2.0f)
                virtualToolrb.AddTorque(torque, ForceMode.Force);
        }
        // Update is called once per frame
        void FixedUpdate()
        {

            //testing the haptic
            // getPositionInputFromHaptic();
            //getRotationalInputFromHaptic();

            //computeTranslationForces();
            computeTorqueOneAxis();
            //  tex.text = "Phyics Frame Rate:" + 1.0d / Time.fixedDeltaTime;


        }

        private Vector3 OrientTorque(Vector3 torque)
        {
            // Quaternion's Euler conversion results in (0-360)
            // For torque, we need -180 to 180.

            return new Vector3
            (
                torque.x > 180f ? 180f - torque.x : torque.x,
                torque.y > 180f ? 180f - torque.y : torque.y,
                torque.z > 180f ? 180f - torque.z : torque.z
            );
        }

        // DLL imports
        [DllImport(PInvoke.ImstkUnityLibName)]
        public static extern void configHapticDeviceTracker(string phantomOmni1Name);

        [DllImport(PInvoke.ImstkUnityLibName)]
        protected static extern Vector3 getHapticDeviceTrackerPosition();

        [DllImport(PInvoke.ImstkUnityLibName)]
        protected static extern Vector4 getHapticDeviceTrackerRotation();

        [DllImport(PInvoke.ImstkUnityLibName)]
        protected static extern void pauseHapticsServer();

        [DllImport(PInvoke.ImstkUnityLibName)]
        protected static extern void stopHapticsServer();
    }

}