﻿using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using UnityEngine;

namespace Imstk.Movement
{
    [AddComponentMenu("Imstk/PbdCircleMove")]
    public class PbdCircleMove : ImstkBehaviour
    {
        public GameObject objectToOrbit = null;
        private Vector3 origin = Vector3.zero;
        public double timeStep = 0.1;

        // theta, radius, height/y
        private List<Vector3> projPolarCoords = new List<Vector3>();
        private HashSet<int> fixedIndices = new HashSet<int>();

        private double t = 0.0;
        private IntPtr pbdObjectHandle = IntPtr.Zero;

        protected override void OnImstkStart()
        {
            // Have OnImstkPostUpdate called
            RegisterPostUpdate();

            // Get the intial positions of the fixed vertices
            PbdModel model = gameObject.GetComponentFatal<PbdModel>();
            pbdObjectHandle = model.GetHandle();
            origin = objectToOrbit.transform.position;

            fixedIndices = model.fixedIndices;
            foreach (int index in fixedIndices)
            {
                Vector2 polarCoord = Vector2.zero;
                Vector3 vertex = getPbdStateVertex(pbdObjectHandle, index);
                Vector3 diff = vertex - origin;
                projPolarCoords.Add(new Vector3((float)Math.Atan2(diff.z, diff.x), new Vector2(diff.z, diff.x).magnitude, vertex.y));
            }
        }

        protected override void OnImstkPostUpdate()
        {
            // After updating, update the position of the first vertex
            int i = 0;
            foreach (int index in fixedIndices)
            {
                Vector3 projPolarCoord = projPolarCoords[i];
                Vector3 pos = new Vector3(
                     (float)Math.Sin(projPolarCoord.x - t) * projPolarCoord.y + origin.x,
                     projPolarCoord.z,
                     (float)Math.Cos(projPolarCoord.x - t) * projPolarCoord.y + origin.z);
                setPbdStateVertex(pbdObjectHandle, index, pos);
                i++;
            }
            
            t += timeStep;
        }

        [DllImport(PInvoke.ImstkUnityLibName)]
        private static extern void setPbdStateVertex(IntPtr objectHandle, int index, Vector3 vertex);

        [DllImport(PInvoke.ImstkUnityLibName)]
        private static extern Vector3 getPbdStateVertex(IntPtr objectHandle, int index);
    }
}