﻿using System;
using System.Runtime.InteropServices;
using UnityEngine;

namespace Imstk
{
    public sealed class Logger
    {
        // Register its reverse pinvoke for string print callback
        public static void Register()
        {
            setLogFunc(Marshal.GetFunctionPointerForDelegate(new Action<IntPtr>(Log)));
            setLogWarningFunc(Marshal.GetFunctionPointerForDelegate(new Action<IntPtr>(LogWarning)));
            setLogErrorFunc(Marshal.GetFunctionPointerForDelegate(new Action<IntPtr>(LogError)));
        }

        public static void Log(IntPtr str) { Debug.Log("<color=white>" + Marshal.PtrToStringAnsi(str) + "</color>"); }
        public static void Log(string str) { Debug.Log("<color=white>" + str + "</color>"); }

        public static void LogWarning(IntPtr str) { Debug.LogWarning("<color=orange>" + Marshal.PtrToStringAnsi(str) + "</color>"); }
        public static void LogWarning(string str) { Debug.LogWarning("<color=orange>" + str + "</color>"); }

        public static void LogError(IntPtr str) { Debug.LogError("<color=red>" + Marshal.PtrToStringAnsi(str) + "</color>"); }
        public static void LogError(string str) { Debug.LogError("<color=red>" + str + "</color>"); }


        [DllImport(PInvoke.ImstkUnityLibName)]
        public static extern void genLogger();

        [DllImport(PInvoke.ImstkUnityLibName)]
        public static extern void deleteLogger();

        [DllImport(PInvoke.ImstkUnityLibName)]
        private static extern void setLogFunc(IntPtr funcPtr);

        [DllImport(PInvoke.ImstkUnityLibName)]
        private static extern void setLogWarningFunc(IntPtr funcPtr);

        [DllImport(PInvoke.ImstkUnityLibName)]
        private static extern void setLogErrorFunc(IntPtr funcPtr);
    }
}