﻿using System.Runtime.InteropServices;
using UnityEngine;


namespace Imstk
{
    [AddComponentMenu("Imstk/Devices/Haptics/HapticDeviceTracker")]
    public class HDTracker : ImstkBehaviour
    {

        public string hapticDeviceTrackerName;
        public float setForce;

        public float speed = 0.2f;
        private Vector3 hapticsTransformValues;

        private Vector4 hapticsRotationValues;


        protected override void OnImstkInit()
        {
            configHapticDeviceTracker(hapticDeviceTrackerName);
        }

        protected override void OnImstkStart()
        {
            RegisterPostUpdate();
        }

        // Update is called once per frame
        private void Update()
        {
            this.transform.position = new Vector3(-hapticsTransformValues.x * speed, -hapticsTransformValues.y * speed, -hapticsTransformValues.z * speed);
            this.transform.rotation = new Quaternion(-hapticsRotationValues.x, -hapticsRotationValues.y, hapticsRotationValues.z, hapticsRotationValues.w);
        }

        protected override void OnImstkPostUpdate()
        {
            hapticsTransformValues = getHapticDeviceTrackerPosition();
            hapticsRotationValues = getHapticDeviceTrackerRotation();
        }

        protected override void OnImstkDestroy()
        {

            pauseHapticsServer();
        }


        // DLL imports
        [DllImport(PInvoke.ImstkUnityLibName)]
        public static extern void configHapticDeviceTracker(string phantomOmni1Name);

        [DllImport(PInvoke.ImstkUnityLibName)]
        protected static extern Vector3 getHapticDeviceTrackerPosition();

        [DllImport(PInvoke.ImstkUnityLibName)]
        protected static extern Vector4 getHapticDeviceTrackerRotation();

        [DllImport(PInvoke.ImstkUnityLibName)]
        protected static extern void pauseHapticsServer();

        [DllImport(PInvoke.ImstkUnityLibName)]
        protected static extern void stopHapticsServer();
    }

}