#ifndef vtk_wgpu_h
#define vtk_wgpu_h

#ifndef WEBGPU_CPP_IMPLEMENTATION
#define WEBGPU_CPP_IMPLEMENTATION
#endif

#ifdef __EMSCRIPTEN__
/*
 * We need an up-to-date version of Emscripten for the API support.
 */
#include "webgpu/webgpu_cpp.h"
#include <emscripten/html5_webgpu.h>
#if __EMSCRIPTEN_major__ == 1 &&                                                                   \
  (__EMSCRIPTEN_minor__ < 40 || (__EMSCRIPTEN_minor__ == 40 && __EMSCRIPTEN_tiny__ < 1))
#error "Emscripten 1.40.1 or higher required"
#endif
#elif defined(VTK_USE_DAWN_NATIVE)
#include "webgpu_dawn.hpp"
#elif defined(VTK_USE_WGPU_NATIVE)
#include "webgpu_wgpu.hpp"
#include "wgpu.h"
#define wgpuInstanceRelease wgpuInstanceDrop
#endif

#endif // vtk_wgpu_h
