// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
//
// This example tests the vtkBorderWidget.

// First include the required header files for the VTK classes we are using.
#include "vtkActor.h"
#include "vtkBorderRepresentation.h"
#include "vtkBorderWidget.h"
#include "vtkCommand.h"
#include "vtkInteractorEventRecorder.h"
#include "vtkPolyDataMapper.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkRenderer.h"
#include "vtkSmartPointer.h"
#include "vtkSphereSource.h"

constexpr char BorderWidgetEventLog[] = "# StreamVersion 1\n"
                                        "RenderEvent 0 0 0 0 0 0 0\n"
                                        "EnterEvent 93 1 0 0 0 0 0\n"
                                        "MouseMoveEvent 35 25 0 0 0 0 0\n"
                                        "LeftButtonPressEvent 35 25 0 0 0 0 0\n"
                                        "MouseMoveEvent 35 26 0 0 0 0 0\n"
                                        "RenderEvent 35 26 0 0 0 0 0\n"
                                        "MouseMoveEvent 35 27 0 0 0 0 0\n"
                                        "RenderEvent 35 27 0 0 0 0 0\n"
                                        "MouseMoveEvent 34 27 0 0 0 0 0\n"
                                        "RenderEvent 34 27 0 0 0 0 0\n"
                                        "MouseMoveEvent 34 28 0 0 0 0 0\n"
                                        "RenderEvent 34 28 0 0 0 0 0\n"
                                        "MouseMoveEvent 35 29 0 0 0 0 0\n"
                                        "RenderEvent 35 29 0 0 0 0 0\n"
                                        "MouseMoveEvent 35 30 0 0 0 0 0\n"
                                        "RenderEvent 35 30 0 0 0 0 0\n"
                                        "MouseMoveEvent 35 31 0 0 0 0 0\n"
                                        "RenderEvent 35 31 0 0 0 0 0\n"
                                        "MouseMoveEvent 34 31 0 0 0 0 0\n"
                                        "RenderEvent 34 31 0 0 0 0 0\n"
                                        "MouseMoveEvent 33 30 0 0 0 0 0\n"
                                        "RenderEvent 33 30 0 0 0 0 0\n"
                                        "MouseMoveEvent 33 31 0 0 0 0 0\n"
                                        "RenderEvent 33 31 0 0 0 0 0\n"
                                        "MouseMoveEvent 33 32 0 0 0 0 0\n"
                                        "RenderEvent 33 32 0 0 0 0 0\n"
                                        "MouseMoveEvent 33 33 0 0 0 0 0\n"
                                        "RenderEvent 33 33 0 0 0 0 0\n"
                                        "MouseMoveEvent 33 34 0 0 0 0 0\n"
                                        "RenderEvent 33 34 0 0 0 0 0\n"
                                        "MouseMoveEvent 34 35 0 0 0 0 0\n"
                                        "RenderEvent 34 35 0 0 0 0 0\n"
                                        "MouseMoveEvent 34 36 0 0 0 0 0\n"
                                        "RenderEvent 34 36 0 0 0 0 0\n"
                                        "MouseMoveEvent 35 37 0 0 0 0 0\n"
                                        "RenderEvent 35 37 0 0 0 0 0\n"
                                        "MouseMoveEvent 36 38 0 0 0 0 0\n"
                                        "RenderEvent 36 38 0 0 0 0 0\n"
                                        "MouseMoveEvent 36 39 0 0 0 0 0\n"
                                        "RenderEvent 36 39 0 0 0 0 0\n"
                                        "MouseMoveEvent 37 40 0 0 0 0 0\n"
                                        "RenderEvent 37 40 0 0 0 0 0\n"
                                        "MouseMoveEvent 39 41 0 0 0 0 0\n"
                                        "RenderEvent 39 41 0 0 0 0 0\n"
                                        "MouseMoveEvent 42 43 0 0 0 0 0\n"
                                        "RenderEvent 42 43 0 0 0 0 0\n"
                                        "MouseMoveEvent 44 45 0 0 0 0 0\n"
                                        "RenderEvent 44 45 0 0 0 0 0\n"
                                        "MouseMoveEvent 45 45 0 0 0 0 0\n"
                                        "RenderEvent 45 45 0 0 0 0 0\n"
                                        "MouseMoveEvent 46 46 0 0 0 0 0\n"
                                        "RenderEvent 46 46 0 0 0 0 0\n"
                                        "MouseMoveEvent 52 50 0 0 0 0 0\n"
                                        "RenderEvent 52 50 0 0 0 0 0\n"
                                        "MouseMoveEvent 55 52 0 0 0 0 0\n"
                                        "RenderEvent 55 52 0 0 0 0 0\n"
                                        "MouseMoveEvent 57 54 0 0 0 0 0\n"
                                        "RenderEvent 57 54 0 0 0 0 0\n"
                                        "MouseMoveEvent 56 55 0 0 0 0 0\n"
                                        "RenderEvent 56 55 0 0 0 0 0\n"
                                        "MouseMoveEvent 57 57 0 0 0 0 0\n"
                                        "RenderEvent 57 57 0 0 0 0 0\n"
                                        "MouseMoveEvent 59 60 0 0 0 0 0\n"
                                        "RenderEvent 59 60 0 0 0 0 0\n"
                                        "MouseMoveEvent 60 63 0 0 0 0 0\n"
                                        "RenderEvent 60 63 0 0 0 0 0\n"
                                        "MouseMoveEvent 62 67 0 0 0 0 0\n"
                                        "RenderEvent 62 67 0 0 0 0 0\n"
                                        "MouseMoveEvent 65 70 0 0 0 0 0\n"
                                        "RenderEvent 65 70 0 0 0 0 0\n"
                                        "MouseMoveEvent 65 72 0 0 0 0 0\n"
                                        "RenderEvent 65 72 0 0 0 0 0\n"
                                        "MouseMoveEvent 65 74 0 0 0 0 0\n"
                                        "RenderEvent 65 74 0 0 0 0 0\n"
                                        "MouseMoveEvent 64 75 0 0 0 0 0\n"
                                        "RenderEvent 64 75 0 0 0 0 0\n"
                                        "MouseMoveEvent 64 77 0 0 0 0 0\n"
                                        "RenderEvent 64 77 0 0 0 0 0\n"
                                        "MouseMoveEvent 64 79 0 0 0 0 0\n"
                                        "RenderEvent 64 79 0 0 0 0 0\n"
                                        "MouseMoveEvent 64 80 0 0 0 0 0\n"
                                        "RenderEvent 64 80 0 0 0 0 0\n"
                                        "MouseMoveEvent 64 82 0 0 0 0 0\n"
                                        "RenderEvent 64 82 0 0 0 0 0\n"
                                        "MouseMoveEvent 64 84 0 0 0 0 0\n"
                                        "RenderEvent 64 84 0 0 0 0 0\n"
                                        "MouseMoveEvent 64 87 0 0 0 0 0\n"
                                        "RenderEvent 64 87 0 0 0 0 0\n"
                                        "MouseMoveEvent 64 89 0 0 0 0 0\n"
                                        "RenderEvent 64 89 0 0 0 0 0\n"
                                        "MouseMoveEvent 65 93 0 0 0 0 0\n"
                                        "RenderEvent 65 93 0 0 0 0 0\n"
                                        "MouseMoveEvent 65 97 0 0 0 0 0\n"
                                        "RenderEvent 65 97 0 0 0 0 0\n"
                                        "MouseMoveEvent 65 100 0 0 0 0 0\n"
                                        "RenderEvent 65 100 0 0 0 0 0\n"
                                        "MouseMoveEvent 65 104 0 0 0 0 0\n"
                                        "RenderEvent 65 104 0 0 0 0 0\n"
                                        "MouseMoveEvent 64 107 0 0 0 0 0\n"
                                        "RenderEvent 64 107 0 0 0 0 0\n"
                                        "MouseMoveEvent 62 110 0 0 0 0 0\n"
                                        "RenderEvent 62 110 0 0 0 0 0\n"
                                        "MouseMoveEvent 61 113 0 0 0 0 0\n"
                                        "RenderEvent 61 113 0 0 0 0 0\n"
                                        "MouseMoveEvent 59 116 0 0 0 0 0\n"
                                        "RenderEvent 59 116 0 0 0 0 0\n"
                                        "MouseMoveEvent 58 120 0 0 0 0 0\n"
                                        "RenderEvent 58 120 0 0 0 0 0\n"
                                        "MouseMoveEvent 57 122 0 0 0 0 0\n"
                                        "RenderEvent 57 122 0 0 0 0 0\n"
                                        "MouseMoveEvent 54 127 0 0 0 0 0\n"
                                        "RenderEvent 54 127 0 0 0 0 0\n"
                                        "MouseMoveEvent 51 133 0 0 0 0 0\n"
                                        "RenderEvent 51 133 0 0 0 0 0\n"
                                        "MouseMoveEvent 49 137 0 0 0 0 0\n"
                                        "RenderEvent 49 137 0 0 0 0 0\n"
                                        "MouseMoveEvent 48 141 0 0 0 0 0\n"
                                        "RenderEvent 48 141 0 0 0 0 0\n"
                                        "MouseMoveEvent 46 145 0 0 0 0 0\n"
                                        "RenderEvent 46 145 0 0 0 0 0\n"
                                        "MouseMoveEvent 44 149 0 0 0 0 0\n"
                                        "RenderEvent 44 149 0 0 0 0 0\n"
                                        "MouseMoveEvent 43 151 0 0 0 0 0\n"
                                        "RenderEvent 43 151 0 0 0 0 0\n"
                                        "MouseMoveEvent 42 153 0 0 0 0 0\n"
                                        "RenderEvent 42 153 0 0 0 0 0\n"
                                        "MouseMoveEvent 41 156 0 0 0 0 0\n"
                                        "RenderEvent 41 156 0 0 0 0 0\n"
                                        "MouseMoveEvent 39 158 0 0 0 0 0\n"
                                        "RenderEvent 39 158 0 0 0 0 0\n"
                                        "MouseMoveEvent 39 159 0 0 0 0 0\n"
                                        "RenderEvent 39 159 0 0 0 0 0\n"
                                        "MouseMoveEvent 38 161 0 0 0 0 0\n"
                                        "RenderEvent 38 161 0 0 0 0 0\n"
                                        "MouseMoveEvent 38 162 0 0 0 0 0\n"
                                        "RenderEvent 38 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 38 163 0 0 0 0 0\n"
                                        "RenderEvent 38 163 0 0 0 0 0\n"
                                        "MouseMoveEvent 39 163 0 0 0 0 0\n"
                                        "RenderEvent 39 163 0 0 0 0 0\n"
                                        "MouseMoveEvent 40 163 0 0 0 0 0\n"
                                        "RenderEvent 40 163 0 0 0 0 0\n"
                                        "MouseMoveEvent 40 162 0 0 0 0 0\n"
                                        "RenderEvent 40 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 41 162 0 0 0 0 0\n"
                                        "RenderEvent 41 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 41 161 0 0 0 0 0\n"
                                        "RenderEvent 41 161 0 0 0 0 0\n"
                                        "MouseMoveEvent 41 162 0 0 0 0 0\n"
                                        "RenderEvent 41 162 0 0 0 0 0\n"
                                        "LeftButtonReleaseEvent 41 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 49 154 0 0 0 0 0\n"
                                        "LeftButtonPressEvent 49 154 0 0 0 0 0\n"
                                        "MouseMoveEvent 49 153 0 0 0 0 0\n"
                                        "RenderEvent 49 153 0 0 0 0 0\n"
                                        "MouseMoveEvent 50 153 0 0 0 0 0\n"
                                        "RenderEvent 50 153 0 0 0 0 0\n"
                                        "MouseMoveEvent 50 152 0 0 0 0 0\n"
                                        "RenderEvent 50 152 0 0 0 0 0\n"
                                        "MouseMoveEvent 52 151 0 0 0 0 0\n"
                                        "RenderEvent 52 151 0 0 0 0 0\n"
                                        "MouseMoveEvent 52 150 0 0 0 0 0\n"
                                        "RenderEvent 52 150 0 0 0 0 0\n"
                                        "MouseMoveEvent 55 149 0 0 0 0 0\n"
                                        "RenderEvent 55 149 0 0 0 0 0\n"
                                        "MouseMoveEvent 57 148 0 0 0 0 0\n"
                                        "RenderEvent 57 148 0 0 0 0 0\n"
                                        "MouseMoveEvent 58 147 0 0 0 0 0\n"
                                        "RenderEvent 58 147 0 0 0 0 0\n"
                                        "MouseMoveEvent 63 145 0 0 0 0 0\n"
                                        "RenderEvent 63 145 0 0 0 0 0\n"
                                        "MouseMoveEvent 71 140 0 0 0 0 0\n"
                                        "RenderEvent 71 140 0 0 0 0 0\n"
                                        "MouseMoveEvent 77 138 0 0 0 0 0\n"
                                        "RenderEvent 77 138 0 0 0 0 0\n"
                                        "MouseMoveEvent 81 135 0 0 0 0 0\n"
                                        "RenderEvent 81 135 0 0 0 0 0\n"
                                        "MouseMoveEvent 86 131 0 0 0 0 0\n"
                                        "RenderEvent 86 131 0 0 0 0 0\n"
                                        "MouseMoveEvent 91 129 0 0 0 0 0\n"
                                        "RenderEvent 91 129 0 0 0 0 0\n"
                                        "MouseMoveEvent 95 125 0 0 0 0 0\n"
                                        "RenderEvent 95 125 0 0 0 0 0\n"
                                        "MouseMoveEvent 100 122 0 0 0 0 0\n"
                                        "RenderEvent 100 122 0 0 0 0 0\n"
                                        "MouseMoveEvent 105 118 0 0 0 0 0\n"
                                        "RenderEvent 105 118 0 0 0 0 0\n"
                                        "MouseMoveEvent 112 113 0 0 0 0 0\n"
                                        "RenderEvent 112 113 0 0 0 0 0\n"
                                        "MouseMoveEvent 118 108 0 0 0 0 0\n"
                                        "RenderEvent 118 108 0 0 0 0 0\n"
                                        "MouseMoveEvent 127 99 0 0 0 0 0\n"
                                        "RenderEvent 127 99 0 0 0 0 0\n"
                                        "MouseMoveEvent 131 95 0 0 0 0 0\n"
                                        "RenderEvent 131 95 0 0 0 0 0\n"
                                        "MouseMoveEvent 136 89 0 0 0 0 0\n"
                                        "RenderEvent 136 89 0 0 0 0 0\n"
                                        "MouseMoveEvent 143 83 0 0 0 0 0\n"
                                        "RenderEvent 143 83 0 0 0 0 0\n"
                                        "MouseMoveEvent 149 81 0 0 0 0 0\n"
                                        "RenderEvent 149 81 0 0 0 0 0\n"
                                        "MouseMoveEvent 152 79 0 0 0 0 0\n"
                                        "RenderEvent 152 79 0 0 0 0 0\n"
                                        "MouseMoveEvent 154 78 0 0 0 0 0\n"
                                        "RenderEvent 154 78 0 0 0 0 0\n"
                                        "MouseMoveEvent 156 78 0 0 0 0 0\n"
                                        "RenderEvent 156 78 0 0 0 0 0\n"
                                        "MouseMoveEvent 156 77 0 0 0 0 0\n"
                                        "RenderEvent 156 77 0 0 0 0 0\n"
                                        "MouseMoveEvent 156 76 0 0 0 0 0\n"
                                        "RenderEvent 156 76 0 0 0 0 0\n"
                                        "MouseMoveEvent 157 74 0 0 0 0 0\n"
                                        "RenderEvent 157 74 0 0 0 0 0\n"
                                        "MouseMoveEvent 159 73 0 0 0 0 0\n"
                                        "RenderEvent 159 73 0 0 0 0 0\n"
                                        "MouseMoveEvent 160 72 0 0 0 0 0\n"
                                        "RenderEvent 160 72 0 0 0 0 0\n"
                                        "MouseMoveEvent 160 71 0 0 0 0 0\n"
                                        "RenderEvent 160 71 0 0 0 0 0\n"
                                        "MouseMoveEvent 160 72 0 0 0 0 0\n"
                                        "RenderEvent 160 72 0 0 0 0 0\n"
                                        "MouseMoveEvent 160 73 0 0 0 0 0\n"
                                        "RenderEvent 160 73 0 0 0 0 0\n"
                                        "LeftButtonReleaseEvent 160 73 0 0 0 0 0\n"
                                        "MouseMoveEvent 166 180 0 0 0 0 0\n"
                                        "LeftButtonPressEvent 166 180 0 0 0 0 0\n"
                                        "MouseMoveEvent 167 180 0 0 0 0 0\n"
                                        "RenderEvent 167 180 0 0 0 0 0\n"
                                        "MouseMoveEvent 167 181 0 0 0 0 0\n"
                                        "RenderEvent 167 181 0 0 0 0 0\n"
                                        "MouseMoveEvent 168 181 0 0 0 0 0\n"
                                        "RenderEvent 168 181 0 0 0 0 0\n"
                                        "MouseMoveEvent 168 182 0 0 0 0 0\n"
                                        "RenderEvent 168 182 0 0 0 0 0\n"
                                        "MouseMoveEvent 169 182 0 0 0 0 0\n"
                                        "RenderEvent 169 182 0 0 0 0 0\n"
                                        "MouseMoveEvent 170 183 0 0 0 0 0\n"
                                        "RenderEvent 170 183 0 0 0 0 0\n"
                                        "MouseMoveEvent 171 183 0 0 0 0 0\n"
                                        "RenderEvent 171 183 0 0 0 0 0\n"
                                        "MouseMoveEvent 172 185 0 0 0 0 0\n"
                                        "RenderEvent 172 185 0 0 0 0 0\n"
                                        "MouseMoveEvent 174 185 0 0 0 0 0\n"
                                        "RenderEvent 174 185 0 0 0 0 0\n"
                                        "MouseMoveEvent 178 188 0 0 0 0 0\n"
                                        "RenderEvent 178 188 0 0 0 0 0\n"
                                        "MouseMoveEvent 180 189 0 0 0 0 0\n"
                                        "RenderEvent 180 189 0 0 0 0 0\n"
                                        "MouseMoveEvent 182 190 0 0 0 0 0\n"
                                        "RenderEvent 182 190 0 0 0 0 0\n"
                                        "MouseMoveEvent 185 191 0 0 0 0 0\n"
                                        "RenderEvent 185 191 0 0 0 0 0\n"
                                        "MouseMoveEvent 188 193 0 0 0 0 0\n"
                                        "RenderEvent 188 193 0 0 0 0 0\n"
                                        "MouseMoveEvent 191 194 0 0 0 0 0\n"
                                        "RenderEvent 191 194 0 0 0 0 0\n"
                                        "MouseMoveEvent 192 195 0 0 0 0 0\n"
                                        "RenderEvent 192 195 0 0 0 0 0\n"
                                        "MouseMoveEvent 195 197 0 0 0 0 0\n"
                                        "RenderEvent 195 197 0 0 0 0 0\n"
                                        "MouseMoveEvent 196 198 0 0 0 0 0\n"
                                        "RenderEvent 196 198 0 0 0 0 0\n"
                                        "MouseMoveEvent 198 199 0 0 0 0 0\n"
                                        "RenderEvent 198 199 0 0 0 0 0\n"
                                        "MouseMoveEvent 200 201 0 0 0 0 0\n"
                                        "RenderEvent 200 201 0 0 0 0 0\n"
                                        "MouseMoveEvent 203 201 0 0 0 0 0\n"
                                        "RenderEvent 203 201 0 0 0 0 0\n"
                                        "MouseMoveEvent 207 203 0 0 0 0 0\n"
                                        "RenderEvent 207 203 0 0 0 0 0\n"
                                        "MouseMoveEvent 210 204 0 0 0 0 0\n"
                                        "RenderEvent 210 204 0 0 0 0 0\n"
                                        "MouseMoveEvent 213 205 0 0 0 0 0\n"
                                        "RenderEvent 213 205 0 0 0 0 0\n"
                                        "MouseMoveEvent 214 206 0 0 0 0 0\n"
                                        "RenderEvent 214 206 0 0 0 0 0\n"
                                        "MouseMoveEvent 216 207 0 0 0 0 0\n"
                                        "RenderEvent 216 207 0 0 0 0 0\n"
                                        "MouseMoveEvent 217 209 0 0 0 0 0\n"
                                        "RenderEvent 217 209 0 0 0 0 0\n"
                                        "MouseMoveEvent 218 210 0 0 0 0 0\n"
                                        "RenderEvent 218 210 0 0 0 0 0\n"
                                        "MouseMoveEvent 219 210 0 0 0 0 0\n"
                                        "RenderEvent 219 210 0 0 0 0 0\n"
                                        "MouseMoveEvent 219 211 0 0 0 0 0\n"
                                        "RenderEvent 219 211 0 0 0 0 0\n"
                                        "MouseMoveEvent 220 212 0 0 0 0 0\n"
                                        "RenderEvent 220 212 0 0 0 0 0\n"
                                        "MouseMoveEvent 221 212 0 0 0 0 0\n"
                                        "RenderEvent 221 212 0 0 0 0 0\n"
                                        "MouseMoveEvent 222 213 0 0 0 0 0\n"
                                        "RenderEvent 222 213 0 0 0 0 0\n"
                                        "MouseMoveEvent 223 213 0 0 0 0 0\n"
                                        "RenderEvent 223 213 0 0 0 0 0\n"
                                        "MouseMoveEvent 225 214 0 0 0 0 0\n"
                                        "RenderEvent 225 214 0 0 0 0 0\n"
                                        "MouseMoveEvent 227 214 0 0 0 0 0\n"
                                        "RenderEvent 227 214 0 0 0 0 0\n"
                                        "MouseMoveEvent 229 216 0 0 0 0 0\n"
                                        "RenderEvent 229 216 0 0 0 0 0\n"
                                        "MouseMoveEvent 230 216 0 0 0 0 0\n"
                                        "RenderEvent 230 216 0 0 0 0 0\n"
                                        "MouseMoveEvent 231 216 0 0 0 0 0\n"
                                        "RenderEvent 231 216 0 0 0 0 0\n"
                                        "MouseMoveEvent 231 217 0 0 0 0 0\n"
                                        "RenderEvent 231 217 0 0 0 0 0\n"
                                        "MouseMoveEvent 232 217 0 0 0 0 0\n"
                                        "RenderEvent 232 217 0 0 0 0 0\n"
                                        "MouseMoveEvent 233 217 0 0 0 0 0\n"
                                        "RenderEvent 233 217 0 0 0 0 0\n"
                                        "MouseMoveEvent 234 217 0 0 0 0 0\n"
                                        "RenderEvent 234 217 0 0 0 0 0\n"
                                        "MouseMoveEvent 235 217 0 0 0 0 0\n"
                                        "RenderEvent 235 217 0 0 0 0 0\n"
                                        "LeftButtonReleaseEvent 235 217 0 0 0 0 0\n"
                                        "MouseMoveEvent 23 255 0 0 0 0 0\n"
                                        "LeftButtonPressEvent 23 255 0 0 0 0 0\n"
                                        "MouseMoveEvent 24 255 0 0 0 0 0\n"
                                        "RenderEvent 24 255 0 0 0 0 0\n"
                                        "MouseMoveEvent 25 255 0 0 0 0 0\n"
                                        "RenderEvent 25 255 0 0 0 0 0\n"
                                        "MouseMoveEvent 25 254 0 0 0 0 0\n"
                                        "RenderEvent 25 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 26 254 0 0 0 0 0\n"
                                        "RenderEvent 26 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 27 254 0 0 0 0 0\n"
                                        "RenderEvent 27 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 28 254 0 0 0 0 0\n"
                                        "RenderEvent 28 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 29 254 0 0 0 0 0\n"
                                        "RenderEvent 29 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 30 254 0 0 0 0 0\n"
                                        "RenderEvent 30 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 31 254 0 0 0 0 0\n"
                                        "RenderEvent 31 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 32 254 0 0 0 0 0\n"
                                        "RenderEvent 32 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 33 254 0 0 0 0 0\n"
                                        "RenderEvent 33 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 34 254 0 0 0 0 0\n"
                                        "RenderEvent 34 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 35 254 0 0 0 0 0\n"
                                        "RenderEvent 35 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 36 254 0 0 0 0 0\n"
                                        "RenderEvent 36 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 37 254 0 0 0 0 0\n"
                                        "RenderEvent 37 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 38 254 0 0 0 0 0\n"
                                        "RenderEvent 38 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 39 254 0 0 0 0 0\n"
                                        "RenderEvent 39 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 40 254 0 0 0 0 0\n"
                                        "RenderEvent 40 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 41 254 0 0 0 0 0\n"
                                        "RenderEvent 41 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 41 253 0 0 0 0 0\n"
                                        "RenderEvent 41 253 0 0 0 0 0\n"
                                        "MouseMoveEvent 42 253 0 0 0 0 0\n"
                                        "RenderEvent 42 253 0 0 0 0 0\n"
                                        "LeftButtonReleaseEvent 42 253 0 0 0 0 0\n"
                                        "MouseMoveEvent 42 253 0 0 0 0 0\n"
                                        "MouseMoveEvent 42 34 0 0 0 0 0\n"
                                        "LeftButtonPressEvent 42 34 0 0 0 0 0\n"
                                        "MouseMoveEvent 43 34 0 0 0 0 0\n"
                                        "RenderEvent 43 34 0 0 0 0 0\n"
                                        "MouseMoveEvent 44 34 0 0 0 0 0\n"
                                        "RenderEvent 44 34 0 0 0 0 0\n"
                                        "MouseMoveEvent 44 35 0 0 0 0 0\n"
                                        "RenderEvent 44 35 0 0 0 0 0\n"
                                        "MouseMoveEvent 44 36 0 0 0 0 0\n"
                                        "RenderEvent 44 36 0 0 0 0 0\n"
                                        "MouseMoveEvent 45 36 0 0 0 0 0\n"
                                        "RenderEvent 45 36 0 0 0 0 0\n"
                                        "MouseMoveEvent 44 36 0 0 0 0 0\n"
                                        "RenderEvent 44 36 0 0 0 0 0\n"
                                        "MouseMoveEvent 44 37 0 0 0 0 0\n"
                                        "RenderEvent 44 37 0 0 0 0 0\n"
                                        "MouseMoveEvent 44 38 0 0 0 0 0\n"
                                        "RenderEvent 44 38 0 0 0 0 0\n"
                                        "MouseMoveEvent 43 38 0 0 0 0 0\n"
                                        "RenderEvent 43 38 0 0 0 0 0\n"
                                        "MouseMoveEvent 43 39 0 0 0 0 0\n"
                                        "RenderEvent 43 39 0 0 0 0 0\n"
                                        "MouseMoveEvent 44 39 0 0 0 0 0\n"
                                        "RenderEvent 44 39 0 0 0 0 0\n"
                                        "MouseMoveEvent 44 40 0 0 0 0 0\n"
                                        "RenderEvent 44 40 0 0 0 0 0\n"
                                        "MouseMoveEvent 45 40 0 0 0 0 0\n"
                                        "RenderEvent 45 40 0 0 0 0 0\n"
                                        "MouseMoveEvent 45 41 0 0 0 0 0\n"
                                        "RenderEvent 45 41 0 0 0 0 0\n"
                                        "MouseMoveEvent 46 42 0 0 0 0 0\n"
                                        "RenderEvent 46 42 0 0 0 0 0\n"
                                        "MouseMoveEvent 47 42 0 0 0 0 0\n"
                                        "RenderEvent 47 42 0 0 0 0 0\n"
                                        "MouseMoveEvent 47 43 0 0 0 0 0\n"
                                        "RenderEvent 47 43 0 0 0 0 0\n"
                                        "MouseMoveEvent 48 43 0 0 0 0 0\n"
                                        "RenderEvent 48 43 0 0 0 0 0\n"
                                        "MouseMoveEvent 48 44 0 0 0 0 0\n"
                                        "RenderEvent 48 44 0 0 0 0 0\n"
                                        "MouseMoveEvent 48 45 0 0 0 0 0\n"
                                        "RenderEvent 48 45 0 0 0 0 0\n"
                                        "MouseMoveEvent 49 45 0 0 0 0 0\n"
                                        "RenderEvent 49 45 0 0 0 0 0\n"
                                        "LeftButtonReleaseEvent 49 45 0 0 0 0 0\n"
                                        "MouseMoveEvent 49 45 0 0 0 0 0\n"
                                        "MouseMoveEvent 61 112 0 0 0 0 0\n"
                                        "LeftButtonPressEvent 61 112 0 0 0 0 0\n"
                                        "MouseMoveEvent 62 112 0 0 0 0 0\n"
                                        "RenderEvent 62 112 0 0 0 0 0\n"
                                        "MouseMoveEvent 63 112 0 0 0 0 0\n"
                                        "RenderEvent 63 112 0 0 0 0 0\n"
                                        "LeftButtonReleaseEvent 63 112 0 0 0 0 0\n"
                                        "MouseMoveEvent 240 130 0 0 0 0 0\n"
                                        "LeftButtonPressEvent 240 130 0 0 0 0 0\n"
                                        "MouseMoveEvent 239 130 0 0 0 0 0\n"
                                        "RenderEvent 239 130 0 0 0 0 0\n"
                                        "MouseMoveEvent 238 130 0 0 0 0 0\n"
                                        "RenderEvent 238 130 0 0 0 0 0\n"
                                        "MouseMoveEvent 237 130 0 0 0 0 0\n"
                                        "RenderEvent 237 130 0 0 0 0 0\n"
                                        "MouseMoveEvent 236 130 0 0 0 0 0\n"
                                        "RenderEvent 236 130 0 0 0 0 0\n"
                                        "MouseMoveEvent 235 130 0 0 0 0 0\n"
                                        "RenderEvent 235 130 0 0 0 0 0\n"
                                        "LeftButtonReleaseEvent 235 130 0 0 0 0 0\n"
                                        "MouseMoveEvent 194 227 0 0 0 0 0\n"
                                        "LeftButtonPressEvent 194 227 0 0 0 0 0\n"
                                        "MouseMoveEvent 194 226 0 0 0 0 0\n"
                                        "RenderEvent 194 226 0 0 0 0 0\n"
                                        "LeftButtonReleaseEvent 194 226 0 0 0 0 0\n"
                                        "MouseMoveEvent 164 59 0 0 0 0 0\n"
                                        "LeftButtonPressEvent 164 59 0 0 0 0 0\n"
                                        "MouseMoveEvent 164 60 0 0 0 0 0\n"
                                        "RenderEvent 164 60 0 0 0 0 0\n"
                                        "MouseMoveEvent 164 61 0 0 0 0 0\n"
                                        "RenderEvent 164 61 0 0 0 0 0\n"
                                        "LeftButtonReleaseEvent 164 61 0 0 0 0 0\n"
                                        "MouseMoveEvent 164 61 0 0 0 0 0\n"
                                        "MouseMoveEvent 151 138 0 0 0 0 0\n"
                                        "LeftButtonPressEvent 151 138 0 0 0 0 0\n"
                                        "MouseMoveEvent 150 137 0 0 0 0 0\n"
                                        "RenderEvent 150 137 0 0 0 0 0\n"
                                        "MouseMoveEvent 149 137 0 0 0 0 0\n"
                                        "RenderEvent 149 137 0 0 0 0 0\n"
                                        "MouseMoveEvent 148 137 0 0 0 0 0\n"
                                        "RenderEvent 148 137 0 0 0 0 0\n"
                                        "MouseMoveEvent 147 137 0 0 0 0 0\n"
                                        "RenderEvent 147 137 0 0 0 0 0\n"
                                        "MouseMoveEvent 146 137 0 0 0 0 0\n"
                                        "RenderEvent 146 137 0 0 0 0 0\n"
                                        "MouseMoveEvent 145 137 0 0 0 0 0\n"
                                        "RenderEvent 145 137 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 137 0 0 0 0 0\n"
                                        "RenderEvent 144 137 0 0 0 0 0\n"
                                        "MouseMoveEvent 143 137 0 0 0 0 0\n"
                                        "RenderEvent 143 137 0 0 0 0 0\n"
                                        "MouseMoveEvent 142 137 0 0 0 0 0\n"
                                        "RenderEvent 142 137 0 0 0 0 0\n"
                                        "MouseMoveEvent 141 137 0 0 0 0 0\n"
                                        "RenderEvent 141 137 0 0 0 0 0\n"
                                        "MouseMoveEvent 140 137 0 0 0 0 0\n"
                                        "RenderEvent 140 137 0 0 0 0 0\n"
                                        "MouseMoveEvent 139 137 0 0 0 0 0\n"
                                        "RenderEvent 139 137 0 0 0 0 0\n"
                                        "MouseMoveEvent 139 136 0 0 0 0 0\n"
                                        "RenderEvent 139 136 0 0 0 0 0\n"
                                        "MouseMoveEvent 138 136 0 0 0 0 0\n"
                                        "RenderEvent 138 136 0 0 0 0 0\n"
                                        "MouseMoveEvent 137 135 0 0 0 0 0\n"
                                        "RenderEvent 137 135 0 0 0 0 0\n"
                                        "MouseMoveEvent 136 135 0 0 0 0 0\n"
                                        "RenderEvent 136 135 0 0 0 0 0\n"
                                        "MouseMoveEvent 135 134 0 0 0 0 0\n"
                                        "RenderEvent 135 134 0 0 0 0 0\n"
                                        "MouseMoveEvent 134 133 0 0 0 0 0\n"
                                        "RenderEvent 134 133 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 131 0 0 0 0 0\n"
                                        "RenderEvent 133 131 0 0 0 0 0\n"
                                        "MouseMoveEvent 132 130 0 0 0 0 0\n"
                                        "RenderEvent 132 130 0 0 0 0 0\n"
                                        "MouseMoveEvent 132 129 0 0 0 0 0\n"
                                        "RenderEvent 132 129 0 0 0 0 0\n"
                                        "MouseMoveEvent 132 128 0 0 0 0 0\n"
                                        "RenderEvent 132 128 0 0 0 0 0\n"
                                        "MouseMoveEvent 132 127 0 0 0 0 0\n"
                                        "RenderEvent 132 127 0 0 0 0 0\n"
                                        "MouseMoveEvent 132 126 0 0 0 0 0\n"
                                        "RenderEvent 132 126 0 0 0 0 0\n"
                                        "MouseMoveEvent 132 125 0 0 0 0 0\n"
                                        "RenderEvent 132 125 0 0 0 0 0\n"
                                        "MouseMoveEvent 132 123 0 0 0 0 0\n"
                                        "RenderEvent 132 123 0 0 0 0 0\n"
                                        "MouseMoveEvent 132 121 0 0 0 0 0\n"
                                        "RenderEvent 132 121 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 119 0 0 0 0 0\n"
                                        "RenderEvent 133 119 0 0 0 0 0\n"
                                        "MouseMoveEvent 134 118 0 0 0 0 0\n"
                                        "RenderEvent 134 118 0 0 0 0 0\n"
                                        "MouseMoveEvent 135 117 0 0 0 0 0\n"
                                        "RenderEvent 135 117 0 0 0 0 0\n"
                                        "MouseMoveEvent 136 115 0 0 0 0 0\n"
                                        "RenderEvent 136 115 0 0 0 0 0\n"
                                        "MouseMoveEvent 138 113 0 0 0 0 0\n"
                                        "RenderEvent 138 113 0 0 0 0 0\n"
                                        "MouseMoveEvent 141 111 0 0 0 0 0\n"
                                        "RenderEvent 141 111 0 0 0 0 0\n"
                                        "MouseMoveEvent 143 107 0 0 0 0 0\n"
                                        "RenderEvent 143 107 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 107 0 0 0 0 0\n"
                                        "RenderEvent 144 107 0 0 0 0 0\n"
                                        "MouseMoveEvent 145 107 0 0 0 0 0\n"
                                        "RenderEvent 145 107 0 0 0 0 0\n"
                                        "MouseMoveEvent 146 107 0 0 0 0 0\n"
                                        "RenderEvent 146 107 0 0 0 0 0\n"
                                        "MouseMoveEvent 148 107 0 0 0 0 0\n"
                                        "RenderEvent 148 107 0 0 0 0 0\n"
                                        "MouseMoveEvent 149 107 0 0 0 0 0\n"
                                        "RenderEvent 149 107 0 0 0 0 0\n"
                                        "MouseMoveEvent 151 107 0 0 0 0 0\n"
                                        "RenderEvent 151 107 0 0 0 0 0\n"
                                        "MouseMoveEvent 154 108 0 0 0 0 0\n"
                                        "RenderEvent 154 108 0 0 0 0 0\n"
                                        "MouseMoveEvent 157 109 0 0 0 0 0\n"
                                        "RenderEvent 157 109 0 0 0 0 0\n"
                                        "MouseMoveEvent 161 111 0 0 0 0 0\n"
                                        "RenderEvent 161 111 0 0 0 0 0\n"
                                        "MouseMoveEvent 167 112 0 0 0 0 0\n"
                                        "RenderEvent 167 112 0 0 0 0 0\n"
                                        "MouseMoveEvent 168 114 0 0 0 0 0\n"
                                        "RenderEvent 168 114 0 0 0 0 0\n"
                                        "MouseMoveEvent 169 116 0 0 0 0 0\n"
                                        "RenderEvent 169 116 0 0 0 0 0\n"
                                        "MouseMoveEvent 169 117 0 0 0 0 0\n"
                                        "RenderEvent 169 117 0 0 0 0 0\n"
                                        "MouseMoveEvent 169 120 0 0 0 0 0\n"
                                        "RenderEvent 169 120 0 0 0 0 0\n"
                                        "MouseMoveEvent 169 122 0 0 0 0 0\n"
                                        "RenderEvent 169 122 0 0 0 0 0\n"
                                        "MouseMoveEvent 169 124 0 0 0 0 0\n"
                                        "RenderEvent 169 124 0 0 0 0 0\n"
                                        "MouseMoveEvent 169 127 0 0 0 0 0\n"
                                        "RenderEvent 169 127 0 0 0 0 0\n"
                                        "MouseMoveEvent 168 129 0 0 0 0 0\n"
                                        "RenderEvent 168 129 0 0 0 0 0\n"
                                        "MouseMoveEvent 167 130 0 0 0 0 0\n"
                                        "RenderEvent 167 130 0 0 0 0 0\n"
                                        "MouseMoveEvent 165 132 0 0 0 0 0\n"
                                        "RenderEvent 165 132 0 0 0 0 0\n"
                                        "MouseMoveEvent 164 133 0 0 0 0 0\n"
                                        "RenderEvent 164 133 0 0 0 0 0\n"
                                        "MouseMoveEvent 163 134 0 0 0 0 0\n"
                                        "RenderEvent 163 134 0 0 0 0 0\n"
                                        "MouseMoveEvent 161 136 0 0 0 0 0\n"
                                        "RenderEvent 161 136 0 0 0 0 0\n"
                                        "MouseMoveEvent 159 137 0 0 0 0 0\n"
                                        "RenderEvent 159 137 0 0 0 0 0\n"
                                        "MouseMoveEvent 157 138 0 0 0 0 0\n"
                                        "RenderEvent 157 138 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 139 0 0 0 0 0\n"
                                        "RenderEvent 153 139 0 0 0 0 0\n"
                                        "MouseMoveEvent 151 140 0 0 0 0 0\n"
                                        "RenderEvent 151 140 0 0 0 0 0\n"
                                        "MouseMoveEvent 148 141 0 0 0 0 0\n"
                                        "RenderEvent 148 141 0 0 0 0 0\n"
                                        "MouseMoveEvent 146 142 0 0 0 0 0\n"
                                        "RenderEvent 146 142 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 144 0 0 0 0 0\n"
                                        "RenderEvent 144 144 0 0 0 0 0\n"
                                        "MouseMoveEvent 142 144 0 0 0 0 0\n"
                                        "RenderEvent 142 144 0 0 0 0 0\n"
                                        "MouseMoveEvent 141 144 0 0 0 0 0\n"
                                        "RenderEvent 141 144 0 0 0 0 0\n"
                                        "MouseMoveEvent 140 143 0 0 0 0 0\n"
                                        "RenderEvent 140 143 0 0 0 0 0\n"
                                        "MouseMoveEvent 139 143 0 0 0 0 0\n"
                                        "RenderEvent 139 143 0 0 0 0 0\n"
                                        "MouseMoveEvent 139 142 0 0 0 0 0\n"
                                        "RenderEvent 139 142 0 0 0 0 0\n"
                                        "MouseMoveEvent 138 142 0 0 0 0 0\n"
                                        "RenderEvent 138 142 0 0 0 0 0\n"
                                        "MouseMoveEvent 138 141 0 0 0 0 0\n"
                                        "RenderEvent 138 141 0 0 0 0 0\n"
                                        "MouseMoveEvent 138 140 0 0 0 0 0\n"
                                        "RenderEvent 138 140 0 0 0 0 0\n"
                                        "MouseMoveEvent 138 139 0 0 0 0 0\n"
                                        "RenderEvent 138 139 0 0 0 0 0\n"
                                        "MouseMoveEvent 138 140 0 0 0 0 0\n"
                                        "RenderEvent 138 140 0 0 0 0 0\n"
                                        "MouseMoveEvent 139 140 0 0 0 0 0\n"
                                        "RenderEvent 139 140 0 0 0 0 0\n"
                                        "MouseMoveEvent 139 141 0 0 0 0 0\n"
                                        "RenderEvent 139 141 0 0 0 0 0\n"
                                        "MouseMoveEvent 140 141 0 0 0 0 0\n"
                                        "RenderEvent 140 141 0 0 0 0 0\n"
                                        "MouseMoveEvent 140 142 0 0 0 0 0\n"
                                        "RenderEvent 140 142 0 0 0 0 0\n"
                                        "MouseMoveEvent 141 142 0 0 0 0 0\n"
                                        "RenderEvent 141 142 0 0 0 0 0\n"
                                        "MouseMoveEvent 141 143 0 0 0 0 0\n"
                                        "RenderEvent 141 143 0 0 0 0 0\n"
                                        "MouseMoveEvent 142 143 0 0 0 0 0\n"
                                        "RenderEvent 142 143 0 0 0 0 0\n"
                                        "MouseMoveEvent 142 144 0 0 0 0 0\n"
                                        "RenderEvent 142 144 0 0 0 0 0\n"
                                        "LeftButtonReleaseEvent 142 144 0 0 0 0 0\n";

int TestBorderWidget(int, char*[])
{
  // Create the RenderWindow, Renderer and both Actors
  //
  vtkSmartPointer<vtkRenderer> ren1 = vtkSmartPointer<vtkRenderer>::New();
  vtkSmartPointer<vtkRenderWindow> renWin = vtkSmartPointer<vtkRenderWindow>::New();
  renWin->AddRenderer(ren1);

  vtkSmartPointer<vtkRenderWindowInteractor> iren =
    vtkSmartPointer<vtkRenderWindowInteractor>::New();
  iren->SetRenderWindow(renWin);

  // Create a test pipeline
  //
  vtkSmartPointer<vtkSphereSource> ss = vtkSmartPointer<vtkSphereSource>::New();
  vtkSmartPointer<vtkPolyDataMapper> mapper = vtkSmartPointer<vtkPolyDataMapper>::New();
  mapper->SetInputConnection(ss->GetOutputPort());
  vtkSmartPointer<vtkActor> actor = vtkSmartPointer<vtkActor>::New();
  actor->SetMapper(mapper);

  // Create the widget and its representation
  vtkSmartPointer<vtkBorderRepresentation> rep = vtkSmartPointer<vtkBorderRepresentation>::New();
  rep->ProportionalResizeOn();
  rep->SetShowBorderToOn();

  vtkSmartPointer<vtkBorderWidget> widget = vtkSmartPointer<vtkBorderWidget>::New();
  widget->SetInteractor(iren);
  widget->SetRepresentation(rep);
  widget->SelectableOff();

  // Add the actors to the renderer, set the background and size
  //
  ren1->AddActor(actor);
  ren1->SetBackground(0.1, 0.2, 0.4);
  renWin->SetSize(300, 300);

  // record events
  vtkSmartPointer<vtkInteractorEventRecorder> recorder =
    vtkSmartPointer<vtkInteractorEventRecorder>::New();
  recorder->SetInteractor(iren);

#ifdef RECORD
  recorder->SetFileName("record.log");
  recorder->On();
  recorder->Record();
#else
  recorder->ReadFromInputStringOn();
  recorder->SetInputString(BorderWidgetEventLog);
#endif
  // render the image
  //
  iren->Initialize();
  renWin->Render();
  widget->On();

  // Remove the observers so we can go interactive. Without this the "-I"
  // testing option fails.

#ifndef RECORD
  recorder->Play();
  recorder->Off();
#endif

  iren->Start();

  return EXIT_SUCCESS;
}
