/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.util;

public class FloatArray {
    private static final int DEFAULT_SIZE = 512;
    private static final int INCREMENT_SIZE = 256;
    private int valueCount;
    private float[] array;

    public FloatArray() {
        this(512);
    }

    public FloatArray(int n) {
        this.array = new float[n];
        this.valueCount = 0;
    }

    public int size() {
        return this.valueCount;
    }

    public void clear() {
        this.valueCount = 0;
    }

    public void add(float f) {
        if (this.valueCount == this.array.length) {
            float[] fArray = new float[this.array.length + 256];
            System.arraycopy(this.array, 0, fArray, 0, this.array.length);
            this.array = fArray;
        }
        this.array[this.valueCount++] = f;
    }

    public void add(float[] fArray) {
        int n = this.valueCount + fArray.length;
        if (n >= this.array.length) {
            float[] fArray2 = new float[n];
            System.arraycopy(this.array, 0, fArray2, 0, this.array.length);
            this.array = fArray2;
        }
        System.arraycopy(fArray, 0, this.array, this.valueCount, fArray.length);
        this.valueCount = n;
    }

    public float get(int n) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[n];
    }

    public void set(int n, float f) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        this.array[n] = f;
    }

    public float remove(int n) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        float f = this.array[n];
        System.arraycopy(this.array, n + 1, this.array, n, this.array.length - n - 1);
        --this.valueCount;
        return f;
    }

    public float[] toArray() {
        float[] fArray = new float[this.valueCount];
        System.arraycopy(this.array, 0, fArray, 0, this.valueCount);
        return fArray;
    }

    public float[] toArray(float[] fArray) {
        float[] fArray2 = null;
        fArray2 = fArray.length >= this.valueCount ? fArray : new float[this.valueCount];
        System.arraycopy(this.array, 0, fArray2, 0, this.valueCount);
        return fArray2;
    }
}

