---
title: Website
date: 2018-05-04 16:35
markdown:
  gfm: false
---

In order to make the SENSEI website more dynamic, we will start using github pages to host the website.
The website is generated from files in the `doc` directory of the sensei repository.

The process for updating the website is:

+ Ensure you have installed [nodejs][] and [npm][] and run the one-time setup command:
  `npm install` from the `doc` directory of your sensei clone.
  This will create a `node_modules` directory inside `doc` containing
  javascript libraries needed to generate and publish the website.
  You only need to do this once per clone of sensei.
+ Add new files to the `doc/content` directory as needed (more on this below).
+ Test the new website by running `npm run doc:www` and visit http://127.0.0.1:4000/
  in your web browser. Verify that the page you've added or edited appears properly.
+ Commit your changes to the master branch of sense by submitting a merge request.
+ Once the changes are in master, you should _publish_ the changes to the `gh-pages`
  branch of the repository. For the moment, this is a manual process: run
  `npm run doc:publish` in the `doc` directory of your clone.

## Adding new files

First of all, **do not add large or binary files** to the repository.
If you want to include images, link to PDFs, etc. then upload them
to the [sensei in situ collection][] on https://data.kitware.com/
and reference them by URL in the markdown files you add here.

There are several kinds of files you might wish to add to sensei:

+ To add a blog post, simply add a new markdown file in `doc/content/_posts`.
  If you put a header at the top of the file like so:
  ```
  ---
  date: 2018-05-04 16:48:00
  ---
  Markdown for page starts here
  ```
  then the generated website will preserve the date of the original post even
  if the file is later changed.
+ To add a static page to the introductory (_Learn more_) or developer (_Develop_)
  sections, you will need to
    + Add a new file to the `doc/content/learn-more` or `doc/content/develop` directories.
    + Add an entries to the `doc/tpl/__en__` and `doc/tpl/__sidebar__` files that
      map the filename to a title to show in the sidebar links of the website.
+ To add a new section to the links at the top of the website (a sibling to the
  _Learn more_ and _Develop_ links), you'll need to do the above _plus_ add an entry
  to the `doc/data/menu.yml` file.

For more information about formatting files, see the
[Markdown](https://daringfireball.net/projects/markdown/) and
[Hexo](https://hexo.io/docs/writing.html) documentation.
Markdown is the format we use for pages while Hexo is the
javascript package that kw-doc uses to process the markdown
content into HTML.

## Description of documentation files

+ `package.json` and `package-lock.json` are files that specify which javascript packages
  are needed to generate and publish the documentation.
+ `doc/config.js` is javascript declaring website-wide configuration.
+ `doc/data/menu.yml` declares links at the top of each web page on the site.
+ `doc/tpl/__sidebar__` organizes the sidebar links for static sections of the website.
+ `doc/tpl/__en__` maps filenames and sidebar names into different languages/locales.
+ `doc/content/index.jade` is a template used to construct the front page of the website.

[nodejs]: https://nodejs.org/
[npm]: https://npmjs.org/
[sensei in situ collection]: https://data.kitware.com/#collection/5a007cb58d777f31ac64ddfd
