/*=========================================================================

   Library: iMSTK

   Copyright (c) Kitware, Inc. & Center for Modeling, Simulation,
   & Imaging in Medicine, Rensselaer Polytechnic Institute.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0.txt

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

=========================================================================*/

#ifndef imstkIBLProbe_h
#define imstkIBLProbe_h

#include <string>

#include "imstkTexture.h"

namespace imstk
{
class IBLProbe
{
public:
    IBLProbe() {};

    void initialize(std::string irradianceCubemapPath,
                    std::string radianceCubemapPath,
                    std::string brdfLUTPath);

    std::shared_ptr<Texture> getIrradianceCubemapTexture();
    std::shared_ptr<Texture> getRadianceCubemapTexture();
    std::shared_ptr<Texture> getBrdfLUTTexture();

protected:
    std::string m_irradianceCubemapPath;
    std::string m_radianceCubemapPath;
    std::string m_brdfLUTPath;

    std::shared_ptr<Texture> m_irradianceCubemapTexture = nullptr;
    std::shared_ptr<Texture> m_radianceCubemapTexture = nullptr;
    std::shared_ptr<Texture> m_brdfLUTTexture = nullptr;
};
}

#endif