// This file is part of the SimMedTK project.
// Copyright (c) Center for Modeling, Simulation, and Imaging in Medicine,
//                        Rensselaer Polytechnic Institute
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//---------------------------------------------------------------------------
//
// Authors:
//
// Contact:
//---------------------------------------------------------------------------

#ifndef SMKEY_H
#define SMKEY_H

#include "Core/Config.h"

namespace mstk {
namespace Event {

enum class smModKey : unsigned int
{
    none = 0,
    control = 1,
    alt = 2,
    super = 4,
    shift = 8
};

inline smModKey operator|(smModKey a, smModKey b)
{
    return static_cast<smModKey>(static_cast<unsigned int>(a) | static_cast<unsigned int>(b));
}

inline smModKey operator&(smModKey a, smModKey b)
{
    return static_cast<smModKey>(static_cast<unsigned int>(a) & static_cast<unsigned int>(b));
}

inline smModKey& operator |=(smModKey& a, smModKey b)
{
    return a = a | b;
}

inline smModKey& operator &=(smModKey& a, smModKey b)
{
    return a = a & b;
}

enum class smKey
{
    Unknown = -1,     ///< Unhandled key
    A = 0,            ///< The A key
    B,                ///< The B key
    C,                ///< The C key
    D,                ///< The D key
    E,                ///< The E key
    F,                ///< The F key
    G,                ///< The G key
    H,                ///< The H key
    I,                ///< The I key
    J,                ///< The J key
    K,                ///< The K key
    L,                ///< The L key
    M,                ///< The M key
    N,                ///< The N key
    O,                ///< The O key
    P,                ///< The P key
    Q,                ///< The Q key
    R,                ///< The R key
    S,                ///< The S key
    T,                ///< The T key
    U,                ///< The U key
    V,                ///< The V key
    W,                ///< The W key
    X,                ///< The X key
    Y,                ///< The Y key
    Z,                ///< The Z key
    Num0,             ///< The 0 key
    Num1,             ///< The 1 key
    Num2,             ///< The 2 key
    Num3,             ///< The 3 key
    Num4,             ///< The 4 key
    Num5,             ///< The 5 key
    Num6,             ///< The 6 key
    Num7,             ///< The 7 key
    Num8,             ///< The 8 key
    Num9,             ///< The 9 key
    Escape,           ///< The Escape key
    LControl,         ///< The left Control key
    LShift,           ///< The left Shift key
    LAlt,             ///< The left Alt key
    LSystem,          ///< The left OS specific key: window (Windows and Linux), apple (MacOS X), ...
    RControl,         ///< The right Control key
    RShift,           ///< The right Shift key
    RAlt,             ///< The right Alt key
    RSystem,          ///< The right OS specific key: window (Windows and Linux), apple (MacOS X), ...
    Menu,             ///< The Menu key
    LBracket,         ///< The [ key
    RBracket,         ///< The ] key
    SemiColon,        ///< The ; key
    Comma,            ///< The , key
    Period,           ///< The . key
    Quote,            ///< The ' key
    Slash,            ///< The / key
    BackSlash,        ///< The \ key
    Tilde,            ///< The ~ key
    Equal,            ///< The = key
    Dash,             ///< The - key
    Space,            ///< The Space key
    Return,           ///< The Return key
    BackSpace,        ///< The Backspace key
    Tab,              ///< The Tabulation key
    PageUp,           ///< The Page up key
    PageDown,         ///< The Page down key
    End,              ///< The End key
    Home,             ///< The Home key
    Insert,           ///< The Insert key
    Delete,           ///< The Delete key
    Add,              ///< The + key
    Subtract,         ///< The - key
    Multiply,         ///< The * key
    Divide,           ///< The / key
    Left,             ///< Left arrow
    Right,            ///< Right arrow
    Up,               ///< Up arrow
    Down,             ///< Down arrow
    Numpad0,          ///< The numpad 0 key
    Numpad1,          ///< The numpad 1 key
    Numpad2,          ///< The numpad 2 key
    Numpad3,          ///< The numpad 3 key
    Numpad4,          ///< The numpad 4 key
    Numpad5,          ///< The numpad 5 key
    Numpad6,          ///< The numpad 6 key
    Numpad7,          ///< The numpad 7 key
    Numpad8,          ///< The numpad 8 key
    Numpad9,          ///< The numpad 9 key
    F1,               ///< The F1 key
    F2,               ///< The F2 key
    F3,               ///< The F3 key
    F4,               ///< The F4 key
    F5,               ///< The F5 key
    F6,               ///< The F6 key
    F7,               ///< The F7 key
    F8,               ///< The F8 key
    F9,               ///< The F9 key
    F10,              ///< The F10 key
    F11,              ///< The F11 key
    F12,              ///< The F12 key
    F13,              ///< The F13 key
    F14,              ///< The F14 key
    F15,              ///< The F15 key
    Pause,            ///< The Pause key
    Backtick,         ///< The ` key
    KeyCount          ///< Keep last -- the total number of keyboard keys
};

} // Event namespace
} // mstk namespace

#endif
