/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.device.jinput;

import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Rumbler;
import org.xj3d.device.GamepadDevice;
import org.xj3d.device.GamepadState;
import org.xj3d.device.Tracker;
import org.xj3d.device.TrackerDevice;
import org.xj3d.device.jinput.AxisTracker;

public class Gamepad
implements GamepadDevice,
TrackerDevice {
    private static final float DEVICE_THRESHOLD = 0.02f;
    private Controller controller;
    private String name;
    private Tracker[] trackers;
    private int[] controllerFuncs;
    private Component[] axes;
    private float[] lastVals;
    private Rumbler rumblerX;
    private Rumbler rumblerY;
    private int[] rumblerFuncs;

    public Gamepad(Controller controller, String string) {
        this.controller = controller;
        this.name = string;
        this.axes = controller.getComponents();
        this.trackers = new Tracker[1];
        Component[] componentArray = new Component[2];
        int[] nArray = new int[2];
        this.controllerFuncs = new int[this.axes.length];
        this.lastVals = new float[this.axes.length];
        int n = this.axes.length;
        for (int i = 0; i < n; ++i) {
            System.out.println("   axes: " + this.axes[i].getName() + " type: " + this.axes[i].getIdentifier().getName());
            String string2 = this.axes[i].getName();
            if (string2.equalsIgnoreCase("X axis") || string2.equals("x")) {
                componentArray[0] = this.axes[i];
                nArray[0] = 1;
                this.controllerFuncs[i] = 6;
                continue;
            }
            if (string2.equalsIgnoreCase("Y axis") || string2.equals("y")) {
                componentArray[1] = this.axes[i];
                nArray[1] = 2;
                this.controllerFuncs[i] = 7;
                continue;
            }
            if (string2.equals("Rudder")) {
                this.controllerFuncs[i] = 8;
                continue;
            }
            if (string2.equals("Z Rotation")) {
                this.controllerFuncs[i] = 8;
                continue;
            }
            if (string2.equals("Z Axis")) {
                System.out.println("Z Axis mapped");
                this.controllerFuncs[i] = 9;
                continue;
            }
            if (string2.equals("Extra")) {
                this.controllerFuncs[i] = 9;
                continue;
            }
            if (string2.equals("Throttle")) {
                this.controllerFuncs[i] = 0;
                continue;
            }
            if (string2.equals("S Button")) {
                this.controllerFuncs[i] = 13;
                continue;
            }
            if (string2.equals("Left Trigger")) {
                this.controllerFuncs[i] = 11;
                continue;
            }
            if (string2.equals("Right Trigger")) {
                this.controllerFuncs[i] = 12;
                continue;
            }
            if (string2.equals("Button 4")) {
                this.controllerFuncs[i] = 11;
                continue;
            }
            if (string2.equals("Button 5")) {
                this.controllerFuncs[i] = 12;
                continue;
            }
            if (string2.equals("Hat Switch")) {
                this.controllerFuncs[i] = 10;
                continue;
            }
            System.out.println("Could not map: " + string2);
            this.controllerFuncs[i] = -1;
        }
        AxisTracker axisTracker = new AxisTracker(componentArray, nArray);
        this.trackers[0] = axisTracker;
        Rumbler[] rumblerArray = controller.getRumblers();
        n = rumblerArray.length;
        this.rumblerFuncs = new int[rumblerArray.length];
        System.out.println("Rumblers:");
        for (int i = 0; i < n; ++i) {
            string = rumblerArray[i].getAxisName();
            Component.Identifier identifier = rumblerArray[i].getAxisIdentifier();
            if (string == null) {
                if (this.rumblerX == null) {
                    this.rumblerX = rumblerArray[i];
                    continue;
                }
                if (this.rumblerY != null) continue;
                this.rumblerX = rumblerArray[i];
                continue;
            }
            if (string.equals("X axis")) {
                this.rumblerX = rumblerArray[i];
                continue;
            }
            if (!string.equals("Y axis")) continue;
            this.rumblerY = rumblerArray[i];
        }
    }

    public String getName() {
        return this.name;
    }

    public void getState(GamepadState gamepadState) {
        this.controller.poll();
        int n = this.axes.length;
        block11: for (int i = 0; i < n; ++i) {
            float f = this.axes[i].getPollData();
            if (Math.abs(this.lastVals[i] - f) < 0.02f) continue;
            this.lastVals[i] = f;
            switch (this.controllerFuncs[i]) {
                case 6: {
                    gamepadState.leftStickX = f;
                    gamepadState.leftStickX_changed = true;
                    continue block11;
                }
                case 7: {
                    gamepadState.leftStickY = -f;
                    gamepadState.leftStickY_changed = true;
                    continue block11;
                }
                case 8: {
                    gamepadState.rightStickX = f;
                    gamepadState.rightStickX_changed = true;
                    continue block11;
                }
                case 9: {
                    gamepadState.rightStickY = -f;
                    gamepadState.rightStickY_changed = true;
                    continue block11;
                }
                case 10: {
                    if (f == 1.0f) {
                        gamepadState.leftHatX = -1.0f;
                        gamepadState.leftHatX_changed = true;
                        gamepadState.leftHatY = 0.0f;
                        gamepadState.leftHatY_changed = true;
                        continue block11;
                    }
                    if (f == 0.875f) {
                        gamepadState.leftHatX = -0.5f;
                        gamepadState.leftHatX_changed = true;
                        gamepadState.leftHatY = 0.5f;
                        gamepadState.leftHatY_changed = true;
                        continue block11;
                    }
                    if (f == 0.75f) {
                        gamepadState.leftHatX = 0.0f;
                        gamepadState.leftHatX_changed = true;
                        gamepadState.leftHatY = 1.0f;
                        gamepadState.leftHatY_changed = true;
                        continue block11;
                    }
                    if (f == 0.625f) {
                        gamepadState.leftHatX = 0.5f;
                        gamepadState.leftHatX_changed = true;
                        gamepadState.leftHatY = 0.5f;
                        gamepadState.leftHatY_changed = true;
                        continue block11;
                    }
                    if (f == 0.5f) {
                        gamepadState.leftHatX = 1.0f;
                        gamepadState.leftHatX_changed = true;
                        gamepadState.leftHatY = 0.0f;
                        gamepadState.leftHatY_changed = true;
                        continue block11;
                    }
                    if (f == 0.375f) {
                        gamepadState.leftHatX = 0.5f;
                        gamepadState.leftHatX_changed = true;
                        gamepadState.leftHatY = -0.5f;
                        gamepadState.leftHatY_changed = true;
                        continue block11;
                    }
                    if (f == 0.25f) {
                        gamepadState.leftHatX = 0.0f;
                        gamepadState.leftHatX_changed = true;
                        gamepadState.leftHatY = -1.0f;
                        gamepadState.leftHatY_changed = true;
                        continue block11;
                    }
                    if (f == 0.125f) {
                        gamepadState.leftHatX = -0.5f;
                        gamepadState.leftHatX_changed = true;
                        gamepadState.leftHatY = -0.5f;
                        gamepadState.leftHatY_changed = true;
                        continue block11;
                    }
                    gamepadState.leftHatX = 0.0f;
                    gamepadState.leftHatX_changed = true;
                    gamepadState.leftHatY = 0.0f;
                    gamepadState.leftHatY_changed = true;
                    continue block11;
                }
                case 0: {
                    gamepadState.throttleSlider = -f;
                    gamepadState.throttleSlider_changed = true;
                    continue block11;
                }
                case 13: {
                    gamepadState.startButton = f == 1.0f;
                    gamepadState.startButton_changed = true;
                    continue block11;
                }
                case 11: {
                    gamepadState.l1Button = f == 1.0f;
                    gamepadState.l1Button_changed = true;
                    continue block11;
                }
                case 12: {
                    gamepadState.r1Button = f == 1.0f;
                    gamepadState.r1Button_changed = true;
                }
            }
        }
    }

    public void setRumblerX(float f) {
        if (this.rumblerX != null) {
            this.rumblerX.rumble(f);
        }
    }

    public void setRumblerY(float f) {
        if (this.rumblerY != null) {
            this.rumblerY.rumble(f);
        }
    }

    public int getTrackerCount() {
        return this.trackers.length;
    }

    public Tracker[] getTrackers() {
        return this.trackers;
    }
}

